/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientSessions;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class OLiveCommandResultListener
extends OAbstractCommandResultListener
implements OLiveResultListener {
    private ONetworkProtocolBinary protocol;
    private final AtomicBoolean empty = new AtomicBoolean(true);
    private final int txId;
    private final Set<ORID> alreadySent = new HashSet<ORID>();
    private OClientSessions session;

    public OLiveCommandResultListener(ONetworkProtocolBinary iNetworkProtocolBinary, int txId, OCommandResultListener wrappedResultListener) {
        super(wrappedResultListener);
        this.protocol = iNetworkProtocolBinary;
        this.session = iNetworkProtocolBinary.getServer().getClientConnectionManager().getSession(iNetworkProtocolBinary);
        this.txId = txId;
    }

    public boolean result(Object iRecord) {
        if (this.empty.compareAndSet(true, false)) {
            try {
                this.protocol.sendOk(this.txId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.fetchRecord(iRecord, (OFetchListener)new ORemoteFetchListener(){

                protected void sendRecord(ORecord iLinked) {
                    if (!OLiveCommandResultListener.this.alreadySent.contains(iLinked.getIdentity())) {
                        OLiveCommandResultListener.this.alreadySent.add(iLinked.getIdentity());
                        try {
                            ((OLiveCommandResultListener)OLiveCommandResultListener.this).protocol.channel.writeByte((byte)2);
                            OLiveCommandResultListener.this.protocol.writeIdentifiable((OIdentifiable)iLinked);
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Cannot write against channel", (Throwable)e, new Object[0]);
                        }
                    }
                }
            });
            this.alreadySent.add(((OIdentifiable)iRecord).getIdentity());
            this.protocol.channel.writeByte((byte)1);
            this.protocol.writeIdentifiable((OIdentifiable)((OIdentifiable)iRecord).getRecord());
            this.protocol.channel.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.empty.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLiveResult(int iToken, ORecordOperation iOp) throws OException {
        boolean sendFail = true;
        do {
            OChannelBinaryServer channel = this.protocol.channel;
            try {
                channel.acquireWriteLock();
                try {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(content);
                    out.writeByte(114);
                    out.writeByte(iOp.type);
                    out.writeInt(iToken);
                    out.writeByte(ORecordInternal.getRecordType((ORecord)iOp.getRecord()));
                    this.writeVersion(out, iOp.getRecord().getVersion());
                    this.writeRID(out, (ORecordId)iOp.getRecord().getIdentity());
                    this.writeBytes(out, this.protocol.getRecordBytes(iOp.getRecord()));
                    channel.writeByte((byte)3);
                    channel.writeInt(Integer.MIN_VALUE);
                    channel.writeByte((byte)81);
                    channel.writeBytes(content.toByteArray());
                    channel.flush();
                }
                finally {
                    channel.releaseWriteLock();
                }
                sendFail = false;
            }
            catch (IOException e) {
                List<OClientConnection> connections = this.session.getConnections();
                if (connections.isEmpty()) {
                    OLiveQueryHook.unsubscribe((Integer)iToken, (ODatabaseInternal)this.protocol.connection.database);
                    break;
                }
                this.protocol = (ONetworkProtocolBinary)connections.get(0).getProtocol();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to the client %s", (Throwable)e, new Object[]{this.protocol.connection.getRemoteAddress()});
                this.protocol.getServer().getClientConnectionManager().disconnect(this.protocol.connection);
                OLiveQueryHook.unsubscribe((Integer)iToken, (ODatabaseInternal)this.protocol.connection.database);
                break;
            }
        } while (sendFail);
    }

    public void onError(int iLiveToken) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnsubscribe(int iLiveToken) {
        boolean sendFail = true;
        do {
            OChannelBinaryServer channel = this.protocol.channel;
            try {
                channel.acquireWriteLock();
                try {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(content);
                    out.writeByte(117);
                    out.writeInt(iLiveToken);
                    channel.writeByte((byte)3);
                    channel.writeInt(Integer.MIN_VALUE);
                    channel.writeByte((byte)81);
                    channel.writeBytes(content.toByteArray());
                    channel.flush();
                }
                finally {
                    channel.releaseWriteLock();
                }
                sendFail = false;
            }
            catch (IOException e) {
                List<OClientConnection> connections = this.session.getConnections();
                if (connections.isEmpty()) break;
                this.protocol = (ONetworkProtocolBinary)connections.get(0).getProtocol();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to the client %s", (Throwable)e, new Object[]{this.protocol.connection.getRemoteAddress()});
                this.protocol.getServer().getClientConnectionManager().disconnect(this.protocol.connection);
                break;
            }
        } while (sendFail);
    }

    private void writeVersion(DataOutputStream out, int v) throws IOException {
        out.writeInt(v);
    }

    private void writeRID(DataOutputStream out, ORecordId record) throws IOException {
        out.writeShort((short)record.getClusterId());
        out.writeLong(record.getClusterPosition());
    }

    public void writeBytes(DataOutputStream out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }
}

