/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;

public abstract class OAbstractRecordReplicatedTask
extends OAbstractReplicatedTask {
    protected ORecordId rid;
    protected int version;
    protected int partitionKey = -1;
    protected boolean lockRecords = true;
    protected transient ORecord previousRecord;

    public OAbstractRecordReplicatedTask() {
    }

    protected OAbstractRecordReplicatedTask(ORecord record) {
        this((ORecordId)record.getIdentity(), record.getVersion());
    }

    protected OAbstractRecordReplicatedTask(ORecordId iRid, int iVersion) {
        Set indexes;
        OClass clazz;
        this.rid = iRid;
        this.version = iVersion;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && (clazz = db.getMetadata().getSchema().getClassByClusterId(this.rid.clusterId)) != null && (indexes = clazz.getIndexes()) != null && !indexes.isEmpty()) {
            for (OIndex idx : indexes) {
                if (!idx.isUnique()) continue;
                this.partitionKey = idx.getName().hashCode();
            }
        }
    }

    public abstract Object executeRecordTask(ODistributedRequestId var1, OServer var2, ODistributedServerManager var3, ODatabaseDocumentTx var4) throws Exception;

    public abstract ORecord getRecord();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        if (this.lockRecords && !ddb.lockRecord((OIdentifiable)this.rid, requestId)) {
            throw new ODistributedRecordLockedException((ORID)this.rid);
        }
        try {
            Object object = this.executeRecordTask(requestId, iServer, iManager, database);
            return object;
        }
        finally {
            if (this.lockRecords) {
                ddb.unlockRecord((OIdentifiable)this.rid, requestId);
            }
        }
    }

    @Override
    public int getPartitionKey() {
        return this.partitionKey > -1 ? this.partitionKey : this.rid.clusterId;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.rid + " v." + this.version + ")";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public int getVersion() {
        return this.version;
    }

    protected boolean checkForClusterAvailability(String localNode, ODistributedConfiguration cfg) {
        String clusterName = ODatabaseRecordThreadLocal.INSTANCE.get().getClusterNameById(this.rid.clusterId);
        return cfg.hasCluster(localNode, clusterName);
    }

    public void prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult loaded = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying().readRecord(this.rid, null, true, null);
            if (loaded == null || loaded.getResult() == null) {
                throw new ORecordNotFoundException((ORID)this.rid);
            }
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)loaded.getResult()).recordType);
            ORecordInternal.fill((ORecord)this.previousRecord, (ORID)this.rid, (int)((ORawBuffer)loaded.getResult()).version, (byte[])((ORawBuffer)loaded.getResult()).getBuffer(), (boolean)false);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        out.writeInt(this.version);
        out.writeInt(this.partitionKey);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        this.version = in.readInt();
        this.partitionKey = in.readInt();
    }

    public void setLockRecords(boolean lockRecords) {
        this.lockRecords = lockRecords;
    }

    @Override
    public String getPayload() {
        return "rid=" + this.rid + " v=" + this.version;
    }
}

