/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;

public abstract class OAbstractRemoteTask
implements ORemoteTask {
    private static final long serialVersionUID = 1L;
    protected transient String nodeSource;

    @Override
    public abstract String getName();

    @Override
    public abstract OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType();

    @Override
    public abstract Object execute(ODistributedRequestId var1, OServer var2, ODistributedServerManager var3, ODatabaseDocumentTx var4) throws Exception;

    @Override
    public int getPartitionKey() {
        return -1;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public long getSynchronousTimeout(int iSynchNodes) {
        return this.getDistributedTimeout() * (long)iSynchNodes;
    }

    @Override
    public long getTotalTimeout(int iTotalNodes) {
        return this.getDistributedTimeout() * (long)iTotalNodes;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getNodeSource() {
        return this.nodeSource;
    }

    @Override
    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }
}

