/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostImportDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostUploadSingleFile;
import java.io.IOException;
import java.net.Socket;

public class ONetworkProtocolHttpDb
extends ONetworkProtocolHttpAbstract {
    private static final String ORIENT_SERVER_DB = "OrientDB Server v." + OConstants.getVersion();
    private static final int CURRENT_PROTOCOL_VERSION = 10;

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfiguration) throws IOException {
        this.server = iServer;
        this.setName("OrientDB HTTP Connection " + iSocket.getLocalAddress() + ":" + iSocket.getLocalPort() + "<-" + iSocket.getRemoteSocketAddress());
        super.config(iListener, this.server, iSocket, iConfiguration);
        this.cmdManager.registerCommand(new OServerCommandPostImportDatabase());
        this.cmdManager.registerCommand(new OServerCommandPostUploadSingleFile());
        this.connection.getData().serverInfo = ORIENT_SERVER_DB;
    }

    @Override
    public int getVersion() {
        return 10;
    }

    @Override
    public String getType() {
        return "http";
    }

    protected void afterExecution() throws InterruptedException {
        ODatabaseRecordThreadLocal.INSTANCE.remove();
    }
}

