/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDocument
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|document/*", "HEAD|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabaseDocumentTx db = null;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: document/<database>/<record-id>[/fetchPlan]");
        String fetchPlan = urlParts.length > 3 ? urlParts[3] : null;
        iRequest.data.commandInfo = "Load document";
        int parametersPos = urlParts[2].indexOf(63);
        String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            ORecord rec = db.load((ORID)new ORecordId(rid), fetchPlan);
            if (rec == null) {
                iResponse.send(404, "Not Found", "application/json", "Record with id '" + urlParts[2] + "' was not found.", null);
            } else if (iRequest.httpMethod.equals("HEAD")) {
                iResponse.send(200, "OK", null, null, "ETag: " + rec.getVersion());
            } else {
                String ifNoneMatch = iRequest.getHeader("If-None-Match");
                if (ifNoneMatch != null && Integer.toString(rec.getVersion()).equals(ifNoneMatch)) {
                    iResponse.send(304, "Not Modified", null, null, "ETag: " + rec.getVersion());
                }
                iResponse.writeRecord(rec, fetchPlan, null);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

