/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityExternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OInvalidPasswordException;
import com.orientechnologies.orient.core.security.OSecurityFactory;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.security.OSecuritySystemException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.security.OAuditingService;
import com.orientechnologies.orient.server.security.OPasswordValidator;
import com.orientechnologies.orient.server.security.OSecurityAuthenticator;
import com.orientechnologies.orient.server.security.OSecurityComponent;
import com.orientechnologies.orient.server.security.OServerSecurity;
import com.orientechnologies.orient.server.security.OSyslog;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ODefaultServerSecurity
implements OSecurityFactory,
OServerLifecycleListener,
OServerSecurity {
    private boolean _Enabled = false;
    private boolean _Debug = false;
    private boolean _CreateDefaultUsers = true;
    private boolean _StorePasswords = true;
    private boolean _AllowDefault = true;
    private Object _PasswordValidatorSynch = new Object();
    private OPasswordValidator _PasswordValidator;
    private Object _ImportLDAPSynch = new Object();
    private OSecurityComponent _ImportLDAP;
    private Object _AuditingSynch = new Object();
    private OAuditingService _AuditingService;
    private Object _SyslogSynch = new Object();
    private OSyslog _Syslog;
    private ODocument _ConfigDoc;
    private OServer _Server;
    private OServerConfigurationManager _ServerConfig;
    private ODocument _SyslogDoc;
    private ODocument _AuditingDoc;
    private ODocument _ServerDoc;
    private ODocument _AuthDoc;
    private ODocument _PasswdValDoc;
    private ODocument _LDAPImportDoc;
    private final String _SuperUser = "OSecurityModuleSuperUser";
    private String _SuperUserPassword;
    private OServerUserConfiguration _SuperUserCfg;
    private final List<OSecurityAuthenticator> _AuthenticatorsList = new ArrayList<OSecurityAuthenticator>();
    private ConcurrentHashMap<String, Class<?>> _SecurityClassMap = new ConcurrentHashMap();

    protected OServer getServer() {
        return this._Server;
    }

    public ODefaultServerSecurity(OServer oServer, OServerConfigurationManager serverCfg) {
        this._Server = oServer;
        this._ServerConfig = serverCfg;
        oServer.registerLifecycleListener(this);
    }

    private Class<?> getClass(ODocument jsonConfig) {
        Class<?> cls = null;
        try {
            if (jsonConfig.containsField("class")) {
                String clsName = (String)jsonConfig.field("class");
                cls = this._SecurityClassMap.containsKey(clsName) ? this._SecurityClassMap.get(clsName) : Class.forName(clsName);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getClass() Throwable: ", th, new Object[0]);
        }
        return cls;
    }

    public boolean isDefaultAllowed() {
        if (this.isEnabled()) {
            return this._AllowDefault;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String username, String password) {
        try {
            if (username != null && !username.isEmpty()) {
                if (this._Debug) {
                    OLogManager.instance().info((Object)this, "ODefaultServerSecurity.authenticate() ** Authenticating username: %s", new Object[]{username});
                }
                if (username.equals("OSecurityModuleSuperUser") && password.equals(this._SuperUserPassword)) {
                    return "OSecurityModuleSuperUser";
                }
            }
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                    String principal;
                    if (!sa.isEnabled() || (principal = sa.authenticate(username, password)) == null) continue;
                    return principal;
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.authenticate() Exception: %s", new Object[]{ex.getMessage()});
        }
        return null;
    }

    public boolean areDefaultUsersCreated() {
        if (this.isEnabled()) {
            return this._CreateDefaultUsers;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthenticationHeader(String databaseName) {
        String header = null;
        header = databaseName != null ? "WWW-Authenticate: Basic realm=\"OrientDB db-" + databaseName + "\"" : "WWW-Authenticate: Basic realm=\"OrientDB Server\"";
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                StringBuilder sb = new StringBuilder();
                for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                    String sah;
                    if (!sa.isEnabled() || (sah = sa.getAuthenticationHeader(databaseName)) == null) continue;
                    sb.append(sah);
                    sb.append("\n");
                }
                if (sb.length() > 0) {
                    header = sb.toString();
                }
            }
        }
        return header;
    }

    public ODocument getConfig() {
        ODocument jsonConfig = new ODocument();
        try {
            jsonConfig.field("enabled", (Object)this._Enabled);
            jsonConfig.field("debug", (Object)this._Debug);
            if (this._ServerDoc != null) {
                jsonConfig.field("server", (Object)this._ServerDoc, new OType[]{OType.EMBEDDED});
            }
            if (this._AuthDoc != null) {
                jsonConfig.field("authentication", (Object)this._AuthDoc, new OType[]{OType.EMBEDDED});
            }
            if (this._PasswdValDoc != null) {
                jsonConfig.field("passwordValidator", (Object)this._PasswdValDoc, new OType[]{OType.EMBEDDED});
            }
            if (this._LDAPImportDoc != null) {
                jsonConfig.field("ldapImporter", (Object)this._LDAPImportDoc, new OType[]{OType.EMBEDDED});
            }
            if (this._AuditingDoc != null) {
                jsonConfig.field("auditing", (Object)this._AuditingDoc, new OType[]{OType.EMBEDDED});
            }
            if (this._SyslogDoc != null) {
                jsonConfig.field("syslog", (Object)this._SyslogDoc, new OType[]{OType.EMBEDDED});
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getConfig() Exception: %s", (Throwable)ex, new Object[0]);
        }
        return jsonConfig;
    }

    public ODocument getComponentConfig(String name) {
        if (name != null) {
            if (name.equalsIgnoreCase("auditing")) {
                return this._AuditingDoc;
            }
            if (name.equalsIgnoreCase("authentication")) {
                return this._AuthDoc;
            }
            if (name.equalsIgnoreCase("ldapImporter")) {
                return this._LDAPImportDoc;
            }
            if (name.equalsIgnoreCase("passwordValidator")) {
                return this._PasswdValDoc;
            }
            if (name.equalsIgnoreCase("server")) {
                return this._ServerDoc;
            }
            if (name.equalsIgnoreCase("syslog")) {
                return this._SyslogDoc;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthorized(String username, String resource) {
        if (this.isEnabled()) {
            if (username == null || resource == null) {
                return false;
            }
            if (username.equals("OSecurityModuleSuperUser")) {
                return true;
            }
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                    if (!sa.isEnabled() || !sa.isAuthorized(username, resource)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean arePasswordsStored() {
        if (this.isEnabled()) {
            return this._StorePasswords;
        }
        return true;
    }

    public boolean isSingleSignOnSupported() {
        OSecurityAuthenticator priAuth;
        if (this.isEnabled() && (priAuth = this.getPrimaryAuthenticator()) != null) {
            return priAuth.isSingleSignOnSupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePassword(String password) throws OInvalidPasswordException {
        if (this.isEnabled()) {
            Object object = this._PasswordValidatorSynch;
            synchronized (object) {
                if (this._PasswordValidator != null) {
                    this._PasswordValidator.validatePassword(password);
                }
            }
        }
    }

    @Override
    public OAuditingService getAuditing() {
        return this._AuditingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSecurityAuthenticator getAuthenticator(String authMethod) {
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator am : this._AuthenticatorsList) {
                    if (authMethod == null || authMethod.isEmpty()) {
                        return am;
                    }
                    if (am.getName() == null || !am.getName().equalsIgnoreCase(authMethod)) continue;
                    return am;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSecurityAuthenticator getPrimaryAuthenticator() {
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                if (this._AuthenticatorsList.size() > 0) {
                    return this._AuthenticatorsList.get(0);
                }
            }
        }
        return null;
    }

    @Override
    public OSyslog getSyslog() {
        return this._Syslog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        if (this.isEnabled()) {
            if (username.equals("OSecurityModuleSuperUser")) {
                return this._SuperUserCfg;
            }
            List<OSecurityAuthenticator> list = this._AuthenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                    if (sa.isEnabled() && (userCfg = sa.getUser(username)) != null) break;
                }
            }
        }
        return userCfg;
    }

    @Override
    public ODatabase<?> openDatabase(String dbName) {
        ODatabase<?> db = null;
        if (this.isEnabled()) {
            db = this._Server.openDatabase(dbName, "OSecurityModuleSuperUser", "", null, true);
        }
        return db;
    }

    public void registerSecurityClass(Class<?> cls) {
        String fullTypeName = ODefaultServerSecurity.getFullTypeName(cls);
        if (fullTypeName != null) {
            this._SecurityClassMap.put(fullTypeName, cls);
        }
    }

    public void unregisterSecurityClass(Class<?> cls) {
        String fullTypeName = ODefaultServerSecurity.getFullTypeName(cls);
        if (fullTypeName != null) {
            this._SecurityClassMap.remove(fullTypeName);
        }
    }

    private static String getFullTypeName(Class<?> type) {
        String typeName = null;
        typeName = type.getSimpleName();
        Package pack = type.getPackage();
        if (pack != null) {
            typeName = pack.getName() + "." + typeName;
        }
        return typeName;
    }

    public void reload(String cfgPath) {
        this.reload(this.loadConfig(cfgPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ODocument configDoc) {
        if (configDoc != null) {
            this.onBeforeDeactivate();
            this._ConfigDoc = configDoc;
            this.onAfterActivate();
            Object object = this._AuditingSynch;
            synchronized (object) {
                if (this._AuditingService != null) {
                    this._AuditingService.log("Reload Security", "The security configuration file has been reloaded");
                }
            }
        } else {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reload(ODocument) The provided configuration document is null", new Object[0]);
            throw new OSecuritySystemException("ODefaultServerSecurity.reload(ODocument) The provided configuration document is null");
        }
    }

    public void reloadComponent(String name, ODocument jsonConfig) {
        if (name == null || name.isEmpty()) {
            throw new OSecuritySystemException("ODefaultServerSecurity.reloadComponent() name is null or empty");
        }
        if (jsonConfig == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity.reloadComponent() Configuration document is null");
        }
        if (name.equalsIgnoreCase("auditing")) {
            this._AuditingDoc = jsonConfig;
            this.reloadAuditingService();
        } else if (name.equalsIgnoreCase("authentication")) {
            this._AuthDoc = jsonConfig;
            this.reloadAuthMethods();
        } else if (name.equalsIgnoreCase("ldapImporter")) {
            this._LDAPImportDoc = jsonConfig;
            this.reloadImportLDAP();
        } else if (name.equalsIgnoreCase("passwordValidator")) {
            this._PasswdValDoc = jsonConfig;
            this.reloadPasswordValidator();
        } else if (name.equalsIgnoreCase("server")) {
            this._ServerDoc = jsonConfig;
            this.reloadServer();
        } else if (name.equalsIgnoreCase("syslog")) {
            this._SyslogDoc = jsonConfig;
            this.reloadSyslog();
        }
    }

    private void createSuperUser() {
        if ("OSecurityModuleSuperUser" == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity.createSuperUser() SuperUser cannot be null");
        }
        try {
            this._SuperUserPassword = OSecurityManager.instance().createSHA256(String.valueOf(new Random().nextLong()));
            this._SuperUserCfg = new OServerUserConfiguration("OSecurityModuleSuperUser", this._SuperUserPassword, "*");
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "createSuperUser() Exception: ", (Throwable)ex, new Object[0]);
        }
        if (this._SuperUserPassword == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity Could not create SuperUser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuthenticators(ODocument authDoc) {
        List<OSecurityAuthenticator> list = this._AuthenticatorsList;
        synchronized (list) {
            for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                sa.dispose();
            }
            this._AuthenticatorsList.clear();
            if (authDoc.containsField("authenticators")) {
                List authMethodsList = (List)authDoc.field("authenticators");
                for (ODocument authMethodDoc : authMethodsList) {
                    try {
                        if (authMethodDoc.containsField("name")) {
                            String name = (String)authMethodDoc.field("name");
                            boolean enabled = true;
                            if (authMethodDoc.containsField("enabled")) {
                                enabled = (Boolean)authMethodDoc.field("enabled");
                            }
                            if (!enabled) continue;
                            Class<?> authClass = this.getClass(authMethodDoc);
                            if (authClass != null) {
                                if (OSecurityAuthenticator.class.isAssignableFrom(authClass)) {
                                    OSecurityAuthenticator authPlugin = (OSecurityAuthenticator)authClass.newInstance();
                                    authPlugin.config(this._Server, this._ServerConfig, authMethodDoc);
                                    authPlugin.active();
                                    this._AuthenticatorsList.add(authPlugin);
                                    continue;
                                }
                                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() class is not an OSecurityAuthenticator", new Object[0]);
                                continue;
                            }
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() authentication class is null for %s", new Object[]{name});
                            continue;
                        }
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() authentication object is missing name", new Object[0]);
                    }
                    catch (Throwable ex) {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() Exception: ", ex, new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public void onBeforeActivate() {
        String ssf;
        this.createSuperUser();
        String configFile = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/security.json");
        String securityFile = this.getConfigProperty("server.security.file");
        if (securityFile != null) {
            configFile = securityFile;
        }
        if ((ssf = OGlobalConfiguration.SERVER_SECURITY_FILE.getValueAsString()) != null) {
            configFile = ssf;
        }
        this._ConfigDoc = this.loadConfig(configFile);
    }

    @Override
    public void onAfterActivate() {
        if (this._ConfigDoc != null) {
            this.loadComponents();
            if (this.isEnabled()) {
                this.registerRESTCommands();
                OSecurityManager.instance().setSecurityFactory((OSecurityFactory)this);
            }
        } else {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.onAfterActivate() Configuration document is empty", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeDeactivate() {
        OSecurityManager.instance().setSecurityFactory(null);
        if (this._Enabled) {
            this.unregisterRESTCommands();
            List<OSecurityAuthenticator> list = this._ImportLDAPSynch;
            synchronized (list) {
                if (this._ImportLDAP != null) {
                    this._ImportLDAP.dispose();
                    this._ImportLDAP = null;
                }
            }
            list = this._PasswordValidatorSynch;
            synchronized (list) {
                if (this._PasswordValidator != null) {
                    this._PasswordValidator.dispose();
                    this._PasswordValidator = null;
                }
            }
            list = this._AuditingSynch;
            synchronized (list) {
                if (this._AuditingService != null) {
                    this._AuditingService.dispose();
                    this._AuditingService = null;
                }
            }
            list = this._SyslogSynch;
            synchronized (list) {
                if (this._Syslog != null) {
                    this._Syslog.dispose();
                    this._Syslog = null;
                }
            }
            list = this._AuthenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this._AuthenticatorsList) {
                    sa.dispose();
                }
                this._AuthenticatorsList.clear();
            }
            this._Enabled = false;
        }
    }

    @Override
    public void onAfterDeactivate() {
    }

    protected void loadComponents() {
        this.loadSecurity();
        if (this.isEnabled()) {
            this._SyslogDoc = this.getSection("syslog");
            this.reloadSyslog();
            this._AuditingDoc = this.getSection("auditing");
            this.reloadAuditingService();
            this._ServerDoc = this.getSection("server");
            this.reloadServer();
            this._AuthDoc = this.getSection("authentication");
            this.reloadAuthMethods();
            this._PasswdValDoc = this.getSection("passwordValidator");
            this.reloadPasswordValidator();
            this._LDAPImportDoc = this.getSection("ldapImporter");
            this.reloadImportLDAP();
        }
    }

    private ODocument getSection(String section) {
        ODocument sectionDoc = null;
        try {
            if (this._ConfigDoc != null) {
                if (this._ConfigDoc.containsField(section)) {
                    sectionDoc = (ODocument)this._ConfigDoc.field(section);
                }
            } else {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getSection(%s) Configuration document is null", new Object[]{section});
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getSection(%s) Exception: %s", new Object[]{section, ex.getMessage()});
        }
        return sectionDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODocument loadConfig(String cfgPath) {
        ODocument securityDoc;
        block8: {
            securityDoc = null;
            try {
                if (cfgPath != null) {
                    String jsonFile = OSystemVariableResolver.resolveSystemVariables((String)cfgPath);
                    File file = new File(jsonFile);
                    if (file.exists() && file.canRead()) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(file);
                            byte[] buffer = new byte[(int)file.length()];
                            fis.read(buffer);
                            securityDoc = new ODocument().fromJSON(new String(buffer), "noMap");
                            break block8;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Could not access the security JSON file: %s", new Object[]{jsonFile});
                    break block8;
                }
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Configuration file path is null", new Object[0]);
            }
            catch (Exception ex) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Exception: %s", new Object[]{ex.getMessage()});
            }
        }
        return securityDoc;
    }

    protected String getConfigProperty(String name) {
        String value = null;
        if (this._Server.getConfiguration() != null && this._Server.getConfiguration().properties != null) {
            for (OServerEntryConfiguration p : this._Server.getConfiguration().properties) {
                if (!p.name.equals(name)) continue;
                value = OSystemVariableResolver.resolveSystemVariables((String)p.value);
                break;
            }
        }
        return value;
    }

    private boolean isEnabled(ODocument sectionDoc) {
        boolean enabled = true;
        try {
            if (sectionDoc.containsField("enabled")) {
                enabled = (Boolean)sectionDoc.field("enabled");
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.isEnabled() Exception: %s", new Object[]{ex.getMessage()});
        }
        return enabled;
    }

    private void loadSecurity() {
        try {
            this._Enabled = false;
            if (this._ConfigDoc != null) {
                if (this._ConfigDoc.containsField("enabled")) {
                    this._Enabled = (Boolean)this._ConfigDoc.field("enabled");
                }
                if (this._ConfigDoc.containsField("debug")) {
                    this._Debug = (Boolean)this._ConfigDoc.field("debug");
                }
            } else {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadSecurity() jsonConfig is null", new Object[0]);
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadSecurity() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    private void reloadServer() {
        try {
            this._CreateDefaultUsers = true;
            this._StorePasswords = true;
            if (this._ServerDoc != null) {
                if (this._ServerDoc.containsField("createDefaultUsers")) {
                    this._CreateDefaultUsers = (Boolean)this._ServerDoc.field("createDefaultUsers");
                }
                if (this._ServerDoc.containsField("storePasswords")) {
                    this._StorePasswords = (Boolean)this._ServerDoc.field("storePasswords");
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadServer() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    private void reloadAuthMethods() {
        if (this._AuthDoc != null) {
            if (this._AuthDoc.containsField("allowDefault")) {
                this._AllowDefault = (Boolean)this._AuthDoc.field("allowDefault");
            }
            this.loadAuthenticators(this._AuthDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPasswordValidator() {
        try {
            Object object = this._PasswordValidatorSynch;
            synchronized (object) {
                if (this._PasswordValidator != null) {
                    this._PasswordValidator.dispose();
                    this._PasswordValidator = null;
                }
                if (this._PasswdValDoc != null && this.isEnabled(this._PasswdValDoc)) {
                    Class<?> cls = this.getClass(this._PasswdValDoc);
                    if (cls != null) {
                        if (OPasswordValidator.class.isAssignableFrom(cls)) {
                            this._PasswordValidator = (OPasswordValidator)cls.newInstance();
                            this._PasswordValidator.config(this._Server, this._ServerConfig, this._PasswdValDoc);
                            this._PasswordValidator.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() class is not an OPasswordValidator", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() PasswordValidator class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadImportLDAP() {
        try {
            Object object = this._ImportLDAPSynch;
            synchronized (object) {
                if (this._ImportLDAP != null) {
                    this._ImportLDAP.dispose();
                    this._ImportLDAP = null;
                }
                if (this._LDAPImportDoc != null && this.isEnabled(this._LDAPImportDoc)) {
                    Class<?> cls = this.getClass(this._LDAPImportDoc);
                    if (cls != null) {
                        if (OSecurityComponent.class.isAssignableFrom(cls)) {
                            this._ImportLDAP = (OSecurityComponent)cls.newInstance();
                            this._ImportLDAP.config(this._Server, this._ServerConfig, this._LDAPImportDoc);
                            this._ImportLDAP.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() class is not an OSecurityComponent", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() ImportLDAP class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAuditingService() {
        try {
            Object object = this._AuditingSynch;
            synchronized (object) {
                if (this._AuditingService != null) {
                    this._AuditingService.dispose();
                    this._AuditingService = null;
                }
                if (this._AuditingDoc != null && this.isEnabled(this._AuditingDoc)) {
                    Class<?> cls = this.getClass(this._AuditingDoc);
                    if (cls != null) {
                        if (OAuditingService.class.isAssignableFrom(cls)) {
                            this._AuditingService = (OAuditingService)cls.newInstance();
                            this._AuditingService.config(this._Server, this._ServerConfig, this._AuditingDoc);
                            this._AuditingService.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() class is not an OAuditingService", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() Auditing class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadSyslog() {
        try {
            Object object = this._SyslogSynch;
            synchronized (object) {
                if (this._Syslog != null) {
                    this._Syslog.dispose();
                    this._Syslog = null;
                }
                if (this._SyslogDoc != null && this.isEnabled(this._SyslogDoc)) {
                    Class<?> cls = this.getClass(this._SyslogDoc);
                    if (cls != null) {
                        if (OSyslog.class.isAssignableFrom(cls)) {
                            this._Syslog = (OSyslog)cls.newInstance();
                            this._Syslog.config(this._Server, this._ServerConfig, this._SyslogDoc);
                            this._Syslog.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadSyslog() class is not an OSyslog", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadSyslog() Syslog class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadSyslog() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    public OSecurity newSecurity() {
        return new OSecurityExternal();
    }

    private void registerRESTCommands() {
        try {
            Object listener = this._Server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
            if (listener == null) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.registerRESTCommands() unable to retrieve Network Protocol listener.", new Object[0]);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.registerRESTCommands() Throwable: " + th.getMessage(), new Object[0]);
        }
    }

    private void unregisterRESTCommands() {
        try {
            Object listener = this._Server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
            if (listener == null) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.unregisterRESTCommands() unable to retrieve Network Protocol listener.", new Object[0]);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.unregisterRESTCommands() Throwable: " + th.getMessage(), new Object[0]);
        }
    }
}

