/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticator;
import javax.security.auth.Subject;

public abstract class OSecurityAuthenticatorAbstract
implements OSecurityAuthenticator {
    private String _Name = "";
    private boolean _Debug = false;
    private boolean _Enabled = true;
    private OServer _Server;
    private OServerConfigurationManager _ServerConfig;

    protected OServer getServer() {
        return this._Server;
    }

    protected OServerConfigurationManager getServerConfig() {
        return this._ServerConfig;
    }

    protected boolean isDebug() {
        return this._Debug;
    }

    @Override
    public void active() {
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        this._Server = oServer;
        this._ServerConfig = serverCfg;
        if (jsonConfig.containsField("name")) {
            this._Name = (String)jsonConfig.field("name");
        }
        if (jsonConfig.containsField("debug")) {
            this._Debug = (Boolean)jsonConfig.field("debug");
        }
        if (jsonConfig.containsField("enabled")) {
            this._Enabled = (Boolean)jsonConfig.field("enabled");
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isEnabled() {
        return this._Enabled;
    }

    @Override
    public String getAuthenticationHeader(String databaseName) {
        String header = databaseName != null ? "WWW-Authenticate: Basic realm=\"OrientDB db-" + databaseName + "\"" : "WWW-Authenticate: Basic realm=\"OrientDB Server\"";
        return header;
    }

    @Override
    public Subject getClientSubject() {
        return null;
    }

    @Override
    public String getName() {
        return this._Name;
    }

    @Override
    public OServerUserConfiguration getUser(String username) {
        return null;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        return false;
    }

    @Override
    public boolean isSingleSignOnSupported() {
        return false;
    }
}

