/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security.authenticator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticatorAbstract;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ODefaultPasswordAuthenticator
extends OSecurityAuthenticatorAbstract {
    private ConcurrentHashMap<String, OServerUserConfiguration> _UsersMap = new ConcurrentHashMap();

    @Override
    public void active() {
        OLogManager.instance().info((Object)this, "*********************************************", new Object[0]);
        OLogManager.instance().info((Object)this, "** ODefaultPasswordAuthenticator Is Active **", new Object[0]);
        OLogManager.instance().info((Object)this, "*********************************************", new Object[0]);
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        super.config(oServer, serverCfg, jsonConfig);
        try {
            if (jsonConfig.containsField("users")) {
                List usersList = (List)jsonConfig.field("users");
                for (ODocument userDoc : usersList) {
                    if (!userDoc.containsField("username") || !userDoc.containsField("resources")) continue;
                    String user = (String)userDoc.field("username");
                    String resources = (String)userDoc.field("resources");
                    String password = (String)userDoc.field("password");
                    if (!this._UsersMap.containsKey(user)) {
                        if (password == null) {
                            password = "";
                        }
                        OServerUserConfiguration userCfg = new OServerUserConfiguration(user, password, resources);
                        this._UsersMap.put(user, userCfg);
                        continue;
                    }
                    OLogManager.instance().error((Object)this, "ODefaultPasswordAuthenticator.config() User: %s already exists", new Object[]{user});
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultPasswordAuthenticator.config() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ConcurrentHashMap<String, OServerUserConfiguration> concurrentHashMap = this._UsersMap;
        synchronized (concurrentHashMap) {
            this._UsersMap.clear();
            this._UsersMap = null;
        }
    }

    @Override
    public String authenticate(String username, String password) {
        String principal = null;
        try {
            OServerUserConfiguration user = this.getUser(username);
            if (user != null && user.password != null && !user.password.isEmpty() && OSecurityManager.instance().checkPassword(password, user.password)) {
                principal = user.name;
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultPasswordAuthenticator.authenticate() Exception: %s", new Object[]{ex.getMessage()});
        }
        return principal;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        if (username == null || resource == null) {
            return false;
        }
        OServerUserConfiguration userCfg = this.getUser(username);
        if (userCfg != null) {
            String[] resourceParts;
            if (userCfg.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = userCfg.resources.split(",")) {
                if (!r.equalsIgnoreCase(resource)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        ConcurrentHashMap<String, OServerUserConfiguration> concurrentHashMap = this._UsersMap;
        synchronized (concurrentHashMap) {
            if (this._UsersMap.containsKey(username)) {
                userCfg = this._UsersMap.get(username);
            }
        }
        return userCfg;
    }
}

