/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedMessageService;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedStrategy;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolverFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ODistributedServerManager {
    public static final String FILE_DISTRIBUTED_DB_CONFIG = "distributed-config.json";

    public boolean isNodeStatusEqualsTo(String var1, String var2, DB_STATUS ... var3);

    public boolean isNodeAvailable(String var1);

    public Set<String> getAvailableNodeNames(String var1);

    public void waitUntilNodeOnline() throws InterruptedException;

    public void waitUntilNodeOnline(String var1, String var2) throws InterruptedException;

    public OStorage getStorage(String var1);

    public OServer getServerInstance();

    public boolean isEnabled();

    public ODistributedServerManager registerLifecycleListener(ODistributedLifecycleListener var1);

    public ODistributedServerManager unregisterLifecycleListener(ODistributedLifecycleListener var1);

    public Object executeOnLocalNode(ODistributedRequestId var1, ORemoteTask var2, ODatabaseDocumentInternal var3);

    public ORemoteServerController getRemoteServer(String var1) throws IOException;

    public Map<String, Object> getConfigurationMap();

    public long getLastClusterChangeOn();

    public NODE_STATUS getNodeStatus();

    public void setNodeStatus(NODE_STATUS var1);

    public boolean checkNodeStatus(NODE_STATUS var1);

    public void removeServer(String var1, boolean var2);

    public DB_STATUS getDatabaseStatus(String var1, String var2);

    public void setDatabaseStatus(String var1, String var2, DB_STATUS var3);

    public int getNodesWithStatus(Collection<String> var1, String var2, DB_STATUS ... var3);

    public ODistributedMessageService getMessageService();

    public ODistributedStrategy getDistributedStrategy();

    public void setDistributedStrategy(ODistributedStrategy var1);

    public boolean updateCachedDatabaseConfiguration(String var1, OModifiableDistributedConfiguration var2, boolean var3);

    public long getNextMessageIdCounter();

    public String getNodeUuidByName(String var1);

    public void updateLastClusterChange();

    public void reassignClustersOwnership(String var1, String var2, OModifiableDistributedConfiguration var3);

    public boolean isNodeAvailable(String var1, String var2);

    public boolean isNodeOnline(String var1, String var2);

    public int getAvailableNodes(String var1);

    public int getAvailableNodes(Collection<String> var1, String var2);

    public boolean isOffline();

    public int getLocalNodeId();

    public String getLocalNodeName();

    public ODocument getClusterConfiguration();

    public String getNodeNameById(int var1);

    public int getNodeIdByName(String var1);

    public ODocument getNodeConfigurationByUuid(String var1, boolean var2);

    public ODocument getLocalNodeConfiguration();

    public void propagateSchemaChanges(ODatabaseInternal var1);

    public ODistributedConfiguration getDatabaseConfiguration(String var1);

    public ODistributedConfiguration getDatabaseConfiguration(String var1, boolean var2);

    public ODistributedResponse sendRequest(String var1, Collection<String> var2, Collection<String> var3, ORemoteTask var4, long var5, ODistributedRequest.EXECUTION_MODE var7, Object var8, OCallable<Void, ODistributedRequestId> var9);

    public ODocument getStats();

    public Throwable convertException(Throwable var1);

    public List<String> getOnlineNodes(String var1);

    public boolean installDatabase(boolean var1, String var2, boolean var3, boolean var4);

    public ORemoteTaskFactory getTaskFactory();

    public Set<String> getActiveServers();

    public ODistributedConflictResolverFactory getConflictResolverFactory();

    public long getClusterTime();

    public File getDefaultDatabaseConfigFile();

    public ODistributedLockManager getLockManagerRequester();

    public ODistributedLockManager getLockManagerExecutor();

    public <T> T executeInDistributedDatabaseLock(String var1, long var2, OModifiableDistributedConfiguration var4, OCallable<T, OModifiableDistributedConfiguration> var5);

    public static enum DB_STATUS {
        NOT_AVAILABLE,
        OFFLINE,
        SYNCHRONIZING,
        ONLINE,
        BACKUP;

    }

    public static enum NODE_STATUS {
        OFFLINE,
        STARTING,
        ONLINE,
        SHUTTINGDOWN;

    }
}

