/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OAbstractRemoteTask
implements ORemoteTask {
    public static final int[] ALL = new int[]{-1};
    protected static final int[] ANY = new int[]{-2};
    protected static final int[] LOCK = new int[]{-3};
    protected static final int[] UNLOCK = new int[]{-4};
    protected transient String nodeSource;

    @Override
    public abstract String getName();

    @Override
    public abstract OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType();

    @Override
    public abstract Object execute(ODistributedRequestId var1, OServer var2, ODistributedServerManager var3, ODatabaseDocumentInternal var4) throws Exception;

    @Override
    public int[] getPartitionKey() {
        return ANY;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public long getSynchronousTimeout(int iSynchNodes) {
        if (iSynchNodes <= 0) {
            return this.getDistributedTimeout();
        }
        return this.getDistributedTimeout() * (long)iSynchNodes;
    }

    @Override
    public void checkIsValid(ODistributedServerManager dManager) {
    }

    @Override
    public long getTotalTimeout(int iTotalNodes) {
        if (iTotalNodes <= 0) {
            return this.getDistributedTimeout();
        }
        return this.getDistributedTimeout() * (long)iTotalNodes;
    }

    @Override
    public boolean hasResponse() {
        return true;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getNodeSource() {
        return this.nodeSource;
    }

    @Override
    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    public boolean isNodeOnlineRequired() {
        return true;
    }

    @Override
    public boolean isUsingDatabase() {
        return true;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
    }
}

