/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OModifiableDistributedConfiguration
extends ODistributedConfiguration {
    public OModifiableDistributedConfiguration(ODocument iConfiguration) {
        super(iConfiguration);
    }

    @Override
    public OModifiableDistributedConfiguration modify() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerRole(String iServerName, ODistributedConfiguration.ROLES role) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument servers = (ODocument)this.configuration.field("servers");
            if (servers == null) {
                servers = new ODocument();
                this.configuration.field("servers", (Object)servers, new OType[]{OType.EMBEDDED});
            }
            servers.field(iServerName, (Object)role);
            this.incrementVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> addNewNodeInServerList(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            for (String clusterName : this.getClusterNames()) {
                int newNodePos;
                List partitions = (List)this.getClusterConfiguration(clusterName).field("servers");
                if (partitions == null || (newNodePos = partitions.indexOf("<NEW_NODE>")) <= -1 || partitions.contains(iNode)) continue;
                partitions.add(newNodePos, iNode);
                changedPartitions.add(clusterName);
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                if (!this.getRegisteredServers().contains(iNode) && this.getNewNodeStrategy() == ODistributedConfiguration.NEW_NODE_STRATEGIES.STATIC) {
                    this.setServerRole(iNode, this.getServerRole("*"));
                }
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerOwner(String iClusterName, String iServerName) {
        if (iClusterName == null) {
            throw new IllegalArgumentException("cluster name cannot be null");
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            ODocument cluster = (ODocument)clusters.field(iClusterName);
            if (cluster == null) {
                cluster = this.createCluster(iClusterName);
            } else {
                String owner = (String)cluster.field("owner");
                if (owner != null && !iServerName.equalsIgnoreCase(owner)) {
                    throw new ODistributedException("Cannot overwrite ownership of cluster '" + iClusterName + "' to the server '" + iServerName + "', because server '" + owner + "' was already configured as owner");
                }
            }
            List<String> serverList = (List<String>)this.getClusterConfiguration(iClusterName).field("servers");
            if (serverList == null) {
                serverList = this.initClusterServers(cluster);
            }
            if (!serverList.isEmpty() && serverList.get(0).equals(iServerName)) {
                return;
            }
            boolean removed = false;
            Iterator<String> it = serverList.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(iServerName)) continue;
                it.remove();
                removed = true;
                break;
            }
            if (!removed) {
                throw new ODistributedException("Cannot set ownership of cluster '" + iClusterName + "' to the server '" + iServerName + "', because the server has no that cluster (sharding?). Servers with the cluster are " + serverList);
            }
            serverList.add(0, iServerName);
            this.incrementVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> removeServer(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            block3: for (String clusterName : this.getClusterNames()) {
                Collection nodes = (Collection)this.getClusterConfiguration(clusterName).field("servers");
                if (nodes == null) continue;
                for (String node : nodes) {
                    if (!node.equals(iNode)) continue;
                    nodes.remove(node);
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> setServerOffline(String iNode, String newLockManagerServer) {
        ArrayList<String> changedPartitions = new ArrayList<String>();
        String[] clusters = this.getClusterNames();
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            block3: for (String clusterName : clusters) {
                List nodes = (List)this.getClusterConfiguration(clusterName).field("servers");
                if (nodes == null || nodes.size() <= 1) continue;
                for (String node : nodes) {
                    if (!node.equals(iNode)) continue;
                    nodes.remove(node);
                    boolean newNodeRemoved = nodes.remove("<NEW_NODE>");
                    nodes.add(node);
                    if (newNodeRemoved) {
                        nodes.add("<NEW_NODE>");
                    }
                    if (newLockManagerServer != null && nodes.remove(newLockManagerServer)) {
                        nodes.add(0, newLockManagerServer);
                    }
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    private void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field("version");
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field("version", (Object)(oldVersion + 1));
    }

    private List<String> initClusterServers(ODocument cluster) {
        ODocument any = this.getClusterConfiguration("*");
        List anyServers = (List)any.field("servers");
        ArrayList<String> servers = new ArrayList<String>(anyServers);
        cluster.field("servers", servers);
        return servers;
    }

    private ODocument createCluster(String iClusterName) {
        ODocument clusters = (ODocument)this.configuration.field("clusters");
        ODocument cluster = (ODocument)clusters.field(iClusterName);
        if (cluster != null) {
            return clusters;
        }
        cluster = new ODocument();
        ODocumentInternal.addOwner((ODocument)cluster, (ORecordElement)clusters);
        clusters.field(iClusterName, (Object)cluster, new OType[]{OType.EMBEDDED});
        List<String> servers = this.initClusterServers(cluster);
        return cluster;
    }
}

