/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import com.orientechnologies.orient.server.OClientConnectionStats;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OClientConnection {
    private final int id;
    private final long since;
    private Set<ONetworkProtocol> protocols = Collections.newSetFromMap(new WeakHashMap());
    private volatile ONetworkProtocol protocol;
    private volatile ODatabaseDocumentInternal database;
    private volatile OServerUserConfiguration serverUser;
    private ONetworkProtocolData data = new ONetworkProtocolData();
    private OClientConnectionStats stats = new OClientConnectionStats();
    private Lock lock = new ReentrantLock();
    private Boolean tokenBased;
    private byte[] tokenBytes;
    private OToken token;

    public OClientConnection(int id, ONetworkProtocol protocol) throws IOException {
        this.id = id;
        this.protocol = protocol;
        this.protocols.add(protocol);
        this.since = System.currentTimeMillis();
    }

    public void close() {
        if (this.getDatabase() != null) {
            if (!this.getDatabase().isClosed()) {
                this.getDatabase().activateOnCurrentThread();
                try {
                    this.getDatabase().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setDatabase(null);
        }
    }

    public void acquire() {
        this.lock.lock();
    }

    public void release() {
        this.lock.unlock();
    }

    public String toString() {
        return "OClientConnection [id=" + this.getId() + ", source=" + (this.getProtocol() != null && this.getProtocol().getChannel() != null && this.getProtocol().getChannel().socket != null ? this.getProtocol().getChannel().socket.getRemoteSocketAddress() : "?") + ", since=" + this.getSince() + "]";
    }

    public String getRemoteAddress() {
        Socket socket = null;
        if (this.getProtocol() != null) {
            socket = this.getProtocol().getChannel().socket;
        } else {
            for (ONetworkProtocol protocol : this.protocols) {
                socket = protocol.getChannel().socket;
                if (socket == null) continue;
                break;
            }
        }
        if (socket != null) {
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            return remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        }
        return null;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClientConnection other = (OClientConnection)obj;
        return this.getId() == other.getId();
    }

    public OChannelBinary getChannel() {
        return (OChannelBinary)this.getProtocol().getChannel();
    }

    public ONetworkProtocol getProtocol() {
        return this.protocol;
    }

    public byte[] getTokenBytes() {
        return this.tokenBytes;
    }

    public void validateSession(byte[] tokenFromNetwork, OTokenHandler handler, ONetworkProtocolBinary protocol) {
        if (tokenFromNetwork == null || tokenFromNetwork.length == 0) {
            if (!this.protocols.contains((Object)protocol)) {
                throw new OTokenSecurityException("No valid session found, provide a token");
            }
        } else {
            OToken token = null;
            try {
                if (tokenFromNetwork != null) {
                    token = handler.parseBinaryToken(tokenFromNetwork);
                }
            }
            catch (Exception e) {
                throw OException.wrapException((OException)new OSystemException("Error on token parse"), (Throwable)e);
            }
            if (token == null || !token.getIsVerified()) {
                this.cleanSession();
                throw new OTokenSecurityException("The token provided is not a valid token, signature does not match");
            }
            if (!handler.validateBinaryToken(token)) {
                this.cleanSession();
                throw new OTokenSecurityException("The token provided is expired");
            }
            if (this.tokenBased == null) {
                this.tokenBased = Boolean.TRUE;
            }
            if (!Arrays.equals(this.tokenBytes, tokenFromNetwork)) {
                this.cleanSession();
            }
            this.tokenBytes = tokenFromNetwork;
            this.token = token;
            this.protocols.add(protocol);
        }
    }

    public void cleanSession() {
        if (this.database != null && !this.database.isClosed()) {
            this.database.activateOnCurrentThread();
            this.database.close();
        }
        this.database = null;
        this.protocols.clear();
    }

    public void endOperation() {
        if (this.database != null && !this.database.isClosed() && this.database.getLocalCache() != null) {
            this.database.getLocalCache().clear();
        }
        this.stats.lastCommandExecutionTime = System.currentTimeMillis() - this.stats.lastCommandReceived;
        this.stats.totalCommandExecutionTime += this.stats.lastCommandExecutionTime;
        this.stats.lastCommandInfo = this.data.commandInfo;
        this.stats.lastCommandDetail = this.data.commandDetail;
        this.data.commandDetail = "-";
        this.release();
    }

    public void init(OServer server) {
        if (this.database == null) {
            this.setData(server.getTokenHandler().getProtocolDataFromToken(this, this.token));
            if (this.data == null) {
                throw new OTokenSecurityException("missing in token data");
            }
            String db = this.token.getDatabase();
            String type = this.token.getDatabaseType();
            if (db != null && type != null) {
                if (this.data.serverUser) {
                    this.setDatabase((ODatabaseDocumentInternal)server.openDatabase(type + ":" + db, this.token.getUserName(), null, this.data, true));
                } else {
                    this.setDatabase((ODatabaseDocumentInternal)((ODatabaseDocumentTx)server.openDatabase(type + ":" + db, this.token)));
                }
            }
        }
    }

    public Boolean getTokenBased() {
        return this.tokenBased;
    }

    public void setTokenBased(Boolean tokenBased) {
        this.tokenBased = tokenBased;
    }

    public void setTokenBytes(byte[] tokenBytes) {
        this.tokenBytes = tokenBytes;
    }

    public OToken getToken() {
        return this.token;
    }

    public void setToken(OToken token) {
        this.token = token;
    }

    public int getId() {
        return this.id;
    }

    public long getSince() {
        return this.since;
    }

    public void setProtocol(ONetworkProtocol protocol) {
        this.protocol = protocol;
    }

    public ODatabaseDocumentInternal getDatabase() {
        return this.database;
    }

    public void setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
    }

    public OServerUserConfiguration getServerUser() {
        return this.serverUser;
    }

    public void setServerUser(OServerUserConfiguration serverUser) {
        this.serverUser = serverUser;
    }

    public ONetworkProtocolData getData() {
        return this.data;
    }

    public void setData(ONetworkProtocolData data) {
        this.data = data;
    }

    public OClientConnectionStats getStats() {
        return this.stats;
    }

    public void statsUpdate() {
        if (this.database != null) {
            this.database.activateOnCurrentThread();
            this.stats.lastDatabase = this.database.getName();
            this.stats.lastUser = this.database.getUser() != null ? this.database.getUser().getName() : null;
        } else {
            this.stats.lastDatabase = null;
            this.stats.lastUser = null;
        }
        ++this.stats.totalRequests;
        this.data.commandInfo = "Listening";
        this.data.commandDetail = "-";
        this.stats.lastCommandReceived = System.currentTimeMillis();
    }
}

