/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.sql.query.OConcurrentResultSet;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerInfo;
import com.orientechnologies.orient.server.ShutdownHelper;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OAsyncCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OLiveCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OSyncCommandResultListener;
import com.orientechnologies.orient.server.plugin.OServerPluginHelper;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class ONetworkProtocolBinary
extends ONetworkProtocol {
    protected final Level logClientExceptions = Level.parse(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL.getValueAsString());
    protected final boolean logClientFullStackTrace = OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE.getValueAsBoolean();
    protected OChannelBinary channel;
    protected volatile int requestType;
    protected int clientTxId;
    protected boolean okSent;
    private boolean tokenConnection = false;
    private long distributedRequests = 0L;
    private long distributedResponses = 0L;

    public ONetworkProtocolBinary() {
        this("OrientDB <- BinaryClient/?");
    }

    public ONetworkProtocolBinary(String iThreadName) {
        super(Orient.instance().getThreadGroup(), iThreadName);
    }

    public void initVariables(OServer server, OChannelBinaryServer channel) {
        this.server = server;
        this.channel = channel;
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        OChannelBinaryServer channel = new OChannelBinaryServer(iSocket, iConfig);
        this.initVariables(iServer, channel);
        channel.writeShort((short)this.getVersion());
        channel.flush();
        this.start();
        this.setName("OrientDB (" + iSocket.getLocalSocketAddress() + ") <- BinaryClient (" + iSocket.getRemoteSocketAddress() + ")");
    }

    public void startup() {
        super.startup();
    }

    public void shutdown() {
        this.sendShutdown();
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        this.requestType = -1;
        if (this.isShutdownFlag()) {
            return;
        }
        this.clientTxId = 0;
        this.okSent = false;
        long timer = 0L;
        OClientConnection connection = null;
        try {
            this.requestType = this.channel.readByte();
            this.clientTxId = this.channel.readInt();
            timer = Orient.instance().getProfiler().startChrono();
            try {
                connection = this.onBeforeRequest();
            }
            catch (Exception e) {
                if (this.requestType != 5) {
                    this.sendError(connection, this.clientTxId, e);
                    this.handleConnectionError(connection, e);
                    this.onAfterRequest(connection);
                    this.sendShutdown();
                }
                Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
                ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
                return;
            }
            OLogManager.instance().debug((Object)this, "Request id:" + this.clientTxId + " type:" + this.requestType, new Object[0]);
            try {
                if (!this.executeRequest(connection)) {
                    OLogManager.instance().error((Object)this, "Request not supported. Code: " + this.requestType, new Object[0]);
                    this.channel.clearInput();
                    this.sendErrorOrDropConnection(connection, this.clientTxId, (Throwable)new ONetworkProtocolException("Request not supported. Code: " + this.requestType));
                }
            }
            finally {
                this.onAfterRequest(connection);
            }
        }
        catch (IOException e) {
            OLogManager.instance().debug((Object)this, "I/O Error on client clientId=%d reqType=%d", new Object[]{this.clientTxId, this.requestType, e});
            this.sendShutdown();
        }
        catch (OException e) {
            this.sendErrorOrDropConnection(connection, this.clientTxId, e);
        }
        catch (RuntimeException e) {
            this.sendErrorOrDropConnection(connection, this.clientTxId, e);
        }
        catch (Throwable t) {
            this.sendErrorOrDropConnection(connection, this.clientTxId, t);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        }
    }

    protected OClientConnection onBeforeRequest() throws IOException {
        OClientConnection connection = this.solveSession();
        if (connection != null) {
            connection.statsUpdate();
        } else {
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            if (this.requestType != 5 && this.requestType != 1) {
                OLogManager.instance().debug((Object)this, "Found unknown session %d, shutdown current connection", new Object[]{this.clientTxId});
                this.shutdown();
                throw new OIOException("Found unknown session " + this.clientTxId);
            }
        }
        OServerPluginHelper.invokeHandlerCallbackOnBeforeClientRequest(this.server, connection, (byte)this.requestType);
        return connection;
    }

    private OClientConnection solveSession() throws IOException {
        OClientConnection connection = this.server.getClientConnectionManager().getConnection(this.clientTxId, this);
        try {
            boolean noToken = false;
            if (connection == null && this.clientTxId < 0 && (this.requestType == 3 || this.requestType == 2)) {
                noToken = true;
            }
            if (this.requestType == 2 || this.requestType == 3 || this.requestType == 1) {
                noToken = true;
            }
            if (connection != null && !Boolean.TRUE.equals(connection.getTokenBased())) {
                noToken = true;
            }
            if (connection == null && this.clientTxId < 0 && this.requestType == 5) {
                return null;
            }
            if (noToken) {
                if (this.clientTxId < 0) {
                    connection = this.server.getClientConnectionManager().connect(this);
                    connection.getData().sessionId = this.clientTxId;
                }
                if (connection != null) {
                    connection.setTokenBytes(null);
                    connection.acquire();
                }
            } else {
                this.tokenConnection = true;
                byte[] bytes = this.channel.readBytes();
                if (connection == null && bytes != null && bytes.length > 0) {
                    connection = this.server.getClientConnectionManager().connect(this);
                }
                if (connection == null) {
                    throw new OTokenSecurityException("missing session and token");
                }
                if (this.requestType != 17) {
                    connection.acquire();
                    connection.validateSession(bytes, this.server.getTokenHandler(), this);
                } else {
                    connection.validateSession(bytes, this.server.getTokenHandler(), this);
                    this.server.getClientConnectionManager().disconnect(this.clientTxId);
                    connection = this.server.getClientConnectionManager().reConnect(this, connection.getTokenBytes(), connection.getToken());
                    connection.acquire();
                }
                if (this.requestType != 5) {
                    connection.init(this.server);
                }
                if (connection.getData().serverUser) {
                    connection.setServerUser(this.server.getUser(connection.getData().serverUsername));
                }
            }
        }
        catch (RuntimeException e) {
            if (connection != null) {
                this.server.getClientConnectionManager().disconnect(connection);
            }
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw e;
        }
        catch (IOException e) {
            if (connection != null) {
                this.server.getClientConnectionManager().disconnect(connection);
            }
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw e;
        }
        return connection;
    }

    protected void onAfterRequest(OClientConnection connection) throws IOException {
        OServerPluginHelper.invokeHandlerCallbackOnAfterClientRequest(this.server, connection, (byte)this.requestType);
        if (connection != null) {
            connection.endOperation();
        }
        this.setDataCommandInfo(connection, "Listening");
    }

    protected boolean executeRequest(OClientConnection connection) throws IOException {
        try {
            switch (this.requestType) {
                case 1: {
                    this.shutdownConnection(connection);
                    break;
                }
                case 2: {
                    this.connect(connection);
                    break;
                }
                case 74: {
                    this.listDatabases(connection);
                    break;
                }
                case 75: {
                    this.serverInfo(connection);
                    break;
                }
                case 3: {
                    this.openDatabase(connection);
                    break;
                }
                case 17: {
                    this.reopenDatabase(connection);
                    break;
                }
                case 73: {
                    this.reloadDatabase(connection);
                    break;
                }
                case 4: {
                    this.createDatabase(connection);
                    break;
                }
                case 5: {
                    this.closeDatabase(connection);
                    break;
                }
                case 6: {
                    this.existsDatabase(connection);
                    break;
                }
                case 7: {
                    this.dropDatabase(connection);
                    break;
                }
                case 8: {
                    this.sizeDatabase(connection);
                    break;
                }
                case 9: {
                    this.countDatabaseRecords(connection);
                    break;
                }
                case 90: {
                    this.copyDatabase(connection);
                    break;
                }
                case 91: {
                    this.replicationDatabase(connection);
                    break;
                }
                case 92: {
                    this.distributedCluster(connection);
                    break;
                }
                case 12: {
                    this.countClusters(connection);
                    break;
                }
                case 13: {
                    this.rangeCluster(connection);
                    break;
                }
                case 10: {
                    this.addCluster(connection);
                    break;
                }
                case 11: {
                    this.removeCluster(connection);
                    break;
                }
                case 29: {
                    this.readRecordMetadata(connection);
                    break;
                }
                case 30: {
                    this.readRecord(connection);
                    break;
                }
                case 44: {
                    this.readRecordIfVersionIsNotLatest(connection);
                    break;
                }
                case 31: {
                    this.createRecord(connection);
                    break;
                }
                case 32: {
                    this.updateRecord(connection);
                    break;
                }
                case 33: {
                    this.deleteRecord(connection);
                    break;
                }
                case 43: {
                    this.hideRecord(connection);
                    break;
                }
                case 36: {
                    this.higherPositions(connection);
                    break;
                }
                case 42: {
                    this.ceilingPositions(connection);
                    break;
                }
                case 37: {
                    this.lowerPositions(connection);
                    break;
                }
                case 39: {
                    this.floorPositions(connection);
                    break;
                }
                case 40: {
                    throw new UnsupportedOperationException("Operation OChannelBinaryProtocol.REQUEST_COUNT has been deprecated");
                }
                case 41: {
                    this.command(connection);
                    break;
                }
                case 60: {
                    this.commit(connection);
                    break;
                }
                case 70: {
                    this.configGet(connection);
                    break;
                }
                case 71: {
                    this.configSet(connection);
                    break;
                }
                case 72: {
                    this.configList(connection);
                    break;
                }
                case 94: {
                    this.freezeDatabase(connection);
                    break;
                }
                case 95: {
                    this.releaseDatabase(connection);
                    break;
                }
                case 38: {
                    this.cleanOutRecord(connection);
                    break;
                }
                case 110: {
                    this.createSBTreeBonsai(connection);
                    break;
                }
                case 111: {
                    this.sbTreeBonsaiGet(connection);
                    break;
                }
                case 112: {
                    this.sbTreeBonsaiFirstKey(connection);
                    break;
                }
                case 113: {
                    this.sbTreeBonsaiGetEntriesMajor(connection);
                    break;
                }
                case 114: {
                    this.ridBagSize(connection);
                    break;
                }
                case 27: {
                    this.incrementalBackup(connection);
                    break;
                }
                case 120: {
                    this.executeDistributedRequest(connection);
                    break;
                }
                case 121: {
                    this.executeDistributedResponse(connection);
                    break;
                }
                default: {
                    this.setDataCommandInfo(connection, "Command not supported");
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            OSBTreeCollectionManager collectionManager;
            if (connection != null && connection.getDatabase() != null && (collectionManager = connection.getDatabase().getSbTreeCollectionManager()) != null) {
                collectionManager.clearChangedIds();
            }
            throw e;
        }
    }

    private void reopenDatabase(OClientConnection connection) throws IOException {
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeInt(connection.getId());
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void checkServerAccess(String iResource, OClientConnection connection) {
        if (connection.getData().protocolVersion <= 26) {
            if (connection.getServerUser() == null) {
                throw new OSecurityAccessException("Server user not authenticated");
            }
            if (!this.server.isAllowed(connection.getServerUser().name, iResource)) {
                throw new OSecurityAccessException("User '" + connection.getServerUser().name + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        } else {
            if (!connection.getData().serverUser) {
                throw new OSecurityAccessException("Server user not authenticated");
            }
            if (!this.server.isAllowed(connection.getData().serverUsername, iResource)) {
                throw new OSecurityAccessException("User '" + connection.getData().serverUsername + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCluster(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Remove cluster");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        short id = this.channel.readShort();
        String clusterName = connection.getDatabase().getClusterNameById((int)id);
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster " + id + " does not exist anymore. Refresh the db structure or just reconnect to the database");
        }
        boolean result = connection.getDatabase().dropCluster(clusterName, false);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeByte((byte)(result ? 1 : 0));
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCluster(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Add cluster");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        String type = "";
        if (connection.getData().protocolVersion < 24) {
            type = this.channel.readString();
        }
        String name = this.channel.readString();
        int clusterId = -1;
        if (connection.getData().protocolVersion < 24 || type.equalsIgnoreCase("PHYSICAL")) {
            String location = this.channel.readString();
        } else {
            Object location = null;
        }
        if (connection.getData().protocolVersion < 24) {
            String string = this.channel.readString();
        }
        int num = (clusterId = (int)this.channel.readShort()) < 0 ? connection.getDatabase().addCluster(name, new Object[0]) : connection.getDatabase().addCluster(name, clusterId, null);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeShort((short)num);
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void rangeCluster(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Get the begin/end range of data in cluster");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        long[] pos = connection.getDatabase().getStorage().getClusterDataRange((int)this.channel.readShort());
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeLong(pos[0]);
            this.channel.writeLong(pos[1]);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countClusters(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Count cluster elements");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        int[] clusterIds = new int[this.channel.readShort()];
        for (int i = 0; i < clusterIds.length; ++i) {
            clusterIds[i] = this.channel.readShort();
        }
        boolean countTombstones = false;
        countTombstones = this.channel.readByte() > 0;
        long count = connection.getDatabase().countClusterElements(clusterIds, countTombstones);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeLong(count);
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void reloadDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Reload database information");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.sendDatabaseInformation(connection);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Open database");
        this.readConnectionData(connection);
        String dbURL = this.channel.readString();
        String dbType = "document";
        if (connection.getData().protocolVersion <= 32) {
            dbType = this.channel.readString();
        }
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        try {
            connection.setDatabase((ODatabaseDocumentInternal)((ODatabaseDocumentTx)this.server.openDatabase(dbURL, user, passwd, connection.getData())));
        }
        catch (OException e) {
            this.server.getClientConnectionManager().disconnect(connection);
            throw e;
        }
        byte[] token = null;
        if (Boolean.TRUE.equals(connection.getTokenBased())) {
            token = this.server.getTokenHandler().getSignedBinaryToken(connection.getDatabase(), connection.getDatabase().getUser(), connection.getData());
            this.getServer().getClientConnectionManager().connect(this, connection, token, this.server.getTokenHandler());
        }
        if (connection.getDatabase().getStorage() instanceof OStorageProxy && !this.loadUserFromSchema(connection, user, passwd)) {
            this.sendErrorOrDropConnection(connection, this.clientTxId, new OSecurityAccessException(connection.getDatabase().getName(), "User or password not valid for database: '" + connection.getDatabase().getName() + "'"));
        } else {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeInt(connection.getId());
                if (connection.getData().protocolVersion > 26) {
                    if (Boolean.TRUE.equals(connection.getTokenBased())) {
                        this.channel.writeBytes(token);
                    } else {
                        this.channel.writeBytes(OCommonConst.EMPTY_BYTE_ARRAY);
                    }
                }
                this.sendDatabaseInformation(connection);
                Object plugin = this.server.getPlugin("cluster");
                ODocument distributedCfg = null;
                if (plugin != null && plugin instanceof ODistributedServerManager) {
                    distributedCfg = ((ODistributedServerManager)plugin).getClusterConfiguration();
                    ODistributedConfiguration dbCfg = ((ODistributedServerManager)plugin).getDatabaseConfiguration(connection.getDatabase().getName());
                    if (dbCfg != null) {
                        distributedCfg.field("database", (Object)dbCfg.getDocument(), new OType[]{OType.EMBEDDED});
                    }
                }
                this.channel.writeBytes(distributedCfg != null ? this.getRecordBytes(connection, (ORecord)distributedCfg) : null);
                if (connection.getData().protocolVersion >= 14) {
                    this.channel.writeString(OConstants.getVersion());
                }
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Connect");
        this.readConnectionData(connection);
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        connection.setServerUser(this.server.serverLogin(user, passwd, "connect"));
        if (connection.getServerUser() == null) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance");
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeInt(connection.getId());
            if (connection.getData().protocolVersion > 26) {
                connection.getData().serverUsername = connection.getServerUser().name;
                connection.getData().serverUser = true;
                byte[] token = Boolean.TRUE.equals(connection.getTokenBased()) ? this.server.getTokenHandler().getSignedBinaryToken(null, null, connection.getData()) : OCommonConst.EMPTY_BYTE_ARRAY;
                this.channel.writeBytes(token);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalBackup(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Incremental backup");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        String path = this.channel.readString();
        String fileName = connection.getDatabase().incrementalBackup(path);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeString(fileName);
        }
        finally {
            this.endResponse(connection);
        }
    }

    private void executeDistributedRequest(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Distributed request");
        this.checkServerAccess("server.replication", connection);
        byte[] serializedReq = this.channel.readBytes();
        ODistributedServerManager manager = this.server.getDistributedManager();
        ODistributedRequest req = new ODistributedRequest(manager.getTaskFactory());
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedReq));
        try {
            req.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error on unmarshalling of remote task", e);
        }
        finally {
            in.close();
        }
        ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), manager.getNodeNameById(req.getId().getNodeId()), ODistributedServerLog.DIRECTION.IN, "Received request %s (%d bytes)", req, serializedReq.length);
        String dbName = req.getDatabaseName();
        if (dbName != null) {
            ODistributedDatabase ddb;
            if (this.distributedRequests == 0L && req.getTask().isNodeOnlineRequired()) {
                try {
                    manager.waitUntilNodeOnline(manager.getLocalNodeName(), dbName);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    ODistributedServerLog.error((Object)this, manager.getLocalNodeName(), manager.getNodeNameById(req.getId().getNodeId()), ODistributedServerLog.DIRECTION.IN, "Distributed request %s interrupted waiting for the database to be online", req);
                    throw new ODistributedException("Distributed request " + req.getId() + " interrupted waiting for the database to be online");
                }
            }
            if ((ddb = manager.getMessageService().getDatabase(dbName)) == null) {
                throw new ODistributedException("Database configuration not found for database '" + req.getDatabaseName() + "'");
            }
            ddb.processRequest(req);
        } else {
            manager.executeOnLocalNode(req.getId(), req.getTask(), null);
        }
        ++this.distributedRequests;
    }

    private void executeDistributedResponse(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Distributed response");
        this.checkServerAccess("server.replication", connection);
        byte[] serializedResponse = this.channel.readBytes();
        ODistributedServerManager manager = this.server.getDistributedManager();
        ODistributedResponse response = new ODistributedResponse();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedResponse));
        try {
            response.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error on unmarshalling of remote task", e);
        }
        ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), response.getExecutorNodeName(), ODistributedServerLog.DIRECTION.IN, "Executing distributed response %s", response);
        manager.getMessageService().dispatchResponseToThread(response);
        ++this.distributedResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(OClientConnection connection, int iClientTxId, Throwable t) throws IOException {
        this.channel.acquireWriteLock();
        try {
            this.channel.writeByte((byte)1);
            this.channel.writeInt(iClientTxId);
            if (this.tokenConnection && this.requestType != 2 && (this.requestType != 3 && this.requestType != 1 || connection != null && connection.getData() != null && connection.getData().protocolVersion <= 32) || this.requestType == 17) {
                if (connection != null && connection.getToken() != null) {
                    byte[] renewedToken = this.server.getTokenHandler().renewIfNeeded(connection.getToken());
                    this.channel.writeBytes(renewedToken);
                } else {
                    this.channel.writeBytes(new byte[0]);
                }
            }
            Throwable current = t instanceof OLockException && t.getCause() instanceof ODatabaseException ? t.getCause() : t;
            this.sendErrorDetails(current);
            this.serializeExceptionObject(current);
            this.channel.flush();
            if (OLogManager.instance().isLevelEnabled(this.logClientExceptions)) {
                if (this.logClientFullStackTrace) {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", t, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                } else {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", null, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                this.shutdown();
            } else {
                OLogManager.instance().error((Object)this, "Error during sending an error to client", (Throwable)e, new Object[0]);
            }
        }
        finally {
            if (this.channel.getLockWrite().isHeldByCurrentThread()) {
                this.channel.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownConnection(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Shutdowning");
        OLogManager.instance().info((Object)this, "Received shutdown command from the remote client %s:%d", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        if (this.server.authenticate(user, passwd, "shutdown")) {
            OLogManager.instance().info((Object)this, "Remote client %s:%d authenticated. Starting shutdown of server...", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
            }
            finally {
                this.endResponse(connection);
            }
            this.runShutdownInNonDaemonThread();
            return;
        }
        OLogManager.instance().error((Object)this, "Authentication error of remote client %s:%d: shutdown is aborted.", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        this.sendErrorOrDropConnection(connection, this.clientTxId, new OSecurityAccessException("Invalid user/password to shutdown the server"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Copy the database to a remote server");
        String dbUrl = this.channel.readString();
        String dbUser = this.channel.readString();
        String dbPassword = this.channel.readString();
        String remoteServerName = this.channel.readString();
        String remoteServerEngine = this.channel.readString();
        this.checkServerAccess("database.copy", connection);
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)this.server.openDatabase(dbUrl, dbUser, dbPassword);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void replicationDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Replication command");
        ODocument request = new ODocument(this.channel.readBytes());
        ODistributedServerManager dManager = this.server.getDistributedManager();
        if (dManager == null) {
            throw new OConfigurationException("No distributed manager configured");
        }
        String operation = (String)request.field("operation");
        ODocument response = null;
        if (operation.equals("start")) {
            this.checkServerAccess("server.replication.start", connection);
        } else if (operation.equals("stop")) {
            this.checkServerAccess("server.replication.stop", connection);
        } else if (operation.equals("config")) {
            this.checkServerAccess("server.replication.config", connection);
            response = new ODocument().fromJSON(dManager.getDatabaseConfiguration((String)request.field("db")).getDocument().toJSON("prettyPrint"));
        }
        this.sendResponse(connection, response);
    }

    protected void distributedCluster(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Cluster status");
        ODocument req = new ODocument(this.channel.readBytes());
        ODocument response = null;
        String operation = (String)req.field("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Cluster operation is null");
        }
        if (operation.equals("status")) {
            Object plugin = this.server.getPlugin("cluster");
            if (plugin != null && plugin instanceof ODistributedServerManager) {
                response = ((ODistributedServerManager)plugin).getClusterConfiguration();
            }
        } else {
            throw new IllegalArgumentException("Cluster operation '" + operation + "' is not supported");
        }
        this.sendResponse(connection, response);
    }

    protected void countDatabaseRecords(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Database count records");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeLong(connection.getDatabase().getStorage().countRecords());
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void sizeDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Database size");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeLong(connection.getDatabase().getStorage().getSize());
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Drop database");
        String dbName = this.channel.readString();
        String storageType = null;
        storageType = this.channel.readString();
        if (storageType == null) {
            storageType = "plocal";
        }
        this.checkServerAccess("database.drop", connection);
        connection.setDatabase(this.getDatabaseInstance(dbName, "document", storageType));
        if (connection.getDatabase().exists()) {
            if (connection.getDatabase().isClosed()) {
                this.server.openDatabaseBypassingSecurity((ODatabaseInternal<?>)connection.getDatabase(), connection.getData(), connection.getServerUser().name);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        connection.getDatabase().drop();
        OLogManager.instance().info((Object)this, "Dropped database '%s'", new Object[]{connection.getDatabase().getName()});
        connection.close();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void existsDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Exists database");
        String dbName = this.channel.readString();
        String storageType = null;
        storageType = this.channel.readString();
        if (storageType == null) {
            storageType = "plocal";
        }
        this.checkServerAccess("database.exists", connection);
        boolean result = false;
        ODatabaseDocumentInternal database = this.getDatabaseInstance(dbName, "document", storageType);
        if (database.exists()) {
            result = true;
        } else {
            Orient.instance().unregisterStorage(database.getStorage());
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeByte((byte)(result ? 1 : 0));
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Create database");
        String dbName = this.channel.readString();
        String dbType = "document";
        dbType = this.channel.readString();
        String storageType = this.channel.readString();
        String backupPath = null;
        if (connection.getData().protocolVersion > 35) {
            backupPath = this.channel.readString();
        }
        this.checkServerAccess("database.create", connection);
        this.checkStorageExistence(dbName);
        connection.setDatabase(this.getDatabaseInstance(dbName, dbType, storageType));
        this.createDatabase(connection.getDatabase(), null, null, backupPath);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void closeDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Close Database");
        if (connection != null) {
            this.server.getClientConnectionManager().disconnect(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configList(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "List config");
        this.checkServerAccess("server.config.get", connection);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeShort((short)OGlobalConfiguration.values().length);
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                String value;
                String key;
                try {
                    key = cfg.getKey();
                }
                catch (Exception e) {
                    key = "?";
                }
                if (cfg.isHidden()) {
                    value = "<hidden>";
                } else {
                    try {
                        value = cfg.getValueAsString() != null ? cfg.getValueAsString() : "";
                    }
                    catch (Exception e) {
                        value = "";
                    }
                }
                this.channel.writeString(key);
                this.channel.writeString(value);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configSet(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Set config");
        this.checkServerAccess("server.config.set", connection);
        String key = this.channel.readString();
        String value = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        if (cfg != null) {
            cfg.setValue((Object)value);
            if (!cfg.isChangeableAtRuntime().booleanValue()) {
                throw new OConfigurationException("Property '" + key + "' cannot be changed at runtime. Change the setting at startup");
            }
        } else {
            throw new OConfigurationException("Property '" + key + "' was not found in global configuration");
        }
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configGet(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Get config");
        this.checkServerAccess("server.config.get", connection);
        String key = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        String cfgValue = cfg != null ? (cfg.isHidden() ? "<hidden>" : cfg.getValueAsString()) : "";
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeString(cfgValue);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Transaction commit");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy(connection, this);
        try {
            connection.getDatabase().begin((OTransaction)tx);
            try {
                connection.getDatabase().commit();
                this.beginResponse();
                try {
                    this.sendOk(connection, this.clientTxId);
                    this.channel.writeInt(tx.getCreatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeRID(entry.getValue().getIdentity());
                        if (entry.getValue().getVersion() <= 0) continue;
                        tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                    }
                    this.channel.writeInt(tx.getUpdatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeVersion(entry.getValue().getVersion());
                    }
                    if (connection.getData().protocolVersion >= 20) {
                        this.sendCollectionChanges(connection);
                    }
                }
                finally {
                    this.endResponse(connection);
                }
            }
            catch (Exception e) {
                if (connection != null && connection.getDatabase() != null) {
                    OSBTreeCollectionManager collectionManager;
                    if (connection.getDatabase().getTransaction().isActive()) {
                        connection.getDatabase().rollback(true);
                    }
                    if ((collectionManager = connection.getDatabase().getSbTreeCollectionManager()) != null) {
                        collectionManager.clearChangedIds();
                    }
                }
                this.sendErrorOrDropConnection(connection, this.clientTxId, e);
            }
        }
        catch (OTransactionAbortedException e) {
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback(true, -1);
            }
            this.sendErrorOrDropConnection(connection, this.clientTxId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void command(OClientConnection connection) throws IOException {
        block21: {
            String name;
            boolean asynch;
            this.setDataCommandInfo(connection, "Execute remote command");
            byte type = this.channel.readByte();
            boolean live = type == 108;
            boolean bl = asynch = type == 97;
            if (connection == null && connection.getDatabase() == null) {
                throw new IOException("Found invalid session");
            }
            String dbSerializerName = connection.getDatabase().getSerializer().toString();
            if (!dbSerializerName.equals(name = this.getRecordSerializerName(connection))) {
                ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
                ONetworkThreadLocalSerializer.setNetworkSerializer((ORecordSerializer)ser);
            }
            OCommandRequestText command = (OCommandRequestText)OStreamSerializerAnyStreamable.INSTANCE.fromStream(this.channel.readBytes());
            ONetworkThreadLocalSerializer.setNetworkSerializer(null);
            Map params = command.getParameters();
            if (asynch && command instanceof OSQLSynchQuery) {
                OSQLAsynchQuery asynchQuery = new OSQLAsynchQuery(command.getText());
                asynchQuery.setFetchPlan(command.getFetchPlan());
                asynchQuery.setLimit(command.getLimit());
                asynchQuery.setTimeout(command.getTimeoutTime(), command.getTimeoutStrategy());
                asynchQuery.setUseCache(((OSQLSynchQuery)command).isUseCache());
                command = asynchQuery;
            }
            connection.getData().commandDetail = command.getText();
            this.beginResponse();
            try {
                connection.getData().command = command;
                OAbstractCommandResultListener listener = null;
                OLiveCommandResultListener liveListener = null;
                OCommandResultListener cmdResultListener = command.getResultListener();
                if (live) {
                    liveListener = new OLiveCommandResultListener(this.server, connection, this.clientTxId, cmdResultListener);
                    listener = new OSyncCommandResultListener(null);
                    command.setResultListener((OCommandResultListener)liveListener);
                } else if (asynch) {
                    final OCommandCache cmdCache = connection.getDatabase().getMetadata().getCommandCache();
                    if (cmdCache.isEnabled()) {
                        cmdResultListener = new OAbstractCommandResultListener(cmdResultListener){
                            private OResultSet collector;
                            {
                                super(wrappedResultListener);
                                this.collector = new OConcurrentResultSet();
                            }

                            @Override
                            public boolean isEmpty() {
                                return this.collector != null && this.collector.isEmpty();
                            }

                            public boolean result(Object iRecord) {
                                if (this.collector != null) {
                                    if (this.collector.currentSize() > cmdCache.getMaxResultsetSize()) {
                                        this.collector = null;
                                    } else if (iRecord != null && iRecord instanceof ORecord) {
                                        this.collector.add(iRecord);
                                    }
                                }
                                return true;
                            }

                            @Override
                            public Object getResult() {
                                return this.collector;
                            }

                            @Override
                            public void end() {
                                this.collector.setCompleted();
                            }
                        };
                    }
                    listener = new OAsyncCommandResultListener(connection, this, this.clientTxId, cmdResultListener);
                    command.setResultListener((OCommandResultListener)listener);
                } else {
                    listener = new OSyncCommandResultListener(null);
                }
                long serverTimeout = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
                if (serverTimeout > 0L && command.getTimeoutTime() > serverTimeout) {
                    command.setTimeout(serverTimeout, command.getTimeoutStrategy());
                }
                if (!this.isConnectionAlive(connection)) {
                    return;
                }
                command.setCacheableResult(true);
                listener.setFetchPlan(connection.getDatabase().command((OCommandRequest)command).getFetchPlan());
                Object result = params == null ? connection.getDatabase().command((OCommandRequest)command).execute(new Object[0]) : connection.getDatabase().command((OCommandRequest)command).execute(new Object[]{params});
                listener.setFetchPlan(command.getFetchPlan());
                if (asynch) {
                    if (listener.isEmpty()) {
                        try {
                            this.sendOk(connection, this.clientTxId);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.channel.writeByte((byte)0);
                    break block21;
                }
                this.sendOk(connection, this.clientTxId);
                boolean isRecordResultSet = true;
                if (command instanceof OCommandRequestInternal) {
                    isRecordResultSet = command.isRecordResultSet();
                }
                this.serializeValue(connection, listener, result, false, isRecordResultSet);
                if (listener instanceof OSyncCommandResultListener) {
                    for (ORecord rec : ((OSyncCommandResultListener)listener).getFetchedRecordsToSend()) {
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable(connection, (OIdentifiable)rec);
                    }
                    this.channel.writeByte((byte)0);
                }
            }
            finally {
                connection.getData().command = null;
                this.endResponse(connection);
            }
        }
    }

    public void serializeValue(OClientConnection connection, OAbstractCommandResultListener listener, Object result, boolean load, boolean isRecordResultSet) throws IOException {
        if (result == null) {
            this.channel.writeByte((byte)110);
        } else if (result instanceof OIdentifiable) {
            this.channel.writeByte((byte)114);
            if (load && result instanceof ORecordId) {
                result = ((ORecordId)result).getRecord();
            }
            if (listener != null) {
                listener.result(result);
            }
            this.writeIdentifiable(connection, (OIdentifiable)result);
        } else if (result instanceof ODocumentWrapper) {
            this.channel.writeByte((byte)114);
            ODocument doc = ((ODocumentWrapper)result).getDocument();
            if (listener != null) {
                listener.result(doc);
            }
            this.writeIdentifiable(connection, (OIdentifiable)doc);
        } else if (!isRecordResultSet) {
            this.writeSimpleValue(connection, listener, result);
        } else if (OMultiValue.isMultiValue((Object)result)) {
            byte collectionType = result instanceof Set ? (byte)115 : 108;
            this.channel.writeByte(collectionType);
            this.channel.writeInt(OMultiValue.getSize((Object)result));
            for (Object o : OMultiValue.getMultiValueIterable((Object)result, (boolean)false)) {
                try {
                    if (load && o instanceof ORecordId) {
                        o = ((ORecordId)o).getRecord();
                    }
                    if (listener != null) {
                        listener.result(o);
                    }
                    this.writeIdentifiable(connection, (OIdentifiable)o);
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    this.writeIdentifiable(connection, null);
                }
            }
        } else if (OMultiValue.isIterable((Object)result)) {
            if (connection.getData().protocolVersion >= 32) {
                this.channel.writeByte((byte)105);
                for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        this.channel.writeByte((byte)1);
                        this.writeIdentifiable(connection, (OIdentifiable)o);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
                this.channel.writeByte((byte)0);
            } else {
                byte collectionType = result instanceof Set ? (byte)115 : 108;
                this.channel.writeByte(collectionType);
                this.channel.writeInt(OMultiValue.getSize((Object)result));
                for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        this.writeIdentifiable(connection, (OIdentifiable)o);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
            }
        } else {
            this.writeSimpleValue(connection, listener, result);
        }
    }

    private void writeSimpleValue(OClientConnection connection, OAbstractCommandResultListener listener, Object result) throws IOException {
        if (connection.getData().protocolVersion >= 35) {
            this.channel.writeByte((byte)119);
            ODocument document = new ODocument();
            document.field("result", result);
            this.writeIdentifiable(connection, (OIdentifiable)document);
        } else {
            this.channel.writeByte((byte)97);
            StringBuilder value = new StringBuilder(64);
            if (listener != null) {
                listener.result(result);
            }
            ORecordSerializerStringAbstract.fieldTypeToString((StringBuilder)value, (OType)OType.getTypeByClass(result.getClass()), (Object)result);
            this.channel.writeString(value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Delete record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        int version = this.channel.readVersion();
        byte mode = this.channel.readByte();
        int result = this.deleteRecord((ODatabaseDocument)connection.getDatabase(), (ORID)rid, version);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Hide record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        byte mode = this.channel.readByte();
        int result = this.hideRecord((ODatabaseDocument)connection.getDatabase(), (ORID)rid);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOutRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Clean out record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        int version = this.channel.readVersion();
        byte mode = this.channel.readByte();
        int result = this.cleanOutRecord((ODatabaseDocument)connection.getDatabase(), (ORID)rid, version);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Update record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        boolean updateContent = true;
        if (connection.getData().protocolVersion >= 23) {
            updateContent = this.channel.readBoolean();
        }
        byte[] buffer = this.channel.readBytes();
        int version = this.channel.readVersion();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        int newVersion = this.updateRecord(connection, rid, buffer, version, recordType, updateContent);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeVersion(newVersion);
                if (connection.getData().protocolVersion >= 20) {
                    this.sendCollectionChanges(connection);
                }
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Create record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        int dataSegmentId = connection.getData().protocolVersion < 24 ? this.channel.readInt() : 0;
        ORecordId rid = new ORecordId((int)this.channel.readShort(), -1L);
        byte[] buffer = this.channel.readBytes();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        ORecord record = this.createRecord(connection, rid, buffer, recordType);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                if (connection.getData().protocolVersion > 25) {
                    this.channel.writeShort((short)record.getIdentity().getClusterId());
                }
                this.channel.writeLong(record.getIdentity().getClusterPosition());
                this.channel.writeVersion(record.getVersion());
                if (connection.getData().protocolVersion >= 20) {
                    this.sendCollectionChanges(connection);
                }
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecordMetadata(OClientConnection connection) throws IOException {
        block4: {
            this.setDataCommandInfo(connection, "Record metadata");
            ORecordId rid = this.channel.readRID();
            this.beginResponse();
            try {
                ORecordMetadata metadata = connection.getDatabase().getRecordMetadata((ORID)rid);
                if (metadata != null) {
                    this.sendOk(connection, this.clientTxId);
                    this.channel.writeRID(metadata.getRecordId());
                    this.channel.writeVersion(metadata.getVersion());
                    break block4;
                }
                throw new ODatabaseException(String.format("Record metadata for RID: %s, Not found", rid));
            }
            finally {
                this.endResponse(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecord(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Load record");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        String fetchPlanString = this.channel.readString();
        boolean ignoreCache = false;
        ignoreCache = this.channel.readByte() == 1;
        boolean loadTombstones = false;
        boolean bl = loadTombstones = this.channel.readByte() > 0;
        if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeByte((byte)1);
                if (connection.getData().protocolVersion <= 27) {
                    this.channel.writeBytes(connection.getDatabase().getStorage().getConfiguration().toStream((int)connection.getData().protocolVersion));
                    this.channel.writeVersion(0);
                    this.channel.writeByte((byte)98);
                } else {
                    this.channel.writeByte((byte)98);
                    this.channel.writeVersion(0);
                    this.channel.writeBytes(connection.getDatabase().getStorage().getConfiguration().toStream((int)connection.getData().protocolVersion));
                }
                this.channel.writeByte((byte)0);
            }
            finally {
                this.endResponse(connection);
            }
        }
        ORecord record = (ORecord)connection.getDatabase().load((ORID)rid, fetchPlanString, ignoreCache, loadTombstones, OStorage.LOCKING_STRATEGY.NONE);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            if (record != null) {
                this.channel.writeByte((byte)1);
                byte[] bytes = this.getRecordBytes(connection, record);
                int length = this.trimCsvSerializedContent(connection, bytes);
                if (connection.getData().protocolVersion <= 27) {
                    this.channel.writeBytes(bytes, length);
                    this.channel.writeVersion(record.getVersion());
                    this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                } else {
                    this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                    this.channel.writeVersion(record.getVersion());
                    this.channel.writeBytes(bytes, length);
                }
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    final HashSet recordsToSend = new HashSet();
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                    for (ORecord d : recordsToSend) {
                        if (!d.getIdentity().isValid()) continue;
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable(connection, (OIdentifiable)d);
                    }
                }
            }
            this.channel.writeByte((byte)0);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecordIfVersionIsNotLatest(OClientConnection connection) throws IOException {
        boolean ignoreCache;
        this.setDataCommandInfo(connection, "Load record if version is not latest");
        if (!this.isConnectionAlive(connection)) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        int recordVersion = this.channel.readVersion();
        String fetchPlanString = this.channel.readString();
        boolean bl = ignoreCache = this.channel.readByte() == 1;
        if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeByte((byte)1);
                if (connection.getData().protocolVersion <= 27) {
                    this.channel.writeBytes(connection.getDatabase().getStorage().getConfiguration().toStream((int)connection.getData().protocolVersion));
                    this.channel.writeVersion(0);
                    this.channel.writeByte((byte)98);
                } else {
                    this.channel.writeByte((byte)98);
                    this.channel.writeVersion(0);
                    this.channel.writeBytes(connection.getDatabase().getStorage().getConfiguration().toStream((int)connection.getData().protocolVersion));
                }
                this.channel.writeByte((byte)0);
            }
            finally {
                this.endResponse(connection);
            }
        }
        ORecord record = connection.getDatabase().loadIfVersionIsNotLatest((ORID)rid, recordVersion, fetchPlanString, ignoreCache);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            if (record != null) {
                this.channel.writeByte((byte)1);
                byte[] bytes = this.getRecordBytes(connection, record);
                int length = this.trimCsvSerializedContent(connection, bytes);
                this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                this.channel.writeVersion(record.getVersion());
                this.channel.writeBytes(bytes, length);
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    final HashSet recordsToSend = new HashSet();
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                    for (ORecord d : recordsToSend) {
                        if (!d.getIdentity().isValid()) continue;
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable(connection, (OIdentifiable)d);
                    }
                }
            }
            this.channel.writeByte((byte)0);
        }
        finally {
            this.endResponse(connection);
        }
    }

    protected void beginResponse() {
        this.channel.acquireWriteLock();
    }

    protected void endResponse(OClientConnection connection) throws IOException {
        if (connection != null && connection.getDatabase() != null && connection.getDatabase().activateOnCurrentThread().getTransaction() != null) {
            connection.getDatabase().activateOnCurrentThread();
            connection.getDatabase().getTransaction().rollback();
        }
        this.channel.flush();
        this.channel.releaseWriteLock();
    }

    protected void setDataCommandInfo(OClientConnection connection, String iCommandInfo) {
        if (connection != null) {
            connection.getData().commandInfo = iCommandInfo;
        }
    }

    protected void readConnectionData(OClientConnection connection) throws IOException {
        connection.getData().driverName = this.channel.readString();
        connection.getData().driverVersion = this.channel.readString();
        connection.getData().protocolVersion = this.channel.readShort();
        connection.getData().clientId = this.channel.readString();
        connection.getData().serializationImpl = connection.getData().protocolVersion > 21 ? this.channel.readString() : "ORecordDocument2csv";
        if (connection.getTokenBased() == null) {
            if (connection.getData().protocolVersion > 26) {
                connection.setTokenBased(this.channel.readBoolean());
            } else {
                connection.setTokenBased(false);
            }
        } else if (connection.getData().protocolVersion <= 26 || this.channel.readBoolean() != connection.getTokenBased().booleanValue()) {
            // empty if block
        }
        if (connection.getData().protocolVersion > 33) {
            connection.getData().supportsPushMessages = this.channel.readBoolean();
            connection.getData().collectStats = this.channel.readBoolean();
        } else {
            connection.getData().supportsPushMessages = true;
            connection.getData().collectStats = true;
        }
    }

    protected void sendOk(OClientConnection connection, int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
        this.okSent = true;
        if (connection != null && Boolean.TRUE.equals(connection.getTokenBased()) && connection.getToken() != null && this.requestType != 2 && this.requestType != 3) {
            byte[] renewedToken = this.server.getTokenHandler().renewIfNeeded(connection.getToken());
            this.channel.writeBytes(renewedToken);
        }
    }

    protected void handleConnectionError(OClientConnection connection, Throwable e) {
        try {
            this.channel.flush();
        }
        catch (IOException e1) {
            OLogManager.instance().debug((Object)this, "Error during channel flush", (Throwable)e1, new Object[0]);
        }
        OLogManager.instance().error((Object)this, "Error executing request", e, new Object[0]);
        OServerPluginHelper.invokeHandlerCallbackOnClientError(this.server, connection, e);
    }

    protected void sendResponse(OClientConnection connection, ODocument iResponse) throws IOException {
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeBytes(iResponse != null ? iResponse.toStream() : null);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freezeDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Freeze database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.freeze", connection);
        String storageType = null;
        storageType = this.channel.readString();
        if (storageType == null) {
            storageType = "plocal";
        }
        connection.setDatabase(this.getDatabaseInstance(dbName, "document", storageType));
        if (connection.getDatabase().exists()) {
            OLogManager.instance().info((Object)this, "Freezing database '%s'", new Object[]{connection.getDatabase().getURL()});
            if (connection.getDatabase().isClosed()) {
                this.server.openDatabaseBypassingSecurity((ODatabaseInternal<?>)connection.getDatabase(), connection.getData(), connection.getServerUser().name);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        connection.getDatabase().freeze(true);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseDatabase(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Release database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.release", connection);
        String storageType = null;
        storageType = this.channel.readString();
        if (storageType == null) {
            storageType = "plocal";
        }
        connection.setDatabase(this.getDatabaseInstance(dbName, "document", storageType));
        if (connection.getDatabase().exists()) {
            OLogManager.instance().info((Object)this, "Realising database '%s'", new Object[]{connection.getDatabase().getURL()});
            if (connection.getDatabase().isClosed()) {
                this.server.openDatabaseBypassingSecurity((ODatabaseInternal<?>)connection.getDatabase(), connection.getData(), connection.getServerUser().name);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        connection.getDatabase().release();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
        }
        finally {
            this.endResponse(connection);
        }
    }

    public String getRecordSerializerName(OClientConnection connection) {
        return connection.getData().serializationImpl;
    }

    private void sendErrorDetails(Throwable current) throws IOException {
        while (current != null) {
            this.channel.writeByte((byte)1);
            this.channel.writeString(current.getClass().getName());
            this.channel.writeString(current.getMessage());
            current = current.getCause();
        }
        this.channel.writeByte((byte)0);
    }

    private void serializeExceptionObject(Throwable original) throws IOException {
        try {
            ODistributedServerManager srvMgr = this.server.getDistributedManager();
            if (srvMgr != null) {
                original = srvMgr.convertException(original);
            }
            OMemoryStream memoryStream = new OMemoryStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)memoryStream);
            objectOutputStream.writeObject(original);
            objectOutputStream.flush();
            byte[] result = memoryStream.toByteArray();
            objectOutputStream.close();
            this.channel.writeBytes(result);
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Cannot serialize an exception object", (Throwable)e, new Object[0]);
            this.channel.writeBytes(OCommonConst.EMPTY_BYTE_ARRAY);
        }
    }

    private void runShutdownInNonDaemonThread() {
        Thread shutdownThread = new Thread("OrientDB server shutdown thread"){

            @Override
            public void run() {
                ONetworkProtocolBinary.this.server.shutdown();
                ShutdownHelper.shutdown(1);
            }
        };
        shutdownThread.setDaemon(false);
        shutdownThread.start();
        try {
            shutdownThread.join();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ridBagSize(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "RidBag get size");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(this.channel);
        byte[] changeStream = this.channel.readBytes();
        OSBTreeCollectionManager sbTreeCollectionManager = connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            Map changes = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE.deserializeChanges(changeStream, 0);
            int realSize = tree.getRealBagSize(changes);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeInt(realSize);
            }
            finally {
                this.endResponse(connection);
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiGetEntriesMajor(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "SB-Tree bonsai get values major");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(this.channel);
        byte[] keyStream = this.channel.readBytes();
        boolean inclusive = this.channel.readBoolean();
        int pageSize = 128;
        if (connection.getData().protocolVersion >= 21) {
            pageSize = this.channel.readInt();
        }
        OSBTreeCollectionManager sbTreeCollectionManager = connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OBinarySerializer keySerializer = tree.getKeySerializer();
            OIdentifiable key = (OIdentifiable)keySerializer.deserialize(keyStream, 0);
            OBinarySerializer valueSerializer = tree.getValueSerializer();
            OTreeInternal.AccumulativeListener listener = new OTreeInternal.AccumulativeListener(pageSize);
            tree.loadEntriesMajor((Object)key, inclusive, true, (OTreeInternal.RangeResultListener)listener);
            List result = listener.getResult();
            byte[] stream = this.serializeSBTreeEntryCollection(result, (OBinarySerializer<OIdentifiable>)keySerializer, (OBinarySerializer<Integer>)valueSerializer);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse(connection);
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    private byte[] serializeSBTreeEntryCollection(List<Map.Entry<OIdentifiable, Integer>> collection, OBinarySerializer<OIdentifiable> keySerializer, OBinarySerializer<Integer> valueSerializer) {
        byte[] stream = new byte[4 + collection.size() * (keySerializer.getFixedLength() + valueSerializer.getFixedLength())];
        int offset = 0;
        OIntegerSerializer.INSTANCE.serializeLiteral(collection.size(), stream, offset);
        offset += 4;
        for (Map.Entry<OIdentifiable, Integer> entry : collection) {
            keySerializer.serialize((Object)entry.getKey(), stream, offset, new Object[0]);
            valueSerializer.serialize((Object)entry.getValue(), stream, offset += keySerializer.getObjectSize((Object)entry.getKey(), new Object[0]), new Object[0]);
            offset += valueSerializer.getObjectSize((Object)entry.getValue(), new Object[0]);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiFirstKey(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "SB-Tree bonsai get first key");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(this.channel);
        OSBTreeCollectionManager sbTreeCollectionManager = connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OIdentifiable result = (OIdentifiable)tree.firstKey();
            Object keySerializer = result == null ? ONullSerializer.INSTANCE : tree.getKeySerializer();
            byte[] stream = new byte[1 + keySerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(keySerializer.getId()), stream, 0, new Object[0]);
            keySerializer.serialize((Object)result, stream, 1, new Object[0]);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse(connection);
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiGet(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "SB-Tree bonsai get");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(this.channel);
        byte[] keyStream = this.channel.readBytes();
        OSBTreeCollectionManager sbTreeCollectionManager = connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OIdentifiable key = (OIdentifiable)tree.getKeySerializer().deserialize(keyStream, 0);
            Integer result = (Integer)tree.get((Object)key);
            Object valueSerializer = result == null ? ONullSerializer.INSTANCE : tree.getValueSerializer();
            byte[] stream = new byte[1 + valueSerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(valueSerializer.getId()), stream, 0, new Object[0]);
            valueSerializer.serialize((Object)result, stream, 1, new Object[0]);
            this.beginResponse();
            try {
                this.sendOk(connection, this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse(connection);
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSBTreeBonsai(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Create SB-Tree bonsai instance");
        int clusterId = this.channel.readInt();
        OBonsaiCollectionPointer collectionPointer = connection.getDatabase().getSbTreeCollectionManager().createSBTree(clusterId, null);
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(this.channel, collectionPointer);
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerPositions(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Retrieve lower positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            OPhysicalPosition[] previousPositions = connection.getDatabase().getStorage().lowerPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void floorPositions(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Retrieve floor positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            OPhysicalPosition[] previousPositions = connection.getDatabase().getStorage().floorPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void higherPositions(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Retrieve higher positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            OPhysicalPosition[] nextPositions = connection.getDatabase().getStorage().higherPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (nextPositions != null) {
                this.channel.writeInt(nextPositions.length);
                for (OPhysicalPosition physicalPosition : nextPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ceilingPositions(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Retrieve ceiling positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            OPhysicalPosition[] previousPositions = connection.getDatabase().getStorage().ceilingPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse(connection);
        }
    }

    private boolean isConnectionAlive(OClientConnection connection) {
        if (connection == null || connection.getDatabase() == null) {
            this.server.getClientConnectionManager().kill(connection);
            return false;
        }
        return true;
    }

    private void sendCollectionChanges(OClientConnection connection) throws IOException {
        OSBTreeCollectionManager collectionManager = connection.getDatabase().getSbTreeCollectionManager();
        if (collectionManager != null) {
            Map changedIds = collectionManager.changedIds();
            this.channel.writeInt(changedIds.size());
            for (Map.Entry entry : changedIds.entrySet()) {
                UUID id = (UUID)entry.getKey();
                this.channel.writeLong(id.getMostSignificantBits());
                this.channel.writeLong(id.getLeastSignificantBits());
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(this.channel, (OBonsaiCollectionPointer)entry.getValue());
            }
            collectionManager.clearChangedIds();
        }
    }

    private void sendDatabaseInformation(OClientConnection connection) throws IOException {
        Collection clusters = connection.getDatabase().getStorage().getClusterInstances();
        int clusterCount = 0;
        for (OCluster c : clusters) {
            if (c == null) continue;
            ++clusterCount;
        }
        this.channel.writeShort((short)clusterCount);
        for (OCluster c : clusters) {
            if (c == null) continue;
            this.channel.writeString(c.getName());
            this.channel.writeShort((short)c.getId());
            if (connection.getData().protocolVersion >= 24) continue;
            this.channel.writeString("none");
            this.channel.writeShort((short)-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listDatabases(OClientConnection connection) throws IOException {
        this.checkServerAccess("server.dblist", connection);
        ODocument result = new ODocument();
        result.field("databases", this.server.getAvailableStorageNames());
        this.setDataCommandInfo(connection, "List databases");
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            byte[] stream = this.getRecordBytes(connection, (ORecord)result);
            this.channel.writeBytes(stream);
        }
        finally {
            this.endResponse(connection);
        }
    }

    private void serverInfo(OClientConnection connection) throws IOException {
        this.checkServerAccess("server.info", connection);
        this.setDataCommandInfo(connection, "Server Info");
        this.beginResponse();
        try {
            this.sendOk(connection, this.clientTxId);
            this.channel.writeString(OServerInfo.getServerInfo(this.server));
        }
        finally {
            this.endResponse(connection);
        }
    }

    private boolean loadUserFromSchema(OClientConnection connection, String iUserName, String iUserPassword) {
        connection.getDatabase().getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
        return true;
    }

    @Override
    public int getVersion() {
        return 36;
    }

    public OChannelBinary getChannel() {
        return this.channel;
    }

    public void writeIdentifiable(OClientConnection connection, OIdentifiable o) throws IOException {
        if (o == null) {
            this.channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            this.channel.writeShort((short)-3);
            this.channel.writeRID((ORID)o);
        } else {
            this.writeRecord(connection, o.getRecord());
        }
    }

    @Override
    public String getType() {
        return "binary";
    }

    public void fillRecord(OClientConnection connection, ORecordId rid, byte[] buffer, int version, ORecord record) {
        String dbSerializerName = "";
        if (connection.getDatabase() != null) {
            dbSerializerName = connection.getDatabase().getSerializer().toString();
        }
        String name = this.getRecordSerializerName(connection);
        if (ORecordInternal.getRecordType((ORecord)record) == 100 && !dbSerializerName.equals(name)) {
            ORecordInternal.fill((ORecord)record, (ORID)rid, (int)version, null, (boolean)true);
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
            ser.fromStream(buffer, record, null);
            record.setDirty();
        } else {
            ORecordInternal.fill((ORecord)record, (ORID)rid, (int)version, (byte[])buffer, (boolean)true);
        }
    }

    protected void sendErrorOrDropConnection(OClientConnection connection, int iClientTxId, Throwable t) throws IOException {
        if (this.okSent || this.requestType == 5) {
            this.handleConnectionError(connection, t);
            this.sendShutdown();
        } else {
            this.okSent = true;
            this.sendError(connection, iClientTxId, t);
        }
    }

    protected void checkStorageExistence(String iDatabaseName) {
        for (OStorage stg : Orient.instance().getStorages()) {
            if (stg instanceof OStorageProxy || !stg.getName().equalsIgnoreCase(iDatabaseName) || !stg.exists()) continue;
            throw new ODatabaseException("Database named '" + iDatabaseName + "' already exists: " + stg);
        }
    }

    protected ODatabaseDocumentInternal createDatabase(ODatabaseDocumentInternal iDatabase, String dbUser, String dbPasswd, String backupPath) {
        if (iDatabase.exists()) {
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists");
        }
        if (backupPath == null) {
            iDatabase.create();
        } else {
            iDatabase.create(backupPath);
        }
        if (dbUser != null) {
            OUser oUser = iDatabase.getMetadata().getSecurity().getUser(dbUser);
            if (oUser == null) {
                iDatabase.getMetadata().getSecurity().createUser(dbUser, dbPasswd, new String[]{"admin"});
            } else {
                oUser.setPassword(dbPasswd);
                oUser.save();
            }
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{iDatabase.getName(), iDatabase.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage ? iDatabase.getStorage().getUnderlying().getType() : "memory"});
        return iDatabase;
    }

    protected ODatabaseDocumentInternal getDatabaseInstance(String dbName, String dbType, String storageType) {
        String path;
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            path = stg.getURL();
        } else if (storageType.equals("plocal")) {
            path = this.server.getConfiguration().getStoragePath(dbName);
            if (path == null) {
                path = storageType + ":" + this.server.getDatabaseDirectory() + "/" + dbName;
            }
        } else if (storageType.equals("memory")) {
            path = storageType + ":" + dbName;
        } else {
            throw new IllegalArgumentException("Cannot create database: storage mode '" + storageType + "' is not supported.");
        }
        return new ODatabaseDocumentTx(path);
    }

    protected int deleteRecord(ODatabaseDocument iDatabase, ORID rid, int version) {
        try {
            ORecord record = rid.getRecord();
            if (record == null) {
                return 0;
            }
            iDatabase.delete(rid, version);
            return 1;
        }
        catch (ORecordNotFoundException e) {
            if (e.getCause() instanceof OOfflineClusterException) {
                throw (OOfflineClusterException)e.getCause();
            }
        }
        catch (OOfflineClusterException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected int hideRecord(ODatabaseDocument iDatabase, ORID rid) {
        try {
            iDatabase.hide(rid);
            return 1;
        }
        catch (ORecordNotFoundException e) {
            return 0;
        }
    }

    protected int cleanOutRecord(ODatabaseDocument iDatabase, ORID rid, int version) {
        iDatabase.delete(rid, version);
        return 1;
    }

    protected ORecord createRecord(OClientConnection connection, ORecordId rid, byte[] buffer, byte recordType) {
        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        this.fillRecord(connection, rid, buffer, 0, record);
        connection.getDatabase().save((Object)record);
        return record;
    }

    protected int updateRecord(OClientConnection connection, ORecordId rid, byte[] buffer, int version, byte recordType, boolean updateContent) {
        ODatabaseDocumentInternal database = connection.getDatabase();
        ORecord newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        this.fillRecord(connection, rid, buffer, version, newRecord);
        ORecordInternal.setContentChanged((ORecord)newRecord, (boolean)updateContent);
        ORecordInternal.getDirtyManager((ORecord)newRecord).clearForSave();
        ORecord currentRecord = null;
        if (newRecord instanceof ODocument) {
            block6: {
                try {
                    currentRecord = (ORecord)database.load((ORID)rid);
                }
                catch (ORecordNotFoundException e) {
                    if (!(e.getCause() instanceof OOfflineClusterException)) break block6;
                    throw (OOfflineClusterException)e.getCause();
                }
            }
            if (currentRecord == null) {
                throw new ORecordNotFoundException((ORID)rid);
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
        } else {
            currentRecord = newRecord;
        }
        ORecordInternal.setVersion((ORecord)currentRecord, (int)version);
        database.save((Object)currentRecord);
        if (currentRecord.getIdentity().toString().equals(database.getStorage().getConfiguration().indexMgrRecordId) && !database.getStatus().equals((Object)ODatabase.STATUS.IMPORTING)) {
            database.getMetadata().getIndexManager().reload();
        }
        return currentRecord.getVersion();
    }

    public byte[] getRecordBytes(OClientConnection connection, ORecord iRecord) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        String name = this.getRecordSerializerName(connection);
        if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(name))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
            stream = ser.toStream(iRecord, false);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    private void writeRecord(OClientConnection connection, ORecord iRecord) throws IOException {
        this.channel.writeShort((short)0);
        this.channel.writeByte(ORecordInternal.getRecordType((ORecord)iRecord));
        this.channel.writeRID(iRecord.getIdentity());
        this.channel.writeVersion(iRecord.getVersion());
        try {
            byte[] stream = this.getRecordBytes(connection, iRecord);
            int realLength = this.trimCsvSerializedContent(connection, stream);
            this.channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            this.channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new OSerializationException(message), (Throwable)e);
        }
    }

    protected int trimCsvSerializedContent(OClientConnection connection, byte[] stream) {
        int realLength = stream.length;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db instanceof ODatabaseDocument && "ORecordDocument2csv".equals(this.getRecordSerializerName(connection))) {
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
        }
        return realLength;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getRemoteAddress() {
        Socket socket = this.getChannel().socket;
        if (socket != null) {
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            return remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        }
        return null;
    }
}

