/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODistributedRequest
implements Externalizable {
    private final ORemoteTaskFactory taskFactory;
    private ODistributedRequestId id;
    private String databaseName;
    private long senderThreadId;
    private ORemoteTask task;
    private ORID userRID;

    public ODistributedRequest(ORemoteTaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public ODistributedRequest(ORemoteTaskFactory taskFactory, int senderNodeId, long msgSequence, String databaseName, ORemoteTask payload) {
        this.taskFactory = taskFactory;
        this.id = new ODistributedRequestId(senderNodeId, msgSequence);
        this.databaseName = databaseName;
        this.senderThreadId = Thread.currentThread().getId();
        this.task = payload;
    }

    public ODistributedRequestId getId() {
        return this.id;
    }

    public void setId(ODistributedRequestId reqId) {
        this.id = reqId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ODistributedRequest setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public ORemoteTask getTask() {
        return this.task;
    }

    public ODistributedRequest setTask(ORemoteTask payload) {
        this.task = payload;
        return this;
    }

    public ORID getUserRID() {
        return this.userRID;
    }

    public void setUserRID(ORID iUserRID) {
        this.userRID = iUserRID;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeLong(this.senderThreadId);
        out.writeUTF(this.databaseName != null ? this.databaseName : "");
        out.writeByte(this.task.getFactoryId());
        this.task.writeExternal(out);
        out.writeObject(this.userRID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (ODistributedRequestId)in.readObject();
        this.senderThreadId = in.readLong();
        this.databaseName = in.readUTF();
        if (this.databaseName.isEmpty()) {
            this.databaseName = null;
        }
        this.task = this.taskFactory.createTask(in.readByte());
        this.task.readExternal(in);
        this.userRID = (ORID)in.readObject();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("id=");
        buffer.append(this.id);
        if (this.task != null) {
            buffer.append(" task=");
            buffer.append(this.task.toString());
        }
        if (this.userRID != null) {
            buffer.append(" user=");
            buffer.append(this.userRID);
        }
        return buffer.toString();
    }

    public static enum EXECUTION_MODE {
        RESPONSE,
        NO_RESPONSE;

    }
}

