/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.orient.client.binary.OChannelBinarySynchClient;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimerTask;

public class ORemoteServerChannel {
    private final ODistributedServerManager manager;
    private final String url;
    private final String remoteHost;
    private final int remotePort;
    private final String userName;
    private final String userPassword;
    private final String server;
    private OChannelBinarySynchClient channel;
    private static final int MAX_RETRY = 3;
    private static final String CLIENT_TYPE = "OrientDB Server";
    private static final boolean COLLECT_STATS = false;
    private int sessionId = -1;
    private byte[] sessionToken;
    private OContextConfiguration contextConfig = new OContextConfiguration();
    private Date createdOn = new Date();
    private volatile int totalConsecutiveErrors = 0;
    private static final int MAX_CONSECUTIVE_ERRORS = 10;
    private static final int BUFFER_SIZE = 1024;

    public ORemoteServerChannel(ODistributedServerManager manager, String iServer, String iURL, String user, String passwd) throws IOException {
        this.manager = manager;
        this.server = iServer;
        this.url = iURL;
        this.userName = user;
        this.userPassword = passwd;
        int sepPos = iURL.lastIndexOf(":");
        this.remoteHost = iURL.substring(0, sepPos);
        this.remotePort = Integer.parseInt(iURL.substring(sepPos + 1));
        this.connect();
    }

    public void sendRequest(final ODistributedRequest req) {
        this.networkOperation((byte)120, new OStorageRemoteOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws IOException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                    try {
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        try {
                            req.writeExternal(outStream);
                            byte[] serializedRequest = out.toByteArray();
                            if (ODistributedServerLog.isDebugEnabled()) {
                                ODistributedServerLog.debug((Object)this, ORemoteServerChannel.this.manager.getLocalNodeName(), ORemoteServerChannel.this.server, ODistributedServerLog.DIRECTION.OUT, "Sending request %s (%d bytes)", req, serializedRequest.length);
                            }
                            ORemoteServerChannel.this.channel.writeBytes(serializedRequest);
                        }
                        finally {
                            outStream.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    ORemoteServerChannel.this.channel.flush();
                }
                return null;
            }
        }, "Cannot send distributed request", 3, true);
    }

    public void sendResponse(final ODistributedResponse response) {
        this.networkOperation((byte)121, new OStorageRemoteOperation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws IOException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                    try {
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        try {
                            response.writeExternal(outStream);
                            byte[] serializedResponse = out.toByteArray();
                            if (ODistributedServerLog.isDebugEnabled()) {
                                ODistributedServerLog.debug((Object)this, ORemoteServerChannel.this.manager.getLocalNodeName(), ORemoteServerChannel.this.server, ODistributedServerLog.DIRECTION.OUT, "Sending response %s to reqId=%s (%d bytes)", response, response.getRequestId(), serializedResponse.length);
                            }
                            ORemoteServerChannel.this.channel.writeBytes(serializedResponse);
                        }
                        finally {
                            outStream.close();
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    ORemoteServerChannel.this.channel.flush();
                }
                return null;
            }
        }, "Cannot send response back to the sender node '" + response.getSenderNodeName() + "'", 3, true);
    }

    public void connect() throws IOException {
        this.channel = new OChannelBinarySynchClient(this.remoteHost, this.remotePort, null, this.contextConfig, 36);
        this.networkOperation((byte)2, new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute() throws IOException {
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.CLIENT_TYPE).writeString("2.2.5").writeShort((short)36).writeString("0");
                ORemoteServerChannel.this.channel.writeString(ODatabaseDocumentTx.getDefaultSerializer().toString());
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeBoolean(false);
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.this.userName);
                ORemoteServerChannel.this.channel.writeString(ORemoteServerChannel.this.userPassword);
                ORemoteServerChannel.this.channel.flush();
                ORemoteServerChannel.this.channel.beginResponse(false);
                ORemoteServerChannel.this.sessionId = ORemoteServerChannel.this.channel.readInt();
                ORemoteServerChannel.access$602(ORemoteServerChannel.this, ORemoteServerChannel.this.channel.readBytes());
                if (ORemoteServerChannel.this.sessionToken.length == 0) {
                    ORemoteServerChannel.access$602(ORemoteServerChannel.this, null);
                }
                return null;
            }
        }, "Cannot connect to the remote server '" + this.url + "'", 3, false);
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.sessionId = -1;
        this.sessionToken = null;
    }

    protected synchronized <T> T networkOperation(byte operationId, OStorageRemoteOperation<T> operation, String errorMessage, int maxRetry, boolean autoReconnect) {
        Exception lastException = null;
        for (int retry = 1; retry <= maxRetry; ++retry) {
            try {
                this.channel.setWaitResponseTimeout();
                this.channel.beginRequest(operationId, this.sessionId, this.sessionToken);
                T result = operation.execute();
                this.totalConsecutiveErrors = 0;
                return result;
            }
            catch (Exception e) {
                lastException = e;
                this.handleNewError();
                this.close();
                if (!autoReconnect || !this.manager.isNodeAvailable(this.server)) break;
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on sending message to distributed node (%s) retrying (%d/%d)", lastException.toString(), retry, maxRetry);
                if (retry > 1) {
                    try {
                        Thread.sleep(100 * (retry * 2));
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
                try {
                    this.connect();
                    this.totalConsecutiveErrors = 0;
                }
                catch (IOException e1) {
                    lastException = e1;
                    this.handleNewError();
                    ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on reconnecting to distributed node (%s)", lastException.toString());
                }
                continue;
            }
        }
        throw OException.wrapException((OException)((Object)new ODistributedException(errorMessage)), (Throwable)lastException);
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public String getServer() {
        return this.server;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    private void handleNewError() {
        ++this.totalConsecutiveErrors;
        if (this.totalConsecutiveErrors >= 10) {
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Reached %d consecutive errors on connection, remove the server '%s' from the cluster", this.totalConsecutiveErrors, this.server);
            Orient.instance().scheduleTask(new TimerTask(){

                @Override
                public void run() {
                    try {
                        ORemoteServerChannel.this.manager.removeServer(ORemoteServerChannel.this.server);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, 100L, 0L);
            throw new OIOException("Reached " + this.totalConsecutiveErrors + " consecutive errors on connection, remove the server '" + this.server + "' from the cluster");
        }
    }

    static /* synthetic */ byte[] access$602(ORemoteServerChannel x0, byte[] x1) {
        x0.sessionToken = x1;
        return x1;
    }

    public static interface OStorageRemoteOperation<T> {
        public T execute() throws IOException;
    }
}

