/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteServerChannel;
import java.io.IOException;

public class ORemoteServerController {
    private final ORemoteServerChannel requestChannel;
    private final ORemoteServerChannel responseChannel;

    public ORemoteServerController(ODistributedServerManager manager, String iServer, String iURL, String user, String passwd) throws IOException {
        ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), iServer, ODistributedServerLog.DIRECTION.OUT, "Creating remote channel to distributed server...", new Object[0]);
        this.requestChannel = new ORemoteServerChannel(manager, iServer, iURL, user, passwd);
        this.responseChannel = new ORemoteServerChannel(manager, iServer, iURL, user, passwd);
    }

    public void sendRequest(ODistributedRequest req) {
        this.requestChannel.sendRequest(req);
    }

    public void sendResponse(ODistributedResponse response) {
        this.responseChannel.sendResponse(response);
    }

    public void close() {
        ODistributedServerLog.debug((Object)this, this.requestChannel.getManager().getLocalNodeName(), this.requestChannel.getServer(), ODistributedServerLog.DIRECTION.OUT, "Closing remote channel to distributed server...", new Object[0]);
        this.requestChannel.close();
        this.responseChannel.close();
    }
}

