/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.http.OChunkedResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class OHttpResponse {
    public static final String JSON_FORMAT = "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments";
    public static final char[] URL_SEPARATOR = new char[]{'/'};
    private static final Charset utf8 = Charset.forName("utf8");
    public final String httpVersion;
    private final OutputStream out;
    public String headers;
    public String[] additionalHeaders;
    public String characterSet;
    public String contentType;
    public String serverInfo;
    public String sessionId;
    public String callbackFunction;
    public String contentEncoding;
    public boolean sendStarted = false;
    public String content;
    public int code;
    public boolean keepAlive = true;
    public boolean jsonErrorResponse = true;
    public OClientConnection connection;
    private boolean streaming = OGlobalConfiguration.NETWORK_HTTP_STREAMING.getValueAsBoolean();

    public OHttpResponse(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction, boolean iKeepAlive, OClientConnection connection) {
        this.out = iOutStream;
        this.httpVersion = iHttpVersion;
        this.additionalHeaders = iAdditionalHeaders;
        this.characterSet = iResponseCharSet;
        this.serverInfo = iServerInfo;
        this.sessionId = iSessionId;
        this.callbackFunction = iCallbackFunction;
        this.keepAlive = iKeepAlive;
        this.connection = connection;
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        boolean empty;
        if (this.sendStarted) {
            return;
        }
        this.sendStarted = true;
        if (this.callbackFunction != null) {
            this.content = this.callbackFunction + "(" + iContent + ")";
            this.contentType = "text/javascript";
        } else {
            if (this.content == null || this.content.length() == 0) {
                String string = this.content = iContent != null ? iContent.toString() : null;
            }
            if (this.contentType == null || this.contentType.length() == 0) {
                this.contentType = iContentType;
            }
        }
        boolean bl = empty = this.content == null || this.content.length() == 0;
        if (this.code > 0) {
            this.writeStatus(this.code, iReason);
        } else {
            this.writeStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        }
        this.writeHeaders(this.contentType, this.keepAlive);
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        if (this.sessionId != null) {
            this.writeLine("Set-Cookie: OSESSIONID=" + this.sessionId + "; Path=/; HttpOnly");
        }
        byte[] binaryContent = null;
        if (!empty) {
            binaryContent = this.contentEncoding != null && this.contentEncoding.equals("gzip") ? this.compress(this.content) : this.content.getBytes(utf8);
        }
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.out.write(binaryContent);
        }
        this.flush();
    }

    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.httpVersion + " " + iStatus + " " + iReason);
    }

    public void writeHeaders(String iContentType) throws IOException {
        this.writeHeaders(iContentType, true);
    }

    public void writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        if (this.headers != null) {
            this.writeLine(this.headers);
        }
        this.writeLine("Date: " + new Date());
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.characterSet);
        this.writeLine("Server: " + this.serverInfo);
        this.writeLine("Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        if (this.contentEncoding != null && this.contentEncoding.length() > 0) {
            this.writeLine("Content-Encoding: " + this.contentEncoding);
        }
        if (this.additionalHeaders != null) {
            for (String h : this.additionalHeaders) {
                this.writeLine(h);
            }
        }
    }

    public void writeLine(String iContent) throws IOException {
        this.writeContent(iContent);
        this.out.write(OHttpUtils.EOL);
    }

    public void writeContent(String iContent) throws IOException {
        if (iContent != null) {
            this.out.write(iContent.getBytes(utf8));
        }
    }

    public void writeResult(Object iResult) throws InterruptedException, IOException {
        this.writeResult(iResult, null, null, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept) throws InterruptedException, IOException {
        this.writeResult(iResult, iFormat, iAccept, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept, Map<String, Object> iAdditionalProperties) throws InterruptedException, IOException {
        this.writeResult(iResult, iFormat, iAccept, iAdditionalProperties, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept, Map<String, Object> iAdditionalProperties, String mode) throws InterruptedException, IOException {
        if (iResult == null) {
            this.send(204, "", "text/plain", null, null);
        } else {
            Iterator<Object> newResult;
            if (iResult instanceof Map) {
                ODocument doc = new ODocument();
                for (Map.Entry entry : ((Map)iResult).entrySet()) {
                    String key = this.keyFromMapObject(entry.getKey());
                    doc.field(key, entry.getValue());
                }
                newResult = Collections.singleton(doc).iterator();
            } else {
                newResult = OMultiValue.isMultiValue((Object)iResult) && OMultiValue.getSize((Object)iResult) > 0 && !(OMultiValue.getFirstValue((Object)iResult) instanceof OIdentifiable) ? Collections.singleton(new ODocument().field("value", iResult)).iterator() : (iResult instanceof OIdentifiable ? Collections.singleton(iResult).iterator() : (iResult instanceof Iterable ? ((Iterable)iResult).iterator() : (OMultiValue.isMultiValue((Object)iResult) ? OMultiValue.getMultiValueIterator((Object)iResult) : Collections.singleton(new ODocument().field("value", iResult)).iterator())));
            }
            if (newResult == null) {
                this.send(204, "", "text/plain", null, null);
            } else {
                this.writeRecords(newResult, null, iFormat, iAccept, iAdditionalProperties, mode);
            }
        }
    }

    public void writeRecords(Object iRecords) throws IOException {
        this.writeRecords(iRecords, null, null, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, null, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, iFormat, accept, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, null);
    }

    public void writeRecords(Object iRecords, final String iFetchPlan, String iFormat, String accept, final Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            return;
        }
        int size = OMultiValue.getSize((Object)iRecords);
        final Iterator it = OMultiValue.getMultiValueIterator((Object)iRecords);
        if (accept != null && accept.contains("text/csv")) {
            this.sendStream(200, "OK", "application/json", "data.csv", new OCallable<Void, OChunkedResponse>(){

                public Void call(OChunkedResponse iArgument) {
                    LinkedHashSet<String> colNames = new LinkedHashSet<String>();
                    ArrayList<ODocument> records = new ArrayList<ODocument>();
                    while (it.hasNext()) {
                        ORecord rec;
                        Object r = it.next();
                        if (r == null || !(r instanceof OIdentifiable) || (rec = ((OIdentifiable)r).getRecord()) == null || !(rec instanceof ODocument)) continue;
                        ODocument doc = (ODocument)rec;
                        records.add(doc);
                        for (String fieldName : doc.fieldNames()) {
                            colNames.add(fieldName);
                        }
                    }
                    ArrayList orderedColumns = new ArrayList(colNames);
                    try {
                        for (int col = 0; col < orderedColumns.size(); ++col) {
                            if (col > 0) {
                                iArgument.write(44);
                            }
                            iArgument.write(((String)orderedColumns.get(col)).getBytes());
                        }
                        iArgument.write(OHttpUtils.EOL);
                        for (ODocument doc : records) {
                            for (int col = 0; col < orderedColumns.size(); ++col) {
                                Object value;
                                if (col > 0) {
                                    iArgument.write(44);
                                }
                                if ((value = doc.field((String)orderedColumns.get(col))) == null) continue;
                                if (!(value instanceof Number)) {
                                    value = "\"" + value + "\"";
                                }
                                iArgument.write(value.toString().getBytes());
                            }
                            iArgument.write(OHttpUtils.EOL);
                        }
                        iArgument.flush();
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "HTTP response: error on writing records", (Throwable)e, new Object[0]);
                    }
                    return null;
                }
            });
        } else {
            iFormat = iFormat == null ? JSON_FORMAT : "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments," + iFormat;
            final String sendFormat = iFormat;
            if (this.streaming) {
                this.sendStream(200, "OK", "application/json", null, new OCallable<Void, OChunkedResponse>(){

                    public Void call(OChunkedResponse iArgument) {
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter(iArgument);
                            OHttpResponse.this.writeRecordsOnStream(iFetchPlan, sendFormat, iAdditionalProperties, it, writer);
                            writer.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            } else {
                StringWriter buffer = new StringWriter();
                this.writeRecordsOnStream(iFetchPlan, iFormat, iAdditionalProperties, it, buffer);
                this.send(200, "OK", "application/json", buffer.toString(), null);
            }
        }
    }

    private void writeRecordsOnStream(String iFetchPlan, String iFormat, Map<String, Object> iAdditionalProperties, Iterator<Object> it, Writer buffer) throws IOException {
        OJSONWriter json = new OJSONWriter(buffer, iFormat);
        json.beginObject();
        String format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        json.beginCollection(-1, true, "result");
        this.formatMultiValue(it, buffer, format);
        json.endCollection(-1, true);
        if (iAdditionalProperties != null) {
            for (Map.Entry<String, Object> entry : iAdditionalProperties.entrySet()) {
                Object v = entry.getValue();
                if (OMultiValue.isMultiValue((Object)v)) {
                    json.beginCollection(-1, true, entry.getKey());
                    this.formatMultiValue(OMultiValue.getMultiValueIterator((Object)v), buffer, format);
                    json.endCollection(-1, true);
                } else {
                    json.writeAttribute(entry.getKey(), v);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        json.endObject();
    }

    private void checkConnection() throws IOException {
        Socket socket = this.connection.getProtocol() == null || this.connection.getProtocol().getChannel() == null ? null : this.connection.getProtocol().getChannel().socket;
        if (socket == null || socket.isClosed() || socket.isInputShutdown()) {
            OLogManager.instance().debug((Object)this, "[OHttpResponse] found and removed pending closed channel %d (%s)", new Object[]{this.connection, socket});
            throw new IOException("Connection is closed");
        }
    }

    public void formatMultiValue(Iterator<?> iIterator, Writer buffer, String format) throws IOException {
        if (iIterator != null) {
            int counter = 0;
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry != null) {
                    if (counter++ > 0) {
                        buffer.append(", ");
                    }
                    if (entry instanceof OIdentifiable) {
                        ORecord rec = ((OIdentifiable)entry).getRecord();
                        if (rec != null) {
                            try {
                                String objectJson = rec.toJSON(format);
                                buffer.append(objectJson);
                            }
                            catch (Exception e) {
                                OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                            }
                        }
                    } else if (OMultiValue.isMultiValue(entry)) {
                        buffer.append("[");
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(entry), buffer, format);
                        buffer.append("]");
                    } else {
                        buffer.append(OJSONWriter.writeValue(entry, (String)format));
                    }
                }
                this.checkConnection();
            }
        }
    }

    public void writeRecord(ORecord iRecord) throws IOException {
        this.writeRecord(iRecord, null, null);
    }

    public void writeRecord(ORecord iRecord, String iFetchPlan, String iFormat) throws IOException {
        String format;
        if (iFormat == null) {
            iFormat = JSON_FORMAT;
        }
        String string = format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        if (iRecord != null) {
            this.send(200, "OK", "application/json", iRecord.toJSON(format), "ETag: " + iRecord.getVersion());
        }
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, null);
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        if (iSize < 0L) {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            if (iContent != null) {
                int b;
                while ((b = iContent.read()) > -1) {
                    o.write(b);
                }
            }
            byte[] content = o.toByteArray();
            iContent = new ByteArrayInputStream(content);
            iSize = content.length;
        }
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.out.write(b);
            }
        }
        this.flush();
    }

    public void sendStream(int iCode, String iReason, String iContentType, String iFileName, OCallable<Void, OChunkedResponse> iWriter) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        this.writeLine("Transfer-Encoding: chunked");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        this.writeLine(null);
        OChunkedResponse chunkedOutput = new OChunkedResponse(this);
        iWriter.call((Object)chunkedOutput);
        chunkedOutput.close();
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compress(String jsonStr) {
        if (jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        DeflaterOutputStream gout = null;
        ByteArrayOutputStream baos = null;
        try {
            byte[] incoming = jsonStr.getBytes("UTF-8");
            baos = new ByteArrayOutputStream();
            gout = new GZIPOutputStream((OutputStream)baos, 16384);
            gout.write(incoming);
            ((GZIPOutputStream)gout).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "Error on compressing HTTP response", (Throwable)ex, new Object[0]);
        }
        finally {
            try {
                if (gout != null) {
                    gout.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void setHeader(String iHeader) {
        this.headers = iHeader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
        if (!this.keepAlive) {
            this.out.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setJsonErrorResponse(boolean jsonErrorResponse) {
        this.jsonErrorResponse = jsonErrorResponse;
    }

    private String keyFromMapObject(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return "" + key;
    }
}

