/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.orient.client.binary.OChannelBinarySynchClient;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectResponse;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ORemoteServerChannel {
    private final ODistributedServerManager manager;
    private final String url;
    private final String remoteHost;
    private final int remotePort;
    private final String userName;
    private final String userPassword;
    private final String server;
    private OChannelBinarySynchClient channel;
    private int protocolVersion;
    private static final int MAX_RETRY = 3;
    private static final String CLIENT_TYPE = "OrientDB Server";
    private static final boolean COLLECT_STATS = false;
    private int sessionId = -1;
    private byte[] sessionToken;
    private OContextConfiguration contextConfig = new OContextConfiguration();
    private Date createdOn = new Date();
    private volatile int totalConsecutiveErrors = 0;
    private static final int MAX_CONSECUTIVE_ERRORS = 10;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORemoteServerChannel(ODistributedServerManager manager, String iServer, String iURL, String user, String passwd, int currentProtocolVersion) throws IOException {
        this.manager = manager;
        this.server = iServer;
        this.url = iURL;
        this.userName = user;
        this.userPassword = passwd;
        int sepPos = iURL.lastIndexOf(":");
        this.remoteHost = iURL.substring(0, sepPos);
        this.remotePort = Integer.parseInt(iURL.substring(sepPos + 1));
        this.protocolVersion = currentProtocolVersion;
        this.connect();
    }

    public int getDistributedProtocolVersion() {
        return this.protocolVersion;
    }

    public void sendRequest(final ODistributedRequest request) {
        this.networkOperation((byte)120, new OStorageRemoteOperation<Object>(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object execute() throws IOException {
                request.toStream(ORemoteServerChannel.this.channel.getDataOutput());
                ORemoteServerChannel.this.channel.flush();
                return null;
            }
        }, "Cannot send distributed request", 3, true);
    }

    public void sendResponse(final ODistributedResponse response) {
        this.networkOperation((byte)121, new OStorageRemoteOperation<Object>(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object execute() throws IOException {
                response.toStream(ORemoteServerChannel.this.channel.getDataOutput());
                ORemoteServerChannel.this.channel.flush();
                return null;
            }
        }, "Cannot send response back to the sender node '" + response.getSenderNodeName() + "'", 3, true);
    }

    public void connect() throws IOException {
        this.channel = new OChannelBinarySynchClient(this.remoteHost, this.remotePort, null, this.contextConfig, 37);
        this.networkOperation((byte)122, new OStorageRemoteOperation<Void>(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Void execute() throws IOException {
                ODistributedConnectRequest request = new ODistributedConnectRequest(ORemoteServerChannel.this.protocolVersion, ORemoteServerChannel.this.userName, ORemoteServerChannel.this.userPassword);
                request.write((OChannelDataOutput)ORemoteServerChannel.this.channel, null);
                ORemoteServerChannel.this.channel.flush();
                ORemoteServerChannel.this.channel.beginResponse(true);
                ODistributedConnectResponse response = request.createResponse();
                response.read((OChannelDataInput)ORemoteServerChannel.this.channel, null);
                ORemoteServerChannel.this.sessionId = response.getSessionId();
                ORemoteServerChannel.access$502(ORemoteServerChannel.this, response.getToken());
                ORemoteServerChannel.this.protocolVersion = response.getDistributedProtocolVersion();
                return null;
            }
        }, "Cannot connect to the remote server '" + this.url + "'", 3, false);
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.sessionId = -1;
        this.sessionToken = null;
    }

    protected synchronized <T> T networkOperation(byte operationId, OStorageRemoteOperation<T> operation, String errorMessage, int maxRetry, boolean autoReconnect) {
        Exception lastException = null;
        for (int retry = 1; retry <= maxRetry && this.totalConsecutiveErrors < 10; ++retry) {
            try {
                this.channel.setWaitResponseTimeout();
                this.channel.beginRequest(operationId, this.sessionId, this.sessionToken);
                T result = operation.execute();
                this.totalConsecutiveErrors = 0;
                return result;
            }
            catch (Exception e) {
                lastException = e;
                this.handleNewError();
                this.close();
                if (!autoReconnect || !this.manager.isNodeAvailable(this.server)) break;
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on sending message to distributed node (%s) retrying (%d/%d)", lastException.toString(), retry, maxRetry);
                if (retry > 1) {
                    try {
                        Thread.sleep(100 * (retry * 2));
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
                try {
                    this.connect();
                    this.totalConsecutiveErrors = 0;
                }
                catch (IOException e1) {
                    lastException = e1;
                    this.handleNewError();
                    ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Error on reconnecting to distributed node (%s)", lastException.toString());
                }
                continue;
            }
        }
        if (lastException == null) {
            this.handleNewError();
        }
        throw OException.wrapException((OException)new ODistributedException(errorMessage), lastException);
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public String getServer() {
        return this.server;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    private void handleNewError() {
        ++this.totalConsecutiveErrors;
        if (this.totalConsecutiveErrors >= 10) {
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), this.server, ODistributedServerLog.DIRECTION.OUT, "Reached %d consecutive errors on connection, remove the server '%s' from the cluster", this.totalConsecutiveErrors, this.server);
            new OThreadPoolExecutorWithLogging(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()).execute(new Runnable(){
                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                @Override
                public void run() {
                    try {
                        ORemoteServerChannel.this.manager.removeServer(ORemoteServerChannel.this.server, true);
                    }
                    catch (Exception e) {
                        ODistributedServerLog.warn((Object)this, ORemoteServerChannel.this.manager.getLocalNodeName(), ORemoteServerChannel.this.server, ODistributedServerLog.DIRECTION.OUT, "Error on removing server '%s' from the cluster", ORemoteServerChannel.this.server);
                    }
                }
            });
            throw new OIOException("Reached " + this.totalConsecutiveErrors + " consecutive errors on connection, remove the server '" + this.server + "' from the cluster");
        }
    }

    static /* synthetic */ byte[] access$502(ORemoteServerChannel x0, byte[] x1) {
        x0.sessionToken = x1;
        return x1;
    }

    public static interface OStorageRemoteOperation<T> {
        public static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public T execute() throws IOException;
    }
}

