/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteServerChannel;
import java.io.IOException;

public class ORemoteServerController {
    private final ORemoteServerChannel[] requestChannels;
    private volatile int requestChannelIndex = 0;
    private final ORemoteServerChannel[] responseChannels;
    private volatile int responseChannelIndex = 0;
    private int protocolVersion = -1;
    public static final int CURRENT_PROTOCOL_VERSION = 1;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORemoteServerController(ODistributedServerManager manager, String iServer, String iURL, String user, String passwd) throws IOException {
        int i;
        if (user == null) {
            throw new IllegalArgumentException("User is null");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("Password is null");
        }
        ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), iServer, ODistributedServerLog.DIRECTION.OUT, "Creating remote channel(s) to distributed server...", new Object[0]);
        this.requestChannels = new ORemoteServerChannel[OGlobalConfiguration.DISTRIBUTED_REQUEST_CHANNELS.getValueAsInteger()];
        for (i = 0; i < this.requestChannels.length; ++i) {
            this.requestChannels[i] = new ORemoteServerChannel(manager, iServer, iURL, user, passwd, 1);
        }
        this.protocolVersion = this.requestChannels[0].getDistributedProtocolVersion();
        this.responseChannels = new ORemoteServerChannel[OGlobalConfiguration.DISTRIBUTED_RESPONSE_CHANNELS.getValueAsInteger()];
        for (i = 0; i < this.responseChannels.length; ++i) {
            this.responseChannels[i] = new ORemoteServerChannel(manager, iServer, iURL, user, passwd, 1);
        }
    }

    public void sendRequest(ODistributedRequest req) {
        int idx;
        if ((idx = this.requestChannelIndex++) < 0) {
            idx = 0;
        }
        this.requestChannels[idx % this.responseChannels.length].sendRequest(req);
    }

    public void sendResponse(ODistributedResponse response) {
        int idx;
        if ((idx = this.responseChannelIndex++) < 0) {
            idx = 0;
        }
        this.responseChannels[idx % this.responseChannels.length].sendResponse(response);
    }

    public void close() {
        int i;
        for (i = 0; i < this.requestChannels.length; ++i) {
            this.requestChannels[i].close();
        }
        for (i = 0; i < this.responseChannels.length; ++i) {
            this.responseChannels[i].close();
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }
}

