/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class OServerSSLSocketFactory
extends OServerSocketFactory {
    public static final String PARAM_NETWORK_SSL_CLIENT_AUTH = "network.ssl.clientAuth";
    public static final String PARAM_NETWORK_SSL_KEYSTORE = "network.ssl.keyStore";
    public static final String PARAM_NETWORK_SSL_KEYSTORE_TYPE = "network.ssl.keyStoreType";
    public static final String PARAM_NETWORK_SSL_KEYSTORE_PASSWORD = "network.ssl.keyStorePassword";
    public static final String PARAM_NETWORK_SSL_TRUSTSTORE = "network.ssl.trustStore";
    public static final String PARAM_NETWORK_SSL_TRUSTSTORE_TYPE = "network.ssl.trustStoreType";
    public static final String PARAM_NETWORK_SSL_TRUSTSTORE_PASSWORD = "network.ssl.trustStorePassword";
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private String keyStorePath = null;
    private File keyStoreFile = null;
    private String keyStorePassword = null;
    private String keyStoreType = KeyStore.getDefaultType();
    private String trustStorePath = null;
    private File trustStoreFile = null;
    private String trustStorePassword = null;
    private String trustStoreType = KeyStore.getDefaultType();
    private boolean clientAuth = false;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public void config(String name, OServerParameterConfiguration[] iParameters) {
        super.config(name, iParameters);
        for (OServerParameterConfiguration param : iParameters) {
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_CLIENT_AUTH)) {
                this.clientAuth = Boolean.parseBoolean(param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_KEYSTORE)) {
                this.keyStorePath = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_KEYSTORE_PASSWORD)) {
                this.keyStorePassword = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_KEYSTORE_TYPE)) {
                this.keyStoreType = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_TRUSTSTORE)) {
                this.trustStorePath = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_TRUSTSTORE_PASSWORD)) {
                this.trustStorePassword = param.value;
                continue;
            }
            if (!param.name.equalsIgnoreCase(PARAM_NETWORK_SSL_TRUSTSTORE_TYPE)) continue;
            this.trustStoreType = param.value;
        }
        if (this.keyStorePath == null) {
            throw new OConfigurationException("Missing parameter network.ssl.keyStore");
        }
        if (this.keyStorePassword == null) {
            throw new OConfigurationException("Missing parameter network.ssl.keyStorePassword");
        }
        this.keyStoreFile = new File(this.keyStorePath);
        if (!this.keyStoreFile.isAbsolute()) {
            this.keyStoreFile = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}"), this.keyStorePath);
        }
        if (this.trustStorePath != null) {
            this.trustStoreFile = new File(this.trustStorePath);
            if (!this.trustStoreFile.isAbsolute()) {
                this.trustStoreFile = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}"), this.trustStorePath);
            }
        }
    }

    private ServerSocket configureSocket(SSLServerSocket serverSocket) {
        serverSocket.setNeedClientAuth(this.clientAuth);
        return serverSocket;
    }

    private SSLServerSocketFactory getBackingFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = this.getSSLContext().getServerSocketFactory();
        }
        return this.sslServerSocketFactory;
    }

    protected SSLContext getSSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
            char[] keyStorePass = this.keyStorePassword.toCharArray();
            keyStore.load(new FileInputStream(this.keyStoreFile), keyStorePass);
            kmf.init(keyStore, keyStorePass);
            TrustManagerFactory tmf = null;
            if (this.trustStoreFile != null) {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                char[] trustStorePass = this.trustStorePassword.toCharArray();
                trustStore.load(new FileInputStream(this.trustStoreFile), trustStorePass);
                tmf.init(trustStore);
            }
            context.init(kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), null);
            return context;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("Failed to create SSL context"), (Throwable)e);
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.configureSocket((SSLServerSocket)this.getBackingFactory().createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.configureSocket((SSLServerSocket)this.getBackingFactory().createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.configureSocket((SSLServerSocket)this.getBackingFactory().createServerSocket(port, backlog, ifAddress));
    }
}

