/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.message.OAddClusterRequest;
import com.orientechnologies.orient.client.remote.message.OBatchOperationsRequest;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCloseQueryRequest;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.client.remote.message.OCommandRequest;
import com.orientechnologies.orient.client.remote.message.OCommit37Request;
import com.orientechnologies.orient.client.remote.message.OCommitRequest;
import com.orientechnologies.orient.client.remote.message.OConnect37Request;
import com.orientechnologies.orient.client.remote.message.OConnectRequest;
import com.orientechnologies.orient.client.remote.message.OCountRecordsRequest;
import com.orientechnologies.orient.client.remote.message.OCountRequest;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OCreateRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusRequest;
import com.orientechnologies.orient.client.remote.message.ODropClusterRequest;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeRequest;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataRequest;
import com.orientechnologies.orient.client.remote.message.OGetSizeRequest;
import com.orientechnologies.orient.client.remote.message.OHideRecordRequest;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OImportRequest;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupRequest;
import com.orientechnologies.orient.client.remote.message.OListDatabasesRequest;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OOpen37Request;
import com.orientechnologies.orient.client.remote.message.OOpenRequest;
import com.orientechnologies.orient.client.remote.message.OQueryNextPageRequest;
import com.orientechnologies.orient.client.remote.message.OQueryRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordRequest;
import com.orientechnologies.orient.client.remote.message.ORebeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OReloadRequest;
import com.orientechnologies.orient.client.remote.message.OReloadRequest37;
import com.orientechnologies.orient.client.remote.message.OReopenRequest;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetRequest;
import com.orientechnologies.orient.client.remote.message.OServerInfoRequest;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OShutdownRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeRequest;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordRequest;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.util.function.Function;

public class ONetworkBinaryProtocolFactory {
    private static Function<Integer, OBinaryRequest<? extends OBinaryResponse>> defaultProtocol;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static Function<Integer, OBinaryRequest<? extends OBinaryResponse>> defaultProtocol() {
        return defaultProtocol;
    }

    public static Function<Integer, OBinaryRequest<? extends OBinaryResponse>> matchProtocol(short protocolVersion) {
        switch (protocolVersion) {
            case 37: 
            case 38: {
                return ONetworkBinaryProtocolFactory::createRequest37;
            }
        }
        return ONetworkBinaryProtocolFactory::createRequest;
    }

    private static OBinaryRequest<? extends OBinaryResponse> createRequest(int requestType) {
        switch (requestType) {
            case 3: {
                return new OOpenRequest();
            }
            case 2: {
                return new OConnectRequest();
            }
            case 17: {
                return new OReopenRequest();
            }
            case 1: {
                return new OShutdownRequest();
            }
            case 74: {
                return new OListDatabasesRequest();
            }
            case 75: {
                return new OServerInfoRequest();
            }
            case 73: {
                return new OReloadRequest();
            }
            case 4: {
                return new OCreateDatabaseRequest();
            }
            case 5: {
                return new OCloseRequest();
            }
            case 6: {
                return new OExistsDatabaseRequest();
            }
            case 7: {
                return new ODropDatabaseRequest();
            }
            case 8: {
                return new OGetSizeRequest();
            }
            case 9: {
                return new OCountRecordsRequest();
            }
            case 92: {
                return new ODistributedStatusRequest();
            }
            case 12: {
                return new OCountRequest();
            }
            case 13: {
                return new OGetClusterDataRangeRequest();
            }
            case 10: {
                return new OAddClusterRequest();
            }
            case 11: {
                return new ODropClusterRequest();
            }
            case 29: {
                return new OGetRecordMetadataRequest();
            }
            case 30: {
                return new OReadRecordRequest();
            }
            case 44: {
                return new OReadRecordIfVersionIsNotLatestRequest();
            }
            case 31: {
                return new OCreateRecordRequest();
            }
            case 32: {
                return new OUpdateRecordRequest();
            }
            case 33: {
                return new ODeleteRecordRequest();
            }
            case 43: {
                return new OHideRecordRequest();
            }
            case 36: {
                return new OHigherPhysicalPositionsRequest();
            }
            case 42: {
                return new OCeilingPhysicalPositionsRequest();
            }
            case 37: {
                return new OLowerPhysicalPositionsRequest();
            }
            case 39: {
                return new OFloorPhysicalPositionsRequest();
            }
            case 41: {
                return new OCommandRequest();
            }
            case 45: {
                return new OQueryRequest();
            }
            case 46: {
                return new OCloseQueryRequest();
            }
            case 47: {
                return new OQueryNextPageRequest();
            }
            case 60: {
                return new OCommitRequest();
            }
            case 70: {
                return new OGetGlobalConfigurationRequest();
            }
            case 71: {
                return new OSetGlobalConfigurationRequest();
            }
            case 72: {
                return new OListGlobalConfigurationsRequest();
            }
            case 94: {
                return new OFreezeDatabaseRequest();
            }
            case 95: {
                return new OReleaseDatabaseRequest();
            }
            case 38: {
                return new OCleanOutRecordRequest();
            }
            case 110: {
                return new OSBTCreateTreeRequest();
            }
            case 111: {
                return new OSBTGetRequest();
            }
            case 112: {
                return new OSBTFirstKeyRequest();
            }
            case 113: {
                return new OSBTFetchEntriesMajorRequest();
            }
            case 114: {
                return new OSBTGetRealBagSizeRequest();
            }
            case 27: {
                return new OIncrementalBackupRequest();
            }
            case 98: {
                return new OImportRequest();
            }
            case 122: {
                return new ODistributedConnectRequest();
            }
        }
        throw new ODatabaseException("binary protocol command with code: " + requestType);
    }

    public static OBinaryRequest<? extends OBinaryResponse> createRequest37(int requestType) {
        switch (requestType) {
            case 100: {
                return new OSubscribeRequest();
            }
            case 101: {
                return new OUnsubscribeRequest();
            }
            case 63: {
                return new OFetchTransactionRequest();
            }
            case 62: {
                return new ORebeginTransactionRequest();
            }
            case 61: {
                return new OBeginTransactionRequest();
            }
            case 60: {
                return new OCommit37Request();
            }
            case 64: {
                return new ORollbackTransactionRequest();
            }
            case 35: {
                return new OBatchOperationsRequest();
            }
            case 3: {
                return new OOpen37Request();
            }
            case 2: {
                return new OConnect37Request();
            }
            case 17: {
                return new OReopenRequest();
            }
            case 1: {
                return new OShutdownRequest();
            }
            case 74: {
                return new OListDatabasesRequest();
            }
            case 75: {
                return new OServerInfoRequest();
            }
            case 73: {
                return new OReloadRequest37();
            }
            case 4: {
                return new OCreateDatabaseRequest();
            }
            case 5: {
                return new OCloseRequest();
            }
            case 6: {
                return new OExistsDatabaseRequest();
            }
            case 7: {
                return new ODropDatabaseRequest();
            }
            case 8: {
                return new OGetSizeRequest();
            }
            case 9: {
                return new OCountRecordsRequest();
            }
            case 92: {
                return new ODistributedStatusRequest();
            }
            case 12: {
                return new OCountRequest();
            }
            case 13: {
                return new OGetClusterDataRangeRequest();
            }
            case 10: {
                return new OAddClusterRequest();
            }
            case 11: {
                return new ODropClusterRequest();
            }
            case 29: {
                return new OGetRecordMetadataRequest();
            }
            case 30: {
                return new OReadRecordRequest();
            }
            case 44: {
                return new OReadRecordIfVersionIsNotLatestRequest();
            }
            case 31: {
                return new OCreateRecordRequest();
            }
            case 32: {
                return new OUpdateRecordRequest();
            }
            case 33: {
                return new ODeleteRecordRequest();
            }
            case 43: {
                return new OHideRecordRequest();
            }
            case 36: {
                return new OHigherPhysicalPositionsRequest();
            }
            case 42: {
                return new OCeilingPhysicalPositionsRequest();
            }
            case 37: {
                return new OLowerPhysicalPositionsRequest();
            }
            case 39: {
                return new OFloorPhysicalPositionsRequest();
            }
            case 41: {
                return new OCommandRequest();
            }
            case 45: {
                return new OQueryRequest();
            }
            case 46: {
                return new OCloseQueryRequest();
            }
            case 47: {
                return new OQueryNextPageRequest();
            }
            case 70: {
                return new OGetGlobalConfigurationRequest();
            }
            case 71: {
                return new OSetGlobalConfigurationRequest();
            }
            case 72: {
                return new OListGlobalConfigurationsRequest();
            }
            case 94: {
                return new OFreezeDatabaseRequest();
            }
            case 95: {
                return new OReleaseDatabaseRequest();
            }
            case 38: {
                return new OCleanOutRecordRequest();
            }
            case 110: {
                return new OSBTCreateTreeRequest();
            }
            case 111: {
                return new OSBTGetRequest();
            }
            case 112: {
                return new OSBTFirstKeyRequest();
            }
            case 113: {
                return new OSBTFetchEntriesMajorRequest();
            }
            case 114: {
                return new OSBTGetRealBagSizeRequest();
            }
            case 27: {
                return new OIncrementalBackupRequest();
            }
            case 98: {
                return new OImportRequest();
            }
            case 122: {
                return new ODistributedConnectRequest();
            }
        }
        throw new ODatabaseException("binary protocol command with code: " + requestType + " for protocol version 37");
    }

    static {
        try {
            try {
                defaultProtocol = ONetworkBinaryProtocolFactory::createRequest;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

