/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import java.io.IOException;
import java.io.OutputStream;

public class OChunkedResponse
extends OutputStream {
    private OHttpResponse response;
    private byte[] buffer = new byte[8192];
    private int bufferSize = 0;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OChunkedResponse(OHttpResponse iHttpResponse) {
        this.response = iHttpResponse;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.bufferSize++] = (byte)b;
        if (this.bufferSize >= this.buffer.length) {
            this.writeContent();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeContent();
        this.response.flush();
    }

    @Override
    public void close() throws IOException {
        this.writeContent();
        this.response.writeLine("0");
        this.response.writeLine(null);
    }

    protected void writeContent() throws IOException {
        if (this.bufferSize > 0) {
            this.response.writeLine(Integer.toHexString(this.bufferSize));
            this.response.getOutputStream().write(this.buffer, 0, this.bufferSize);
            this.response.writeLine(null);
            this.bufferSize = 0;
        }
    }
}

