/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSession;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TimerTask;

public class OHttpSessionManager
extends OSharedResourceAbstract {
    private static final OHttpSessionManager instance;
    private Map<String, OHttpSession> sessions = new HashMap<String, OHttpSession>();
    private int expirationTime;
    private Random random = new SecureRandom();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    protected OHttpSessionManager() {
        this.expirationTime = OGlobalConfiguration.NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT.getValueAsInteger() * 1000;
        Orient.instance().scheduleTask(new TimerTask(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public void run() {
                int expired = OHttpSessionManager.this.checkSessionsValidity();
                if (expired > 0) {
                    OLogManager.instance().debug((Object)this, "Removed %d session because expired", new Object[]{expired});
                }
            }
        }, (long)this.expirationTime, (long)this.expirationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkSessionsValidity() {
        int expired = 0;
        this.acquireExclusiveLock();
        try {
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<String, OHttpSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, OHttpSession> s = it.next();
                if (now - s.getValue().getUpdatedOn() <= (long)this.expirationTime) continue;
                it.remove();
                ++expired;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return expired;
    }

    public OHttpSession[] getSessions() {
        this.acquireSharedLock();
        try {
            OHttpSession[] oHttpSessionArray = this.sessions.values().toArray(new OHttpSession[this.sessions.size()]);
            return oHttpSessionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OHttpSession getSession(String iId) {
        this.acquireSharedLock();
        try {
            OHttpSession sess = this.sessions.get(iId);
            if (sess != null) {
                sess.updateLastUpdatedOn();
            }
            OHttpSession oHttpSession = sess;
            return oHttpSession;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSession(String iDatabaseName, String iUserName, String iUserPassword) {
        this.acquireExclusiveLock();
        try {
            String id = "OS" + System.currentTimeMillis() + this.random.nextLong();
            this.sessions.put(id, new OHttpSession(id, iDatabaseName, iUserName, iUserPassword));
            String string = id;
            return string;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OHttpSession removeSession(String iSessionId) {
        this.acquireExclusiveLock();
        try {
            OHttpSession oHttpSession = this.sessions.remove(iSessionId);
            return oHttpSession;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public int getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime;
    }

    public static OHttpSessionManager getInstance() {
        return instance;
    }

    static {
        try {
            try {
                instance = new OHttpSessionManager();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

