/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSessionManager;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandPatternAbstract;
import java.util.Arrays;

public class OServerCommandAuthProxy
extends OServerCommandPatternAbstract {
    public static final String DATABASE_CONF = "database";
    public static final String USERNAME_CONF = "username";
    public static final String USERPASSWORD_CONF = "userpassword";
    private final String authentication;
    private String databaseName;
    private String userName;
    private String userPassword;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OServerCommandAuthProxy(OServerCommandConfiguration iConfig) {
        super(iConfig);
        if (iConfig.parameters.length != 3) {
            throw new OConfigurationException("AuthProxy Command requires database access data.");
        }
        this.userName = "";
        this.userPassword = "";
        for (OServerEntryConfiguration conf : iConfig.parameters) {
            if (conf.name.equals(USERNAME_CONF)) {
                this.userName = conf.value;
                continue;
            }
            if (conf.name.equals(USERPASSWORD_CONF)) {
                this.userPassword = conf.value;
                continue;
            }
            if (!conf.name.equals(DATABASE_CONF)) continue;
            this.databaseName = conf.value;
        }
        this.authentication = this.userName + ":" + this.userPassword;
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        iRequest.authorization = this.authentication;
        this.checkSyntax(iRequest.url, 3, "Syntax error: " + Arrays.toString(this.getNames()) + "/<nextCommand>/");
        iRequest.url = OHttpUtils.nextChainUrl(iRequest.url);
        if (iRequest.sessionId == null || "!".equals(iRequest.sessionId) || iRequest.sessionId.length() > 1 && OHttpSessionManager.getInstance().getSession(iRequest.sessionId) == null) {
            iRequest.sessionId = OHttpSessionManager.getInstance().createSession(this.databaseName, this.userName, this.userPassword);
        }
        return true;
    }
}

