/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandDeleteDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        try (ODatabaseDocumentInternal db = null;){
            String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: document/<database>/<record-id>");
            iRequest.data.commandInfo = "Delete document";
            db = this.getProfiledDatabaseInstance(iRequest);
            int parametersPos = urlParts[2].indexOf(63);
            String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
            ORecordId recordId = new ORecordId(rid);
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + urlParts[2]);
            }
            ODocument doc = new ODocument((ORID)recordId);
            if (iRequest.content != null) {
                doc.fromJSON(iRequest.content);
            } else if (iRequest.ifMatch != null) {
                ORecordInternal.setVersion((ORecord)doc, (int)Integer.parseInt(iRequest.ifMatch));
            } else {
                ORecordInternal.setVersion((ORecord)doc, (int)-1);
            }
            OClass cls = doc.getSchemaClass();
            if (cls != null) {
                if (cls.isSubClassOf("V")) {
                    db.command("DELETE VERTEX ?", new Object[]{recordId});
                } else if (cls.isSubClassOf("E")) {
                    db.command("DELETE EDGE ?", new Object[]{recordId});
                } else {
                    doc.reload(null, true);
                    doc.delete();
                }
            } else {
                doc.reload(null, true);
                doc.delete();
            }
            iResponse.send(204, "OK", "text/plain", null, null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        try {
            try {
                NAMES = new String[]{"DELETE|document/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

