/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class OServerCommandGetExportDatabase
extends OServerCommandAuthenticatedDbAbstract
implements OCommandOutputListener {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: export/<database>/[<name>][?params*]");
        if (urlParts.length <= 2) {
            this.exportStandard(iRequest, iResponse);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportStandard(OHttpRequest iRequest, OHttpResponse iResponse) throws InterruptedException, IOException {
        iRequest.data.commandInfo = "Database export";
        try (ODatabaseDocumentInternal database = this.getProfiledDatabaseInstance(iRequest);){
            iResponse.writeStatus(200, "OK");
            iResponse.writeHeaders("application/x-gzip");
            iResponse.writeLine("Content-Disposition: attachment; filename=" + database.getName() + ".gz");
            iResponse.writeLine("Date: " + new Date());
            iResponse.writeLine(null);
            ODatabaseExport export = new ODatabaseExport(database, (OutputStream)new GZIPOutputStream(iResponse.getOutputStream(), 16384), (OCommandOutputListener)this);
            export.exportDatabase();
            try {
                iResponse.flush();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void onMessage(String iText) {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        try {
            try {
                NAMES = new String[]{"GET|export/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

