/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class OServerCommandGetGephi
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OServerCommandGetGephi() {
    }

    public OServerCommandGetGephi(OServerCommandConfiguration iConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: gephi/<database>/<language>/<query-text>[/<limit>][/<fetchPlan>].<br>Limit is optional and is set to 20 by default. Set to 0 to have no limits.");
        String language = urlParts[2];
        String text = urlParts[3];
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4]) : 20;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        iRequest.data.commandInfo = "Gephi";
        iRequest.data.commandDetail = text;
        try (ODatabaseDocumentInternal db = this.getProfiledDatabaseInstance(iRequest);){
            OResultSet resultSet;
            if (language.equals("sql")) {
                resultSet = this.executeStatement(language, text, new HashMap(), (ODatabaseDocument)db);
            } else if (language.equals("gremlin")) {
                resultSet = null;
            } else {
                throw new IllegalArgumentException("Language '" + language + "' is not supported. Use 'sql' or 'gremlin'");
            }
            this.sendRecordsContent(iRequest, iResponse, resultSet, fetchPlan, limit);
        }
        return false;
    }

    protected void sendRecordsContent(OHttpRequest iRequest, OHttpResponse iResponse, OResultSet resultSet, String iFetchPlan, int limit) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments");
        json.setPrettyPrint(true);
        this.generateGraphDbOutput(resultSet, limit, json);
        iResponse.send(200, "OK", "application/json", buffer.toString(), null);
    }

    protected void generateGraphDbOutput(OResultSet resultSet, int limit, OJSONWriter json) throws IOException {
        Object v;
        if (resultSet == null) {
            return;
        }
        HashSet vertexes = new HashSet();
        HashSet edges = new HashSet();
        for (int i = 0; resultSet.hasNext() && (limit < 0 || i < limit); ++i) {
            OResult next = resultSet.next();
            if (next.isVertex()) {
                vertexes.add(next.getVertex().get());
                continue;
            }
            if (!next.isEdge()) continue;
            edges.add(next.getEdge().get());
        }
        resultSet.close();
        for (OVertex vertex : vertexes) {
            json.resetAttributes();
            json.beginObject(0, false, null);
            json.beginObject(1, false, (Object)"an");
            json.beginObject(2, false, (Object)vertex.getIdentity());
            vertex.getEdges(ODirection.BOTH).forEach(edges::add);
            for (String field : vertex.getPropertyNames()) {
                if (field.startsWith("in_") || field.startsWith("out_") || (v = vertex.getProperty(field)) == null) continue;
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
        for (OEdge edge : edges) {
            json.resetAttributes();
            json.beginObject();
            json.beginObject(1, false, (Object)"ae");
            json.beginObject(2, false, (Object)edge.getIdentity());
            json.writeAttribute(3, false, "directed", (Object)false);
            json.writeAttribute(3, false, "source", (Object)edge.getTo().getIdentity());
            json.writeAttribute(3, false, "target", (Object)edge.getFrom().getIdentity());
            for (String field : edge.getPropertyNames()) {
                if ("in".equalsIgnoreCase(field) || "out".equalsIgnoreCase(field) || (v = edge.getProperty(field)) == null) continue;
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    protected OResultSet executeStatement(String language, String text, Object params, ODatabaseDocument db) {
        OResultSet result = params instanceof Map ? db.command(text, (Map)params) : (params instanceof Object[] ? db.command(text, (Object[])params) : db.command(text, new Object[]{params}));
        return result;
    }

    static {
        try {
            try {
                NAMES = new String[]{"GET|gephi/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

