/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostCommand;
import java.util.ArrayList;
import java.util.HashMap;

public class OServerCommandGetQuery
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: query/<database>/sql/<query-text>[/<limit>][/<fetchPlan>].<br>Limit is optional and is set to 20 by default. Set to 0 to have no limits.");
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4]) : 20;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String text = urlParts[3];
        String accept = iRequest.getHeader("accept");
        iRequest.data.commandInfo = "Query";
        iRequest.data.commandDetail = text;
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            OStatement stm = OServerCommandPostCommand.parseStatement("SQL", text, (ODatabaseDocument)db);
            OResultSet result = db.query(text, new Object[0]);
            limit = OServerCommandPostCommand.getLimitFromStatement(stm, limit);
            String localFetchPlan = OServerCommandPostCommand.getFetchPlanFromStatement(stm);
            if (localFetchPlan != null) {
                fetchPlan = localFetchPlan;
            }
            ArrayList<OResult> response = new ArrayList<OResult>();
            for (int i = 0; result.hasNext() && (limit < 0 || i < limit); ++i) {
                response.add(result.next());
            }
            HashMap<String, Object> additionalContent = new HashMap<String, Object>();
            result.getExecutionPlan().ifPresent(x -> additionalContent.put("executionPlan", x.toResult().toElement()));
            result.close();
            String format = null;
            if (fetchPlan != null) {
                format = "fetchPlan:" + fetchPlan;
            }
            iResponse.writeRecords(response, fetchPlan, null, accept, additionalContent);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        try {
            try {
                NAMES = new String[]{"GET|query/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

