/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashSet;

public class OServerCommandGetSupportedLanguages
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: supportedLanguages/<database>");
        iRequest.data.commandInfo = "Returns the supported languages";
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            ODocument result = new ODocument();
            HashSet<String> languages = new HashSet<String>();
            OScriptManager scriptManager = Orient.instance().getScriptManager();
            for (String language : scriptManager.getSupportedLanguages()) {
                if (scriptManager.getFormatters() == null || scriptManager.getFormatters().get(language) == null) continue;
                languages.add(language);
            }
            result.field("languages", languages);
            iResponse.writeRecord((ORecord)result);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        try {
            try {
                NAMES = new String[]{"GET|supportedLanguages/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

