/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OFetchPlan;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTraverseStatement;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandPostCommand
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: command/<database>/<language>/<command-text>[/limit][/<fetchPlan>]");
        String language = urlParts.length > 2 ? urlParts[2].trim() : "sql";
        String text = urlParts.length > 3 ? urlParts[3].trim() : iRequest.content;
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4].trim()) : -1;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String accept = iRequest.getHeader("accept");
        Object[] params = null;
        String mode = "resultset";
        if (iRequest.content != null && !iRequest.content.isEmpty()) {
            if (iRequest.content.startsWith("{")) {
                ODocument doc = new ODocument().fromJSON(iRequest.content);
                text = (String)doc.field("command");
                params = doc.field("parameters");
                if (doc.containsField("mode")) {
                    mode = (String)doc.field("mode");
                }
                if (params instanceof Collection) {
                    Object[] paramArray = new Object[((Collection)params).size()];
                    ((Collection)params).toArray(paramArray);
                    params = paramArray;
                }
            } else {
                text = iRequest.content;
            }
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        iRequest.data.commandInfo = "Command";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentInternal db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OStatement stm = OServerCommandPostCommand.parseStatement(language, text, (ODatabaseDocument)db);
            OResultSet result = this.executeStatement(language, text, params, (ODatabaseDocument)db);
            limit = OServerCommandPostCommand.getLimitFromStatement(stm, limit);
            String localFetchPlan = OServerCommandPostCommand.getFetchPlanFromStatement(stm);
            if (localFetchPlan != null) {
                fetchPlan = localFetchPlan;
            }
            ArrayList<OResult> response = new ArrayList<OResult>();
            for (int i = 0; result.hasNext() && (limit < 0 || i < limit); ++i) {
                response.add(result.next());
            }
            HashMap<String, Object> additionalContent = new HashMap<String, Object>();
            result.getExecutionPlan().ifPresent(x -> additionalContent.put("executionPlan", x.toResult().toElement()));
            result.close();
            String format = null;
            if (fetchPlan != null) {
                format = "fetchPlan:" + fetchPlan;
            }
            if (iRequest.getHeader("TE") != null) {
                iResponse.setStreaming(true);
            }
            iResponse.writeResult(response, format, accept, additionalContent, mode);
        }
        finally {
            if (db != null) {
                db.activateOnCurrentThread();
                db.close();
            }
        }
        return false;
    }

    public static String getFetchPlanFromStatement(OStatement statement) {
        if (statement instanceof OSelectStatement) {
            OFetchPlan fp = ((OSelectStatement)statement).getFetchPlan();
            if (fp != null) {
                return fp.toString().substring("FETCHPLAN ".length());
            }
        } else if (statement instanceof OMatchStatement) {
            return ((OMatchStatement)statement).getFetchPlan();
        }
        return null;
    }

    public static OStatement parseStatement(String language, String text, ODatabaseDocument db) {
        try {
            if (language != null && language.equalsIgnoreCase("sql")) {
                return OSQLEngine.parse((String)text, (ODatabaseDocumentInternal)((ODatabaseDocumentInternal)db));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getLimitFromStatement(OStatement statement, int previousLimit) {
        try {
            OLimit limit = null;
            if (statement instanceof OSelectStatement) {
                limit = ((OSelectStatement)statement).getLimit();
            } else if (statement instanceof OMatchStatement) {
                limit = ((OMatchStatement)statement).getLimit();
            } else if (statement instanceof OTraverseStatement) {
                limit = ((OTraverseStatement)statement).getLimit();
            }
            if (limit != null) {
                return limit.getValue((OCommandContext)new OBasicCommandContext());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previousLimit;
    }

    protected OResultSet executeStatement(String language, String text, Object params, ODatabaseDocument db) {
        OResultSet result = params instanceof Map ? db.command(text, (Map)params) : (params instanceof Object[] ? db.command(text, (Object[])params) : db.command(text, new Object[]{params}));
        return result;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static {
        try {
            try {
                NAMES = new String[]{"GET|command/*", "POST|command/*"};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)runtimeException, (Object[])new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", (Throwable)error, (Object[])new String[0]);
            throw error;
        }
    }
}

