/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class OHttpMultipartContentInputStream
extends InputStream {
    protected String boundary;
    protected OHttpMultipartBaseInputStream wrappedInputStream;
    protected int nextByte;
    protected boolean internalAvailable = true;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OHttpMultipartContentInputStream(OHttpMultipartBaseInputStream in, String iBoundary) throws IOException {
        this.wrappedInputStream = in;
        this.boundary = "\n--" + iBoundary;
    }

    public InputStream getWrappedInputStream() {
        return this.wrappedInputStream;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.internalAvailable) {
            return this.wrappedInputStream.available();
        }
        return -1;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.internalAvailable) {
            return -1;
        }
        int value = this.nextByte;
        this.nextByte = this.wrappedInputStream.read();
        if ((char)this.nextByte == '\r') {
            this.bufferData();
        }
        return value;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrappedInputStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.wrappedInputStream.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.nextByte = this.wrappedInputStream.read();
        this.internalAvailable = true;
        if ((char)this.nextByte == '\r') {
            this.bufferData();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }

    protected void bufferData() throws IOException {
        int b;
        boolean checkingEnd = true;
        int boundaryCursor = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        while (checkingEnd && (b = this.wrappedInputStream.read()) > -1) {
            buffer.add(b);
            if ((char)b == this.boundary.charAt(boundaryCursor)) {
                this.internalAvailable = false;
                if (++boundaryCursor != this.boundary.length()) continue;
                checkingEnd = false;
                this.wrappedInputStream.resetBuffer();
                continue;
            }
            this.internalAvailable = true;
            checkingEnd = false;
            if (buffer.size() <= 0) continue;
            this.wrappedInputStream.setSkipInput(buffer);
        }
    }
}

