/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin.mail;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.plugin.OServerPluginConfigurable;
import com.orientechnologies.orient.server.plugin.mail.OMailProfile;
import com.orientechnologies.orient.server.plugin.mail.OSMTPAuthenticator;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class OMailPlugin
extends OServerPluginAbstract
implements OScriptInjection,
OServerPluginConfigurable {
    private static final String CONFIG_PROFILE_PREFIX = "profile.";
    private static final String CONFIG_MAIL_PREFIX = "mail.";
    private ODocument configuration;
    private Map<String, OMailProfile> profiles = new HashMap<String, OMailProfile>();
    private String configFile = "${ORIENTDB_HOME}/config/mail.json";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OMailPlugin() {
        Orient.instance().getScriptManager().registerInjection((OScriptInjection)this);
    }

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.configuration = new ODocument();
        for (OServerParameterConfiguration param : iParams) {
            String parts;
            int pos;
            if (param.name.equalsIgnoreCase("enabled")) {
                this.configuration.field("enabled", (Object)Boolean.parseBoolean(param.value));
                continue;
            }
            if (!param.name.startsWith(CONFIG_PROFILE_PREFIX) || (pos = (parts = param.name.substring(CONFIG_PROFILE_PREFIX.length())).indexOf(46)) == -1) continue;
            String profileName = parts.substring(0, pos);
            String profileParam = parts.substring(pos + 1);
            OMailProfile profile = this.profiles.get(profileName);
            if (profile == null) {
                profile = new OMailProfile();
                this.profiles.put(profileName, profile);
            }
            if (!profileParam.startsWith(CONFIG_MAIL_PREFIX)) continue;
            profile.put(profileParam, param.value);
        }
        ArrayList profilesDocuments = new ArrayList();
        for (String p : this.profiles.keySet()) {
            OMailProfile oMailProfile = this.profiles.get(p);
            HashMap<String, String> properties = new HashMap<String, String>();
            Set<String> strings = oMailProfile.stringPropertyNames();
            for (String string : strings) {
                properties.put(string, oMailProfile.getProperty(string));
            }
            properties.put("name", p);
            profilesDocuments.add(properties);
        }
        this.configuration.field("profiles", profilesDocuments);
        this.configure();
        OLogManager.instance().info((Object)this, "Installing Mail plugin, loaded %d profile(s): %s", new Object[]{this.profiles.size(), this.profiles.keySet()});
    }

    private void configure() {
        File f = new File(OSystemVariableResolver.resolveSystemVariables((String)this.configFile));
        if (f.exists()) {
            try {
                String configurationContent = OIOUtils.readFileAsString((File)f);
                this.configuration = new ODocument().fromJSON(configurationContent);
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Cannot load Mail configuration file '" + this.configFile + "'. Mail Plugin will be disabled"), (Throwable)e);
            }
        }
        try {
            f.getParentFile().mkdirs();
            f.createNewFile();
            OIOUtils.writeFile((File)f, (String)this.configuration.toJSON("prettyPrint"));
            OLogManager.instance().info((Object)this, "Mail plugin: migrated configuration to file '%s'", new Object[]{f});
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OConfigurationException("Cannot create Mail plugin configuration file '" + this.configFile + "'. Mail Plugin will be disabled"), (Throwable)e);
        }
        this.profiles.clear();
        Collection profilesInDocs = (Collection)this.configuration.field("profiles");
        for (Map profile : profilesInDocs) {
            String name = (String)profile.get("name");
            OMailProfile p = this.profiles.get(name);
            if (p == null) {
                p = new OMailProfile();
                this.profiles.put(name, p);
            }
            for (String s : profile.keySet()) {
                if (s.equalsIgnoreCase("name")) continue;
                p.put(s, profile.get(s).toString());
            }
        }
    }

    public void writeConfiguration() throws IOException {
        File f = new File(OSystemVariableResolver.resolveSystemVariables((String)this.configFile));
        OIOUtils.writeFile((File)f, (String)this.configuration.toJSON("prettyPrint"));
    }

    public void send(Map<String, Object> iMessage) throws AddressException, MessagingException, ParseException {
        Date sendDate;
        String bcc;
        String cc;
        String to;
        if (iMessage == null) {
            throw new IllegalArgumentException("Configuration is null");
        }
        String profileName = (String)iMessage.get("profile");
        OMailProfile profile = this.profiles.get(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("Mail profile '" + profileName + "' is not configured on server");
        }
        OSMTPAuthenticator auth = new OSMTPAuthenticator(profile.getProperty("mail.smtp.user"), profile.getProperty("mail.smtp.password"));
        Session session = Session.getInstance((Properties)profile, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        String from = iMessage.containsKey("from") ? (String)iMessage.get("from") : profile.getProperty("mail.from");
        if (from != null) {
            msg.setFrom((Address)new InternetAddress(from));
        }
        if ((to = (String)iMessage.get("to")) != null && !to.isEmpty()) {
            msg.setRecipients(Message.RecipientType.TO, (Address[])this.getEmails(to));
        }
        if ((cc = (String)iMessage.get("cc")) != null && !cc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])this.getEmails(cc));
        }
        if ((bcc = (String)iMessage.get("bcc")) != null && !bcc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])this.getEmails(bcc));
        }
        msg.setSubject((String)iMessage.get("subject"));
        Object date = iMessage.get("date");
        if (date == null) {
            sendDate = new Date();
        } else if (date instanceof Date) {
            sendDate = (Date)date;
        } else {
            String dateFormat = profile.getProperty("mail.date.format");
            if (dateFormat == null) {
                dateFormat = "yyyy-MM-dd HH:mm:ss";
            }
            sendDate = new SimpleDateFormat(dateFormat).parse(date.toString());
        }
        msg.setSentDate(sendDate);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent(iMessage.get("message"), "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        String[] attachments = (String[])iMessage.get("attachments");
        if (attachments != null && attachments.length > 0) {
            for (String filePath : attachments) {
                this.addAttachment((Multipart)multipart, filePath);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    public void bind(ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        binding.put("mail", (Object)this);
    }

    public void unbind(ScriptEngine engine, Bindings binding) {
        binding.put("mail", (Object)null);
    }

    public String getName() {
        return "mail";
    }

    public Set<String> getProfileNames() {
        return this.profiles.keySet();
    }

    public OMailProfile getProfile(String iName) {
        return this.profiles.get(iName);
    }

    public OMailPlugin registerProfile(String iName, OMailProfile iProfile) {
        this.profiles.put(iName, iProfile);
        return this;
    }

    protected InternetAddress[] getEmails(String iText) throws AddressException {
        if (iText == null) {
            return null;
        }
        String[] items = iText.split(",");
        InternetAddress[] addresses = new InternetAddress[items.length];
        for (int i = 0; i < items.length; ++i) {
            addresses[i] = new InternetAddress(items[i]);
        }
        return addresses;
    }

    private void addAttachment(Multipart multipart, String filePath) throws MessagingException {
        MimeBodyPart attachPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(filePath);
        attachPart.setDataHandler(new DataHandler((DataSource)source));
        attachPart.setFileName(new File(filePath).getName());
        multipart.addBodyPart((BodyPart)attachPart);
    }

    @Override
    public ODocument getConfig() {
        return this.configuration;
    }

    @Override
    public void changeConfig(ODocument document) {
        ODocument oldConfig = this.configuration;
        this.configuration = document;
        try {
            this.writeConfiguration();
        }
        catch (IOException e) {
            this.configuration = oldConfig;
            throw OException.wrapException((OException)new OConfigurationException("Cannot Write Mail configuration file '" + this.configFile + "'. Restoring old configuration."), (Throwable)e);
        }
        this.configure();
    }
}

