/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.OServer;
import java.util.UUID;

public class OSystemDatabase {
    public static final String SYSTEM_DB_NAME = "OSystem";
    public static final String SERVER_INFO_CLASS = "ServerInfo";
    public static final String SERVER_ID_PROPERTY = "serverId";
    private final OServer server;
    private String serverId;

    public OSystemDatabase(OServer server) {
        this.server = server;
        this.init();
    }

    public String getSystemDatabaseName() {
        return SYSTEM_DB_NAME;
    }

    public String getSystemDatabasePath() {
        return this.server.getDatabaseDirectory() + this.getSystemDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster(String className, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try (ODatabaseDocumentInternal sysdb = this.openSystemDatabase();){
            if (!sysdb.existsCluster(clusterName)) {
                OSchema schema = sysdb.getMetadata().getSchema();
                OClass cls = schema.getClass(className);
                if (cls != null) {
                    cls.addCluster(clusterName);
                } else {
                    OLogManager.instance().error((Object)this, "createCluster() Class name %s does not exist", null, new Object[]{className});
                }
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODatabaseDocumentInternal openSystemDatabase() {
        return this.server.getDatabases().openNoAuthorization(this.getSystemDatabaseName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(OCallable<Object, Object> callback, String sql, Object ... args) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            Object result;
            ODatabaseDocumentInternal db;
            block10: {
                Object object;
                db = this.openSystemDatabase();
                try {
                    result = db.command((OCommandRequest)new OCommandSQL(sql)).execute(args);
                    if (callback == null) break block10;
                    object = callback.call(result);
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
                return object;
            }
            Object object = result;
            db.close();
            return object;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODocument save(ODocument document) {
        return this.save(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument save(ODocument document, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal db;
            block10: {
                ODocument oDocument;
                db = this.openSystemDatabase();
                try {
                    if (clusterName == null) break block10;
                    oDocument = (ODocument)db.save((Object)document, clusterName);
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
                return oDocument;
            }
            ODocument oDocument = (ODocument)db.save((Object)document);
            db.close();
            return oDocument;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        ODatabaseDocumentInternal oldDbInThread = tl != null ? tl.getIfDefined() : null;
        try {
            if (!this.exists()) {
                OLogManager.instance().info((Object)this, "Creating the system database '%s' for current server", new Object[]{SYSTEM_DB_NAME});
                OrientDBConfig config = OrientDBConfig.builder().addConfig(OGlobalConfiguration.CREATE_DEFAULT_USERS, (Object)false).addConfig(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)1).build();
                this.server.createDatabase(SYSTEM_DB_NAME, ODatabaseType.PLOCAL, config);
            }
            this.checkServerId();
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.instance().set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkServerId() {
        try (ODatabaseDocumentInternal db = this.openSystemDatabase();){
            OClass clazz = db.getClass(SERVER_INFO_CLASS);
            if (clazz == null) {
                clazz = db.createClass(SERVER_INFO_CLASS, new String[0]);
            }
            OElement info = clazz.count() == 0L ? db.newElement(SERVER_INFO_CLASS) : (OElement)db.browseClass(clazz.getName()).next();
            this.serverId = (String)info.getProperty(SERVER_ID_PROPERTY);
            if (this.serverId == null) {
                this.serverId = UUID.randomUUID().toString();
                info.setProperty(SERVER_ID_PROPERTY, (Object)this.serverId);
                info.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDBScope(OCallable<Void, ODatabase> callback) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try (ODatabaseDocumentInternal db = this.openSystemDatabase();){
            callback.call((Object)db);
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithDB(OCallable<T, ODatabase> callback) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            Object object;
            ODatabaseDocumentInternal db = this.openSystemDatabase();
            try {
                object = callback.call((Object)db);
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return (T)object;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public boolean exists() {
        return this.server.existsDatabase(this.getSystemDatabaseName());
    }

    public String getServerId() {
        return this.serverId;
    }
}

