/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.SimpleValueFetchPlanCommandListener;
import com.orientechnologies.orient.client.remote.message.OAddClusterRequest;
import com.orientechnologies.orient.client.remote.message.OAddClusterResponse;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordResponse;
import com.orientechnologies.orient.client.remote.message.OCloseQueryRequest;
import com.orientechnologies.orient.client.remote.message.OCloseQueryResponse;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.client.remote.message.OCommandResponse;
import com.orientechnologies.orient.client.remote.message.OCommit37Request;
import com.orientechnologies.orient.client.remote.message.OCommitRequest;
import com.orientechnologies.orient.client.remote.message.OCommitResponse;
import com.orientechnologies.orient.client.remote.message.OConnectRequest;
import com.orientechnologies.orient.client.remote.message.OConnectResponse;
import com.orientechnologies.orient.client.remote.message.OCountRecordsRequest;
import com.orientechnologies.orient.client.remote.message.OCountRecordsResponse;
import com.orientechnologies.orient.client.remote.message.OCountRequest;
import com.orientechnologies.orient.client.remote.message.OCountResponse;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OCreateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCreateRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusResponse;
import com.orientechnologies.orient.client.remote.message.ODropClusterRequest;
import com.orientechnologies.orient.client.remote.message.ODropClusterResponse;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeRequest;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeResponse;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataRequest;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataResponse;
import com.orientechnologies.orient.client.remote.message.OGetSizeRequest;
import com.orientechnologies.orient.client.remote.message.OGetSizeResponse;
import com.orientechnologies.orient.client.remote.message.OHideRecordRequest;
import com.orientechnologies.orient.client.remote.message.OHideRecordResponse;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OImportRequest;
import com.orientechnologies.orient.client.remote.message.OImportResponse;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupRequest;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupResponse;
import com.orientechnologies.orient.client.remote.message.OListDatabasesRequest;
import com.orientechnologies.orient.client.remote.message.OListDatabasesResponse;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsRequest;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsResponse;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OOpenRequest;
import com.orientechnologies.orient.client.remote.message.OOpenResponse;
import com.orientechnologies.orient.client.remote.message.OQueryNextPageRequest;
import com.orientechnologies.orient.client.remote.message.OQueryRequest;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordResponse;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OReloadRequest;
import com.orientechnologies.orient.client.remote.message.OReloadResponse;
import com.orientechnologies.orient.client.remote.message.OReopenRequest;
import com.orientechnologies.orient.client.remote.message.OReopenResponse;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionRequest;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeResponse;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorResponse;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetResponse;
import com.orientechnologies.orient.client.remote.message.OServerInfoRequest;
import com.orientechnologies.orient.client.remote.message.OServerInfoResponse;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OShutdownRequest;
import com.orientechnologies.orient.client.remote.message.OShutdownResponse;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordResponse;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerInfo;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OAsyncCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OCommandCacheRemoteResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OLiveCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.network.protocol.binary.OSyncCommandResultListener;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticServer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

final class OConnectionBinaryExecutor
implements OBinaryRequestExecutor {
    private final OClientConnection connection;
    private final OServer server;

    public OConnectionBinaryExecutor(OClientConnection connection, OServer server) {
        this.connection = connection;
        this.server = server;
    }

    public OListDatabasesResponse executeListDatabases(OListDatabasesRequest request) {
        Set<String> dbs = this.server.listDatabases();
        String listener = ((OServerNetworkListener)this.server.getListenerByProtocol(ONetworkProtocolBinary.class)).getInboundAddr().toString();
        HashMap<String, String> toSend = new HashMap<String, String>();
        for (String dbName : dbs) {
            toSend.put(dbName, "remote:" + listener + "/" + dbName);
        }
        return new OListDatabasesResponse(toSend);
    }

    public OBinaryResponse executeServerInfo(OServerInfoRequest request) {
        try {
            return new OServerInfoResponse(OServerInfo.getServerInfo(this.server));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OBinaryResponse executeDBReload(OReloadRequest request) {
        Collection clusters = this.connection.getDatabase().getStorage().getClusterInstances();
        return new OReloadResponse(clusters.toArray(new OCluster[clusters.size()]));
    }

    public OBinaryResponse executeCreateDatabase(OCreateDatabaseRequest request) {
        if (this.server.existsDatabase(request.getDatabaseName())) {
            throw new ODatabaseException("Database named '" + request.getDatabaseName() + "' already exists");
        }
        if (request.getBackupPath() != null && !"".equals(request.getBackupPath().trim())) {
            this.server.restore(request.getDatabaseName(), request.getBackupPath());
        } else {
            this.server.createDatabase(request.getDatabaseName(), ODatabaseType.valueOf((String)request.getStorageMode().toUpperCase()), null);
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{request.getDatabaseName(), request.getStorageMode()});
        this.connection.setDatabase(this.server.openDatabase(request.getDatabaseName(), this.connection.getData().serverUsername, null, this.connection.getData(), true));
        return new OCreateDatabaseResponse();
    }

    public OBinaryResponse executeClose(OCloseRequest request) {
        this.server.getClientConnectionManager().disconnect(this.connection);
        return null;
    }

    public OBinaryResponse executeExistDatabase(OExistsDatabaseRequest request) {
        boolean result = this.server.existsDatabase(request.getDatabaseName());
        return new OExistsDatabaseResponse(result);
    }

    public OBinaryResponse executeDropDatabase(ODropDatabaseRequest request) {
        this.server.dropDatabase(request.getDatabaseName());
        OLogManager.instance().info((Object)this, "Dropped database '%s'", new Object[]{request.getDatabaseName()});
        this.connection.close();
        return new ODropDatabaseResponse();
    }

    public OBinaryResponse executeGetSize(OGetSizeRequest request) {
        return new OGetSizeResponse(this.connection.getDatabase().getStorage().getSize());
    }

    public OBinaryResponse executeCountRecords(OCountRecordsRequest request) {
        return new OCountRecordsResponse(this.connection.getDatabase().getStorage().countRecords());
    }

    public OBinaryResponse executeDistributedStatus(ODistributedStatusRequest request) {
        ODocument req = request.getStatus();
        ODocument clusterConfig = null;
        String operation = (String)req.field("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Cluster operation is null");
        }
        if (operation.equals("status")) {
            Object plugin = this.server.getPlugin("cluster");
            if (plugin != null && plugin instanceof ODistributedServerManager) {
                clusterConfig = ((ODistributedServerManager)plugin).getClusterConfiguration();
            }
        } else {
            throw new IllegalArgumentException("Cluster operation '" + operation + "' is not supported");
        }
        return new ODistributedStatusResponse(clusterConfig);
    }

    public OBinaryResponse executeCountCluster(OCountRequest request) {
        long count = this.connection.getDatabase().countClusterElements(request.getClusterIds(), request.isCountTombstones());
        return new OCountResponse(count);
    }

    public OBinaryResponse executeClusterDataRange(OGetClusterDataRangeRequest request) {
        long[] pos = this.connection.getDatabase().getStorage().getClusterDataRange(request.getClusterId());
        return new OGetClusterDataRangeResponse(pos);
    }

    public OBinaryResponse executeAddCluster(OAddClusterRequest request) {
        int num = request.getRequestedId() < 0 ? this.connection.getDatabase().addCluster(request.getClusterName(), new Object[0]) : this.connection.getDatabase().addCluster(request.getClusterName(), request.getRequestedId(), null);
        return new OAddClusterResponse(num);
    }

    public OBinaryResponse executeDropCluster(ODropClusterRequest request) {
        String clusterName = this.connection.getDatabase().getClusterNameById(request.getClusterId());
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster " + request.getClusterId() + " does not exist anymore. Refresh the db structure or just reconnect to the database");
        }
        boolean result = this.connection.getDatabase().dropCluster(clusterName, false);
        return new ODropClusterResponse(result);
    }

    public OBinaryResponse executeGetRecordMetadata(OGetRecordMetadataRequest request) {
        ORecordMetadata metadata = this.connection.getDatabase().getRecordMetadata(request.getRid());
        if (metadata != null) {
            return new OGetRecordMetadataResponse(metadata);
        }
        throw new ODatabaseException(String.format("Record metadata for RID: %s, Not found", request.getRid()));
    }

    public OBinaryResponse executeReadRecord(OReadRecordRequest request) {
        OReadRecordResponse response;
        ORecordId rid = request.getRid();
        String fetchPlanString = request.getFetchPlan();
        boolean ignoreCache = false;
        ignoreCache = request.isIgnoreCache();
        boolean loadTombstones = false;
        loadTombstones = request.isLoadTumbstone();
        if (rid.getClusterId() == 0 && rid.getClusterPosition() == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            byte[] record = (byte[])this.connection.getDatabase().getStorage().callInLock((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return OConnectionBinaryExecutor.this.connection.getDatabase().getStorage().getConfiguration().toStream((int)((OConnectionBinaryExecutor)OConnectionBinaryExecutor.this).connection.getData().protocolVersion, Charset.forName("UTF-8"));
                }
            }, false);
            response = new OReadRecordResponse(98, 0, record, new HashSet());
        } else {
            ORecord record = (ORecord)this.connection.getDatabase().load((ORID)rid, fetchPlanString, ignoreCache, loadTombstones, OStorage.LOCKING_STRATEGY.NONE);
            if (record != null) {
                byte[] bytes = OConnectionBinaryExecutor.getRecordBytes(this.connection, record);
                final HashSet recordsToSend = new HashSet();
                if (record != null && fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                }
                response = new OReadRecordResponse(ORecordInternal.getRecordType((ORecord)record), record.getVersion(), bytes, recordsToSend);
            } else {
                response = new OReadRecordResponse(0, 0, null, null);
            }
        }
        return response;
    }

    public OBinaryResponse executeReadRecordIfNotLastest(OReadRecordIfVersionIsNotLatestRequest request) {
        OReadRecordIfVersionIsNotLatestResponse response;
        ORecordId rid = request.getRid();
        int recordVersion = request.getRecordVersion();
        String fetchPlanString = request.getFetchPlan();
        boolean ignoreCache = request.isIgnoreCache();
        if (rid.getClusterId() == 0 && rid.getClusterPosition() == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            byte[] record = (byte[])this.connection.getDatabase().getStorage().callInLock((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return OConnectionBinaryExecutor.this.connection.getDatabase().getStorage().getConfiguration().toStream((int)((OConnectionBinaryExecutor)OConnectionBinaryExecutor.this).connection.getData().protocolVersion, Charset.forName("UTF-8"));
                }
            }, false);
            response = new OReadRecordIfVersionIsNotLatestResponse(98, 0, record, new HashSet());
        } else {
            ORecord record = this.connection.getDatabase().loadIfVersionIsNotLatest((ORID)rid, recordVersion, fetchPlanString, ignoreCache);
            if (record != null) {
                byte[] bytes = OConnectionBinaryExecutor.getRecordBytes(this.connection, record);
                final HashSet recordsToSend = new HashSet();
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                }
                response = new OReadRecordIfVersionIsNotLatestResponse(ORecordInternal.getRecordType((ORecord)record), record.getVersion(), bytes, recordsToSend);
            } else {
                response = new OReadRecordIfVersionIsNotLatestResponse(0, 0, null, null);
            }
        }
        return response;
    }

    public OBinaryResponse executeCreateRecord(OCreateRecordRequest request) {
        ORecord record = request.getContent();
        ORecordInternal.setIdentity((ORecord)record, (ORecordId)request.getRid());
        ORecordInternal.setVersion((ORecord)record, (int)0);
        if (record instanceof ODocument) {
            ODocumentInternal.autoConvertValueToClass((ODatabaseDocumentInternal)this.connection.getDatabase(), (ODocument)((ODocument)record));
        }
        this.connection.getDatabase().save((Object)record);
        if (request.getMode() < 2) {
            HashMap changedIds;
            OSBTreeCollectionManager collectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
            if (collectionManager != null) {
                changedIds = new HashMap(collectionManager.changedIds());
                collectionManager.clearChangedIds();
            } else {
                changedIds = new HashMap();
            }
            return new OCreateRecordResponse((ORecordId)record.getIdentity(), record.getVersion(), changedIds);
        }
        return null;
    }

    public OBinaryResponse executeUpdateRecord(OUpdateRecordRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        ORecord newRecord = request.getContent();
        ORecordInternal.setIdentity((ORecord)newRecord, (ORecordId)request.getRid());
        ORecordInternal.setVersion((ORecord)newRecord, (int)request.getVersion());
        ORecordInternal.setContentChanged((ORecord)newRecord, (boolean)request.isUpdateContent());
        ORecordInternal.getDirtyManager((ORecord)newRecord).clearForSave();
        ORecord currentRecord = null;
        if (newRecord instanceof ODocument) {
            block9: {
                try {
                    currentRecord = (ORecord)database.load((ORID)request.getRid());
                }
                catch (ORecordNotFoundException e) {
                    if (!(e.getCause() instanceof OOfflineClusterException)) break block9;
                    throw (OOfflineClusterException)e.getCause();
                }
            }
            if (currentRecord == null) {
                throw new ORecordNotFoundException((ORID)request.getRid());
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
        } else {
            currentRecord = newRecord;
        }
        ORecordInternal.setVersion((ORecord)currentRecord, (int)request.getVersion());
        database.save((Object)currentRecord);
        if (currentRecord.getIdentity().toString().equals(database.getStorage().getConfiguration().indexMgrRecordId)) {
            database.getMetadata().getIndexManager().reload();
        }
        int newVersion = currentRecord.getVersion();
        if (request.getMode() < 2) {
            HashMap changedIds;
            OSBTreeCollectionManager collectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
            if (collectionManager != null) {
                changedIds = new HashMap(collectionManager.changedIds());
                collectionManager.clearChangedIds();
            } else {
                changedIds = new HashMap();
            }
            return new OUpdateRecordResponse(newVersion, changedIds);
        }
        return null;
    }

    public OBinaryResponse executeDeleteRecord(ODeleteRecordRequest request) {
        boolean result;
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        try {
            ORecord record = (ORecord)database.load((ORID)request.getRid());
            if (record != null) {
                database.delete((ORID)request.getRid(), request.getVersion());
                result = true;
            } else {
                result = false;
            }
        }
        catch (ORecordNotFoundException e) {
            if (e.getCause() instanceof OOfflineClusterException) {
                throw (OOfflineClusterException)e.getCause();
            }
            result = false;
        }
        if (request.getMode() < 2) {
            return new ODeleteRecordResponse(result);
        }
        return null;
    }

    public OBinaryResponse executeHideRecord(OHideRecordRequest request) {
        boolean result;
        try {
            this.connection.getDatabase().hide((ORID)request.getRecordId());
            result = true;
        }
        catch (ORecordNotFoundException e) {
            result = false;
        }
        if (request.getMode() < 2) {
            return new OHideRecordResponse(result);
        }
        return null;
    }

    public OBinaryResponse executeHigherPosition(OHigherPhysicalPositionsRequest request) {
        OPhysicalPosition[] nextPositions = this.connection.getDatabase().getStorage().higherPhysicalPositions(request.getClusterId(), request.getClusterPosition());
        return new OHigherPhysicalPositionsResponse(nextPositions);
    }

    public OBinaryResponse executeCeilingPosition(OCeilingPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().ceilingPhysicalPositions(request.getClusterId(), request.getPhysicalPosition());
        return new OCeilingPhysicalPositionsResponse(previousPositions);
    }

    public OBinaryResponse executeLowerPosition(OLowerPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().lowerPhysicalPositions(request.getiClusterId(), request.getPhysicalPosition());
        return new OLowerPhysicalPositionsResponse(previousPositions);
    }

    public OBinaryResponse executeFloorPosition(OFloorPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().floorPhysicalPositions(request.getClusterId(), request.getPhysicalPosition());
        return new OFloorPhysicalPositionsResponse(previousPositions);
    }

    public OBinaryResponse executeCommand(com.orientechnologies.orient.client.remote.message.OCommandRequest request) {
        OCommandResponse response;
        boolean live = request.isLive();
        boolean asynch = request.isAsynch();
        OCommandRequestText command = request.getQuery();
        Map params = command.getParameters();
        if (asynch && command instanceof OSQLSynchQuery) {
            OSQLAsynchQuery asynchQuery = new OSQLAsynchQuery(command.getText());
            asynchQuery.setFetchPlan(command.getFetchPlan());
            asynchQuery.setLimit(command.getLimit());
            asynchQuery.setTimeout(command.getTimeoutTime(), command.getTimeoutStrategy());
            asynchQuery.setUseCache(((OSQLSynchQuery)command).isUseCache());
            command = asynchQuery;
        }
        this.connection.getData().commandDetail = command.getText();
        this.connection.getData().command = command;
        OAbstractCommandResultListener listener = null;
        OLiveCommandResultListener liveListener = null;
        Object cmdResultListener = command.getResultListener();
        if (live) {
            liveListener = new OLiveCommandResultListener(this.server, this.connection, (OCommandResultListener)cmdResultListener);
            listener = new OSyncCommandResultListener(null);
            command.setResultListener((OCommandResultListener)liveListener);
        } else if (asynch) {
            OCommandCache cmdCache = this.connection.getDatabase().getMetadata().getCommandCache();
            if (cmdCache.isEnabled()) {
                cmdResultListener = new OCommandCacheRemoteResultListener((OCommandResultListener)cmdResultListener, cmdCache);
            }
            listener = new OAsyncCommandResultListener(this.connection, (OCommandResultListener)cmdResultListener);
            command.setResultListener((OCommandResultListener)listener);
        } else {
            listener = new OSyncCommandResultListener(null);
        }
        long serverTimeout = this.connection.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.COMMAND_TIMEOUT);
        if (serverTimeout > 0L && command.getTimeoutTime() > serverTimeout) {
            command.setTimeout(serverTimeout, command.getTimeoutStrategy());
        }
        command.setCacheableResult(true);
        OCommandRequestText commandRequest = (OCommandRequestText)this.connection.getDatabase().command((OCommandRequest)command);
        listener.setFetchPlan(commandRequest.getFetchPlan());
        if (asynch) {
            response = new OCommandResponse(null, (SimpleValueFetchPlanCommandListener)listener, false, asynch, this.connection.getDatabase(), command, params);
        } else {
            Object result = params == null ? commandRequest.execute(new Object[0]) : commandRequest.execute(new Object[]{params});
            listener.setFetchPlan(commandRequest.getFetchPlan());
            boolean isRecordResultSet = true;
            isRecordResultSet = command.isRecordResultSet();
            response = new OCommandResponse(result, (SimpleValueFetchPlanCommandListener)listener, isRecordResultSet, asynch, this.connection.getDatabase(), command, params);
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public OBinaryResponse executeCommit(OCommitRequest request) {
        OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy(this.connection.getDatabase(), request.getTxId(), request.isUsingLong(), request.getOperations(), request.getIndexChanges(), this.connection.getData().protocolVersion);
        try {
            try {
                this.connection.getDatabase().rawBegin((OTransaction)tx);
            }
            catch (ORecordNotFoundException e) {
                throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
            }
            try {
                void var6_16;
                try {
                    this.connection.getDatabase().commit();
                }
                catch (ORecordNotFoundException e) {
                    throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
                }
                ArrayList<OCommitResponse.OCreatedRecordResponse> createdRecords = new ArrayList<OCommitResponse.OCreatedRecordResponse>(tx.getCreatedRecords().size());
                for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
                    createdRecords.add(new OCommitResponse.OCreatedRecordResponse(entry.getKey(), (ORecordId)entry.getValue().getIdentity()));
                    if (entry.getValue().getVersion() <= 0) continue;
                    tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                }
                ArrayList<OCommitResponse.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommitResponse.OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
                for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
                    updatedRecords.add(new OCommitResponse.OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
                }
                OSBTreeCollectionManager oSBTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
                Object var6_14 = null;
                if (oSBTreeCollectionManager != null) {
                    Map map = oSBTreeCollectionManager.changedIds();
                }
                return new OCommitResponse(createdRecords, updatedRecords, (Map)var6_16);
            }
            catch (RuntimeException e) {
                if (this.connection != null && this.connection.getDatabase() != null) {
                    OSBTreeCollectionManager collectionManager;
                    if (this.connection.getDatabase().getTransaction().isActive()) {
                        this.connection.getDatabase().rollback(true);
                    }
                    if ((collectionManager = this.connection.getDatabase().getSbTreeCollectionManager()) != null) {
                        collectionManager.clearChangedIds();
                    }
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            if (tx.isActive()) {
                tx.rollback(true, -1);
            }
            throw e;
        }
    }

    public OBinaryResponse executeGetGlobalConfiguration(OGetGlobalConfigurationRequest request) {
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)request.getKey());
        String cfgValue = cfg != null ? (cfg.isHidden() ? "<hidden>" : cfg.getValueAsString()) : "";
        return new OGetGlobalConfigurationResponse(cfgValue);
    }

    public OBinaryResponse executeListGlobalConfigurations(OListGlobalConfigurationsRequest request) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
            String value;
            String key;
            try {
                key = cfg.getKey();
            }
            catch (Exception e) {
                key = "?";
            }
            if (cfg.isHidden()) {
                value = "<hidden>";
            } else {
                try {
                    OContextConfiguration config = this.connection.getProtocol().getServer().getContextConfiguration();
                    value = config.getValueAsString(cfg) != null ? config.getValueAsString(cfg) : "";
                }
                catch (Exception e) {
                    value = "";
                }
            }
            configs.put(key, value);
        }
        return new OListGlobalConfigurationsResponse(configs);
    }

    public OBinaryResponse executeFreezeDatabase(OFreezeDatabaseRequest request) {
        ODatabaseDocumentInternal database = this.server.openDatabase(request.getName(), this.connection.getServerUser().name, null, this.connection.getData(), true);
        this.connection.setDatabase(database);
        OLogManager.instance().info((Object)this, "Freezing database '%s'", new Object[]{this.connection.getDatabase().getURL()});
        this.connection.getDatabase().freeze(true);
        return new OFreezeDatabaseResponse();
    }

    public OBinaryResponse executeReleaseDatabase(OReleaseDatabaseRequest request) {
        ODatabaseDocumentInternal database = this.server.openDatabase(request.getName(), this.connection.getServerUser().name, null, this.connection.getData(), true);
        this.connection.setDatabase(database);
        OLogManager.instance().info((Object)this, "Realising database '%s'", new Object[]{this.connection.getDatabase().getURL()});
        this.connection.getDatabase().release();
        return new OReleaseDatabaseResponse();
    }

    public OBinaryResponse executeCleanOutRecord(OCleanOutRecordRequest request) {
        this.connection.getDatabase().cleanOutRecord((ORID)request.getRecordId(), request.getRecordVersion());
        if (request.getMode() < 2) {
            return new OCleanOutRecordResponse(true);
        }
        return null;
    }

    public OBinaryResponse executeSBTreeCreate(OSBTCreateTreeRequest request) {
        OBonsaiCollectionPointer collectionPointer = this.connection.getDatabase().getSbTreeCollectionManager().createSBTree(request.getClusterId(), null);
        return new OSBTCreateTreeResponse(collectionPointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBinaryResponse executeSBTGet(OSBTGetRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            OIdentifiable key = (OIdentifiable)tree.getKeySerializer().deserialize(request.getKeyStream(), 0);
            Integer result = (Integer)tree.get((Object)key);
            Object valueSerializer = result == null ? ONullSerializer.INSTANCE : tree.getValueSerializer();
            byte[] stream = new byte[1 + valueSerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(valueSerializer.getId()), stream, 0, new Object[0]);
            valueSerializer.serialize((Object)result, stream, 1, new Object[0]);
            OSBTGetResponse oSBTGetResponse = new OSBTGetResponse(stream);
            return oSBTGetResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBinaryResponse executeSBTFirstKey(OSBTFirstKeyRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            OIdentifiable result = (OIdentifiable)tree.firstKey();
            Object keySerializer = result == null ? ONullSerializer.INSTANCE : tree.getKeySerializer();
            byte[] stream = new byte[1 + keySerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(keySerializer.getId()), stream, 0, new Object[0]);
            keySerializer.serialize((Object)result, stream, 1, new Object[0]);
            OSBTFirstKeyResponse oSBTFirstKeyResponse = new OSBTFirstKeyResponse(stream);
            return oSBTFirstKeyResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBinaryResponse executeSBTFetchEntriesMajor(OSBTFetchEntriesMajorRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(request.getPointer());
        try {
            OBinarySerializer keySerializer = tree.getKeySerializer();
            OIdentifiable key = (OIdentifiable)keySerializer.deserialize(request.getKeyStream(), 0);
            OBinarySerializer valueSerializer = tree.getValueSerializer();
            OTreeInternal.AccumulativeListener listener = new OTreeInternal.AccumulativeListener(request.getPageSize());
            tree.loadEntriesMajor((Object)key, request.isInclusive(), true, (OTreeInternal.RangeResultListener)listener);
            List result = listener.getResult();
            OSBTFetchEntriesMajorResponse oSBTFetchEntriesMajorResponse = new OSBTFetchEntriesMajorResponse(keySerializer, valueSerializer, result);
            return oSBTFetchEntriesMajorResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBinaryResponse executeSBTGetRealSize(OSBTGetRealBagSizeRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            int realSize = tree.getRealBagSize(request.getChanges());
            OSBTGetRealBagSizeResponse oSBTGetRealBagSizeResponse = new OSBTGetRealBagSizeResponse(realSize);
            return oSBTGetRealBagSizeResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    public OBinaryResponse executeIncrementalBackup(OIncrementalBackupRequest request) {
        String fileName = this.connection.getDatabase().incrementalBackup(request.getBackupDirectory());
        return new OIncrementalBackupResponse(fileName);
    }

    public OBinaryResponse executeImport(OImportRequest request) {
        final ArrayList result = new ArrayList();
        OLogManager.instance().info((Object)this, "Starting database import", new Object[0]);
        try {
            ODatabaseImport imp = new ODatabaseImport(this.connection.getDatabase(), request.getImporPath(), new OCommandOutputListener(){

                public void onMessage(String iText) {
                    OLogManager.instance().debug((Object)OConnectionBinaryExecutor.this, iText, new Object[0]);
                    if (iText != null) {
                        result.add(iText);
                    }
                }
            });
            imp.setOptions(request.getImporPath());
            imp.importDatabase();
            imp.close();
            new File(request.getImporPath()).delete();
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new ODatabaseException("error on import"), (Throwable)e);
        }
        return new OImportResponse(result);
    }

    public OBinaryResponse executeConnect(OConnectRequest request) {
        this.connection.getData().driverName = request.getDriverName();
        this.connection.getData().driverVersion = request.getDriverVersion();
        this.connection.getData().protocolVersion = request.getProtocolVersion();
        this.connection.getData().clientId = request.getClientId();
        this.connection.getData().setSerializationImpl(request.getRecordFormat());
        this.connection.setTokenBased(request.isTokenBased());
        this.connection.getData().supportsPushMessages = request.isSupportPush();
        this.connection.getData().collectStats = request.isCollectStats();
        this.connection.setServerUser(this.server.serverLogin(request.getUsername(), request.getPassword(), "server.connect"));
        if (this.connection.getServerUser() == null) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance");
        }
        byte[] token = null;
        if (this.connection.getData().protocolVersion > 26) {
            this.connection.getData().serverUsername = this.connection.getServerUser().name;
            this.connection.getData().serverUser = true;
            token = Boolean.TRUE.equals(this.connection.getTokenBased()) ? this.server.getTokenHandler().getSignedBinaryToken(null, null, this.connection.getData()) : OCommonConst.EMPTY_BYTE_ARRAY;
        }
        return new OConnectResponse(this.connection.getId(), token);
    }

    public OBinaryResponse executeDatabaseOpen(OOpenRequest request) {
        this.connection.getData().driverName = request.getDriverName();
        this.connection.getData().driverVersion = request.getDriverVersion();
        this.connection.getData().protocolVersion = request.getProtocolVersion();
        this.connection.getData().clientId = request.getClientId();
        this.connection.getData().setSerializationImpl(request.getRecordFormat());
        this.connection.setTokenBased(request.isUseToken());
        this.connection.getData().supportsPushMessages = request.isSupportsPush();
        this.connection.getData().collectStats = request.isCollectStats();
        try {
            this.connection.setDatabase(this.server.openDatabase(request.getDatabaseName(), request.getUserName(), request.getUserPassword(), this.connection.getData()));
        }
        catch (OException e) {
            this.server.getClientConnectionManager().disconnect(this.connection);
            throw e;
        }
        byte[] token = null;
        if (Boolean.TRUE.equals(this.connection.getTokenBased())) {
            token = this.server.getTokenHandler().getSignedBinaryToken(this.connection.getDatabase(), this.connection.getDatabase().getUser(), this.connection.getData());
            this.server.getClientConnectionManager().connect(this.connection.getProtocol(), this.connection, token, this.server.getTokenHandler());
        }
        if (this.connection.getDatabase().getStorage() instanceof OStorageProxy) {
            this.connection.getDatabase().getMetadata().getSecurity().authenticate(request.getUserName(), request.getUserPassword());
        }
        Collection clusters = this.connection.getDatabase().getStorage().getClusterInstances();
        byte[] tokenToSend = Boolean.TRUE.equals(this.connection.getTokenBased()) ? token : OCommonConst.EMPTY_BYTE_ARRAY;
        Object plugin = this.server.getPlugin("cluster");
        byte[] distriConf = null;
        ODocument distributedCfg = null;
        if (plugin != null && plugin instanceof ODistributedServerManager) {
            distributedCfg = ((ODistributedServerManager)plugin).getClusterConfiguration();
            ODistributedConfiguration dbCfg = ((ODistributedServerManager)plugin).getDatabaseConfiguration(this.connection.getDatabase().getName());
            if (dbCfg != null) {
                distributedCfg.field("database", (Object)dbCfg.getDocument(), new OType[]{OType.EMBEDDED});
            }
            distriConf = OConnectionBinaryExecutor.getRecordBytes(this.connection, (ORecord)distributedCfg);
        }
        return new OOpenResponse(this.connection.getId(), tokenToSend, clusters, distriConf, OConstants.getVersion());
    }

    public OBinaryResponse executeShutdown(OShutdownRequest request) {
        OLogManager.instance().info((Object)this, "Received shutdown command from the remote client ", new Object[0]);
        String user = request.getRootUser();
        String passwd = request.getRootPassword();
        if (this.server.authenticate(user, passwd, "server.shutdown")) {
            OLogManager.instance().info((Object)this, "Remote client authenticated. Starting shutdown of server...", new Object[0]);
            this.runShutdownInNonDaemonThread();
            return new OShutdownResponse();
        }
        OLogManager.instance().error((Object)this, "Authentication error of remote client: shutdown is aborted.", new Object[0]);
        throw new OSecurityAccessException("Invalid user/password to shutdown the server");
    }

    private void runShutdownInNonDaemonThread() {
        Thread shutdownThread = new Thread("OrientDB server shutdown thread"){

            @Override
            public void run() {
                OConnectionBinaryExecutor.this.server.shutdown();
            }
        };
        shutdownThread.setDaemon(false);
        shutdownThread.start();
    }

    public OBinaryResponse executeReopen(OReopenRequest request) {
        return new OReopenResponse(this.connection.getId());
    }

    public OBinaryResponse executeSetGlobalConfig(OSetGlobalConfigurationRequest request) {
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)request.getKey());
        if (cfg != null) {
            cfg.setValue((Object)request.getValue());
            if (!cfg.isChangeableAtRuntime().booleanValue()) {
                throw new OConfigurationException("Property '" + request.getKey() + "' cannot be changed at runtime. Change the setting at startup");
            }
        } else {
            throw new OConfigurationException("Property '" + request.getKey() + "' was not found in global configuration");
        }
        return new OSetGlobalConfigurationResponse();
    }

    public static byte[] getRecordBytes(OClientConnection connection, ORecord iRecord) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        String name = connection.getData().getSerializationImpl();
        if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(name))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
            stream = ser.toStream(iRecord, false);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    public OBinaryResponse executeQuery(OQueryRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        long serverTimeout = database.getConfiguration().getValueAsLong(OGlobalConfiguration.COMMAND_TIMEOUT);
        if (database.getTransaction().isActive()) {
            ((OTransactionOptimistic)database.getTransaction()).resetChangesTracking();
        }
        OResultSet rs = request.isIdempotent() ? (request.isNamedParams() ? database.query(request.getStatement(), request.getNamedParameters()) : database.query(request.getStatement(), request.getPositionalParameters())) : (request.isNamedParams() ? database.execute(request.getLanguage(), request.getStatement(), request.getNamedParameters()) : database.execute(request.getLanguage(), request.getStatement(), request.getPositionalParameters()));
        OQueryResponse result = new OQueryResponse();
        OInternalResultSet rsCopy = new OInternalResultSet();
        rsCopy.setPlan((OExecutionPlan)rs.getExecutionPlan().orElse(null));
        for (int i = 0; rs.hasNext() && i < request.getRecordsPerPage(); ++i) {
            rsCopy.add(rs.next());
        }
        OLocalResultSetLifecycleDecorator item = new OLocalResultSetLifecycleDecorator(rsCopy, ((OLocalResultSetLifecycleDecorator)rs).getQueryId());
        item.setHasNextPage(rs.hasNext());
        boolean txChanges = false;
        if (database.getTransaction().isActive()) {
            txChanges = ((OTransactionOptimistic)database.getTransaction()).isChanged();
        }
        result.setResult(item);
        result.setTxChanges(txChanges);
        return result;
    }

    public OBinaryResponse closeQuery(OCloseQueryRequest oQueryRequest) {
        String queryId = oQueryRequest.getQueryId();
        ODatabaseDocumentInternal db = this.connection.getDatabase();
        OLocalResultSetLifecycleDecorator query = db.getActiveQuery(queryId);
        if (query == null) {
            throw new ODatabaseException("Cannot close query: " + oQueryRequest.getQueryId());
        }
        query.close();
        return new OCloseQueryResponse();
    }

    public OBinaryResponse executeQueryNextPage(OQueryNextPageRequest request) {
        long serverTimeout = this.connection.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.COMMAND_TIMEOUT);
        OLocalResultSetLifecycleDecorator rs = this.connection.getDatabase().getActiveQuery(request.getQueryId());
        OQueryResponse result = new OQueryResponse();
        OInternalResultSet rsCopy = new OInternalResultSet();
        rsCopy.setPlan((OExecutionPlan)rs.getExecutionPlan().orElse(null));
        for (int i = 0; rs.hasNext() && i < request.getRecordsPerPage(); ++i) {
            rsCopy.add(rs.next());
        }
        OLocalResultSetLifecycleDecorator item = new OLocalResultSetLifecycleDecorator(rsCopy, rs.getQueryId());
        item.setHasNextPage(rs.hasNext());
        result.setResult(item);
        return result;
    }

    public OBinaryResponse executeBeginTransaction(OBeginTransactionRequest request) {
        OTransactionOptimisticServer tx = new OTransactionOptimisticServer(this.connection.getDatabase(), request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
        try {
            this.connection.getDatabase().rawBegin((OTransaction)tx);
        }
        catch (ORecordNotFoundException e) {
            throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
        }
        return new OBeginTransactionResponse(tx.getId());
    }

    /*
     * WARNING - void declaration
     */
    public OBinaryResponse executeCommit37(OCommit37Request request) {
        void var7_13;
        OTransactionOptimisticServer tx;
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (request.isHasContent()) {
            tx = new OTransactionOptimisticServer(database, request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
            try {
                database.rawBegin((OTransaction)tx);
            }
            catch (ORecordNotFoundException e) {
                throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
            }
        } else {
            tx = (OTransactionOptimisticServer)database.getTransaction();
        }
        database.commit();
        ArrayList<OCommitResponse.OCreatedRecordResponse> createdRecords = new ArrayList<OCommitResponse.OCreatedRecordResponse>(tx.getCreatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
            createdRecords.add(new OCommitResponse.OCreatedRecordResponse(entry.getKey(), (ORecordId)entry.getValue().getIdentity()));
            if (entry.getValue().getVersion() <= 0) continue;
            tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
        }
        ArrayList<OCommitResponse.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommitResponse.OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
            updatedRecords.add(new OCommitResponse.OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
        }
        OSBTreeCollectionManager oSBTreeCollectionManager = database.getSbTreeCollectionManager();
        Object var7_11 = null;
        if (oSBTreeCollectionManager != null) {
            Map map = oSBTreeCollectionManager.changedIds();
        }
        return new OCommitResponse(createdRecords, updatedRecords, (Map)var7_13);
    }

    public OBinaryResponse executeFetchTransaction(OFetchTransactionRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (!database.getTransaction().isActive()) {
            throw new ODatabaseException("No Transaction Active");
        }
        OTransactionOptimistic tx = (OTransactionOptimistic)database.getTransaction();
        return new OFetchTransactionResponse(tx.getId(), (Iterable)tx.getAllRecordEntries(), tx.getIndexEntries());
    }

    public OBinaryResponse executeRollback(ORollbackTransactionRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (!database.getTransaction().isActive()) {
            throw new ODatabaseException("No Transaction Active");
        }
        database.rollback(true);
        return new ORollbackTransactionResponse();
    }
}

