/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.message.OErrorResponse;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.HandshakeInfo;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkBinaryProtocolFactory;
import com.orientechnologies.orient.server.plugin.OServerPluginHelper;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;

public class ONetworkProtocolBinary
extends ONetworkProtocol {
    protected final Level logClientExceptions;
    protected final boolean logClientFullStackTrace;
    protected OChannelBinary channel;
    protected volatile int requestType;
    protected int clientTxId;
    protected boolean okSent;
    private boolean tokenConnection = true;
    private long requests = 0L;
    private HandshakeInfo handshakeInfo;
    private Function<Integer, OBinaryRequest<? extends OBinaryResponse>> factory = ONetworkBinaryProtocolFactory.defaultProtocol();

    public ONetworkProtocolBinary(OServer server) {
        this(server, "OrientDB <- BinaryClient/?");
    }

    public ONetworkProtocolBinary(OServer server, String iThreadName) {
        super(server.getThreadGroup(), iThreadName);
        this.logClientExceptions = Level.parse(server.getContextConfiguration().getValueAsString(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL));
        this.logClientFullStackTrace = server.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE);
    }

    public void initVariables(OServer server, OChannelBinaryServer channel) {
        this.server = server;
        this.channel = channel;
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        OChannelBinaryServer channel = new OChannelBinaryServer(iSocket, iConfig);
        this.initVariables(iServer, channel);
        channel.writeShort((short)this.getVersion());
        channel.flush();
        this.start();
        this.setName("OrientDB (" + iSocket.getLocalSocketAddress() + ") <- BinaryClient (" + iSocket.getRemoteSocketAddress() + ")");
    }

    public void startup() {
        super.startup();
    }

    public void shutdown() {
        this.sendShutdown();
        this.channel.close();
    }

    private boolean isHandshaking(int requestType) {
        return requestType == 2 || requestType == 3 || requestType == 1 || requestType == 17;
    }

    private boolean isDistributed(int requestType) {
        return requestType == 120 || requestType == 121;
    }

    protected void execute() throws Exception {
        this.requestType = -1;
        if (this.isShutdownFlag()) {
            return;
        }
        this.clientTxId = 0;
        this.okSent = false;
        try {
            this.requestType = this.channel.readByte();
            if (this.requestType == 20) {
                this.handleHandshake();
                return;
            }
            this.clientTxId = this.channel.readInt();
            OClientConnection connection = this.server.getClientConnectionManager().getConnection(this.clientTxId, this);
            if (this.isDistributed(this.requestType)) {
                this.distributedRequest(connection, this.requestType, this.clientTxId);
            } else {
                this.sessionRequest(connection, this.requestType, this.clientTxId);
            }
        }
        catch (IOException e) {
            this.sendShutdown();
            throw e;
        }
    }

    private void handleHandshake() throws IOException {
        short protocolVersion = this.channel.readShort();
        String driverName = this.channel.readString();
        String driverVersion = this.channel.readString();
        this.handshakeInfo = new HandshakeInfo(protocolVersion, driverName, driverVersion);
        this.factory = ONetworkBinaryProtocolFactory.matchProtocol(protocolVersion);
    }

    public boolean shouldReadToken(OClientConnection connection, int requestType) {
        if (connection == null) {
            return !this.isHandshaking(requestType) || requestType == 17;
        }
        return Boolean.TRUE.equals(connection.getTokenBased()) && !this.isHandshaking(requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sessionRequest(OClientConnection connection, int requestType, int clientTxId) {
        long timer = 0L;
        timer = Orient.instance().getProfiler().startChrono();
        OLogManager.instance().debug((Object)this, "Request id:" + clientTxId + " type:" + requestType, new Object[0]);
        OBinaryRequest<? extends OBinaryResponse> request = this.factory.apply(requestType);
        if (request != null) {
            OBinaryResponse response;
            byte[] tokenBytes = null;
            try {
                if (this.shouldReadToken(connection, requestType)) {
                    tokenBytes = this.channel.readBytes();
                }
                int protocolVersion = 37;
                ORecordSerializerNetwork serializer = ORecordSerializerNetwork.INSTANCE;
                if (connection != null) {
                    protocolVersion = connection.getData().protocolVersion;
                    serializer = connection.getData().getSerializer();
                }
                request.read((OChannelDataInput)this.channel, protocolVersion, (ORecordSerializer)serializer);
            }
            catch (IOException e) {
                OLogManager.instance().debug((Object)this, "I/O Error on client clientId=%d reqType=%d", new Object[]{clientTxId, requestType, e});
                this.sendShutdown();
                Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
                ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
                return;
            }
            try {
                connection = this.isHandshaking(requestType) ? this.onBeforeHandshakeRequest(connection, tokenBytes) : this.onBeforeOperationalRequest(connection, tokenBytes);
                if (connection != null) {
                    connection.getData().commandInfo = request.getDescription();
                    connection.setProtocol(this);
                }
                if (request.requireServerUser()) {
                    this.checkServerAccess(request.requiredServerRole(), connection);
                }
                if (request.requireDatabaseSession()) {
                    if (connection == null) throw new ODatabaseException("Required database session");
                    if (connection.getDatabase() == null) {
                        throw new ODatabaseException("Required database session");
                    }
                }
                response = request.execute(connection.getExecutor());
            }
            catch (RuntimeException t) {
                OSBTreeCollectionManager collectionManager;
                if (connection != null && connection.getDatabase() != null && (collectionManager = connection.getDatabase().getSbTreeCollectionManager()) != null) {
                    collectionManager.clearChangedIds();
                }
                try {
                    this.okSent = true;
                    this.sendError(connection, clientTxId, t);
                }
                catch (IOException e) {
                    OLogManager.instance().debug((Object)this, "I/O Error on client clientId=%d reqType=%d", new Object[]{clientTxId, requestType, e});
                    this.sendShutdown();
                }
                Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
                ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
                return;
            }
            finally {
                ++this.requests;
                this.afterOperationRequest(connection);
            }
            if (response != null) {
                try {
                    this.beginResponse();
                    try {
                        this.sendOk(connection, clientTxId);
                        response.write((OChannelDataOutput)this.channel, (int)connection.getData().protocolVersion, connection.getData().getSerializer());
                    }
                    finally {
                        this.endResponse();
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().debug((Object)this, "I/O Error on client clientId=%d reqType=%d", new Object[]{clientTxId, requestType, e});
                    this.sendShutdown();
                }
            }
            this.tokenConnection = Boolean.TRUE.equals(connection.getTokenBased());
            return;
        }
        OLogManager.instance().error((Object)this, "Request not supported. Code: " + requestType, new Object[0]);
        this.handleConnectionError(connection, (Throwable)new ONetworkProtocolException("Request not supported. Code: " + requestType));
        this.sendShutdown();
        return;
        finally {
            Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void distributedRequest(OClientConnection connection, int requestType, int clientTxId) {
        long timer = 0L;
        try {
            timer = Orient.instance().getProfiler().startChrono();
            byte[] tokenBytes = this.channel.readBytes();
            connection = this.onBeforeOperationalRequest(connection, tokenBytes);
            OLogManager.instance().debug((Object)this, "Request id:" + clientTxId + " type:" + requestType, new Object[0]);
            try {
                switch (requestType) {
                    case 120: {
                        this.executeDistributedRequest(connection);
                        return;
                    }
                    case 121: {
                        this.executeDistributedResponse(connection);
                        return;
                    }
                }
                return;
            }
            finally {
                ++this.requests;
                this.afterOperationRequest(connection);
            }
        }
        catch (Throwable t) {
            OLogManager.instance().warn((Object)this, "I/O Error on distributed channel  clientId=%d reqType=%d", new Object[]{clientTxId, requestType, t});
            this.sendShutdown();
            return;
        }
        finally {
            Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
        }
    }

    private OClientConnection onBeforeHandshakeRequest(OClientConnection connection, byte[] tokenBytes) {
        try {
            if (this.requestType != 17) {
                if (this.clientTxId >= 0 && connection == null && (this.requestType == 3 || this.requestType == 2)) {
                    this.shutdown();
                    throw new OIOException("Found unknown session " + this.clientTxId);
                }
                connection = this.server.getClientConnectionManager().connect(this);
                connection.getData().sessionId = this.clientTxId;
                connection.setTokenBytes(null);
                connection.acquire();
            } else {
                connection.validateSession(tokenBytes, this.server.getTokenHandler(), this);
                this.server.getClientConnectionManager().disconnect(this.clientTxId);
                connection = this.server.getClientConnectionManager().reConnect(this, connection.getTokenBytes(), connection.getToken());
                connection.acquire();
                this.waitDistribuedIsOnline(connection);
                connection.init(this.server);
                if (connection.getData().serverUser) {
                    connection.setServerUser(this.server.getUser(connection.getData().serverUsername));
                }
            }
        }
        catch (RuntimeException e) {
            if (connection != null) {
                this.server.getClientConnectionManager().disconnect(connection);
            }
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw e;
        }
        connection.statsUpdate();
        OServerPluginHelper.invokeHandlerCallbackOnBeforeClientRequest(this.server, connection, (byte)this.requestType);
        return connection;
    }

    private OClientConnection onBeforeOperationalRequest(OClientConnection connection, byte[] tokenBytes) {
        try {
            if (connection == null && this.requestType == 5) {
                return null;
            }
            if (connection != null && !Boolean.TRUE.equals(connection.getTokenBased())) {
                connection.setTokenBytes(null);
                connection.acquire();
            } else {
                if (!this.tokenConnection) {
                    throw new OIOException("Found unknown session " + this.clientTxId);
                }
                if (connection == null && tokenBytes != null && tokenBytes.length > 0) {
                    connection = this.server.getClientConnectionManager().connect(this);
                    connection.setDisconnectOnAfter(true);
                }
                if (connection == null) {
                    throw new OTokenSecurityException("missing session and token");
                }
                connection.acquire();
                connection.validateSession(tokenBytes, this.server.getTokenHandler(), this);
                this.waitDistribuedIsOnline(connection);
                connection.init(this.server);
                if (connection.getData().serverUser) {
                    connection.setServerUser(this.server.getUser(connection.getData().serverUsername));
                }
            }
            connection.statsUpdate();
            OServerPluginHelper.invokeHandlerCallbackOnBeforeClientRequest(this.server, connection, (byte)this.requestType);
        }
        catch (RuntimeException e) {
            if (connection != null) {
                this.server.getClientConnectionManager().disconnect(connection);
            }
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw e;
        }
        return connection;
    }

    private void waitDistribuedIsOnline(OClientConnection connection) {
        ODistributedServerManager manager;
        if (this.requests == 0L && (manager = this.server.getDistributedManager()) != null && connection.getDatabase() != null) {
            try {
                ODistributedDatabase dDatabase = manager.getMessageService().getDatabase(connection.getDatabase().getName());
                if (dDatabase != null) {
                    dDatabase.waitForOnline();
                } else {
                    manager.waitUntilNodeOnline(manager.getLocalNodeName(), connection.getToken().getDatabase());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new OInterruptedException("Request interrupted");
            }
        }
    }

    protected void afterOperationRequest(OClientConnection connection) {
        OServerPluginHelper.invokeHandlerCallbackOnAfterClientRequest(this.server, connection, (byte)this.requestType);
        if (connection != null) {
            this.setDataCommandInfo(connection, "Listening");
            connection.endOperation();
            if (connection.isDisconnectOnAfter()) {
                this.server.getClientConnectionManager().disconnect(connection);
            }
        }
    }

    protected void checkServerAccess(String iResource, OClientConnection connection) {
        if (connection.getData().protocolVersion <= 26) {
            if (connection.getServerUser() == null) {
                throw new OSecurityAccessException("Server user not authenticated");
            }
            if (!this.server.isAllowed(connection.getServerUser().name, iResource)) {
                throw new OSecurityAccessException("User '" + connection.getServerUser().name + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        } else {
            if (!connection.getData().serverUser) {
                throw new OSecurityAccessException("Server user not authenticated");
            }
            if (!this.server.isAllowed(connection.getData().serverUsername, iResource)) {
                throw new OSecurityAccessException("User '" + connection.getData().serverUsername + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        }
    }

    private void executeDistributedRequest(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Distributed request");
        this.checkServerAccess("server.replication", connection);
        ODistributedServerManager manager = this.server.getDistributedManager();
        ODistributedRequest req = new ODistributedRequest(manager.getTaskFactory());
        req.fromStream(this.channel.getDataInput());
        String dbName = req.getDatabaseName();
        ODistributedDatabase ddb = null;
        if (dbName != null && (ddb = manager.getMessageService().getDatabase(dbName)) == null && req.getTask().isNodeOnlineRequired()) {
            throw new ODistributedException("Database configuration not found for database '" + req.getDatabaseName() + "'");
        }
        String senderNodeName = manager.getNodeNameById(req.getId().getNodeId());
        req.getTask().setNodeSource(senderNodeName);
        if (ddb != null) {
            ddb.processRequest(req, true);
        } else {
            manager.executeOnLocalNode(req.getId(), req.getTask(), null);
        }
    }

    private void executeDistributedResponse(OClientConnection connection) throws IOException {
        this.setDataCommandInfo(connection, "Distributed response");
        this.checkServerAccess("server.replication", connection);
        ODistributedServerManager manager = this.server.getDistributedManager();
        ODistributedResponse response = new ODistributedResponse();
        response.fromStream(this.channel.getDataInput());
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, manager.getLocalNodeName(), response.getExecutorNodeName(), ODistributedServerLog.DIRECTION.IN, "Executing distributed response %s", response);
        }
        while (manager.getMessageService() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        manager.getMessageService().dispatchResponseToThread(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(OClientConnection connection, int iClientTxId, Throwable t) throws IOException {
        this.channel.acquireWriteLock();
        try {
            this.channel.writeByte((byte)1);
            this.channel.writeInt(iClientTxId);
            if (this.tokenConnection && this.requestType != 2 && (this.requestType != 3 && this.requestType != 1 || connection != null && connection.getData() != null && connection.getData().protocolVersion <= 32) || this.requestType == 17) {
                if (connection != null && connection.getToken() != null) {
                    byte[] renewedToken = this.server.getTokenHandler().renewIfNeeded(connection.getToken());
                    this.channel.writeBytes(renewedToken);
                } else {
                    this.channel.writeBytes(new byte[0]);
                }
            }
            Throwable current = t instanceof OLockException && t.getCause() instanceof ODatabaseException ? t.getCause() : t;
            HashMap<String, String> messages = new HashMap<String, String>();
            for (Throwable it = current; it != null; it = it.getCause()) {
                messages.put(current.getClass().getName(), current.getMessage());
            }
            OMemoryStream memoryStream = new OMemoryStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)memoryStream);
            objectOutputStream.writeObject(current);
            objectOutputStream.flush();
            byte[] result = memoryStream.toByteArray();
            objectOutputStream.close();
            OErrorResponse error = new OErrorResponse(messages, result);
            int protocolVersion = 37;
            ORecordSerializerNetwork serializationImpl = ORecordSerializerNetwork.INSTANCE;
            if (connection != null) {
                protocolVersion = connection.getData().protocolVersion;
                serializationImpl = connection.getData().getSerializer();
            }
            error.write((OChannelDataOutput)this.channel, protocolVersion, (ORecordSerializer)serializationImpl);
            this.channel.flush();
            if (OLogManager.instance().isLevelEnabled(this.logClientExceptions)) {
                if (this.logClientFullStackTrace) {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", t, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                } else {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", null, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                this.shutdown();
            } else {
                OLogManager.instance().error((Object)this, "Error during sending an error to client", (Throwable)e, new Object[0]);
            }
        }
        finally {
            if (this.channel.getLockWrite().isHeldByCurrentThread()) {
                this.channel.releaseWriteLock();
            }
        }
    }

    protected void beginResponse() {
        this.channel.acquireWriteLock();
    }

    protected void endResponse() throws IOException {
        this.channel.flush();
        this.channel.releaseWriteLock();
    }

    protected void setDataCommandInfo(OClientConnection connection, String iCommandInfo) {
        if (connection != null) {
            connection.getData().commandInfo = iCommandInfo;
        }
    }

    protected void sendOk(OClientConnection connection, int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
        this.okSent = true;
        if (connection != null && Boolean.TRUE.equals(connection.getTokenBased()) && connection.getToken() != null && this.requestType != 2 && this.requestType != 3) {
            byte[] renewedToken = this.server.getTokenHandler().renewIfNeeded(connection.getToken());
            this.channel.writeBytes(renewedToken);
        }
    }

    protected void handleConnectionError(OClientConnection connection, Throwable e) {
        try {
            this.channel.flush();
        }
        catch (IOException e1) {
            OLogManager.instance().debug((Object)this, "Error during channel flush", (Throwable)e1, new Object[0]);
        }
        OLogManager.instance().error((Object)this, "Error executing request", e, new Object[0]);
        OServerPluginHelper.invokeHandlerCallbackOnClientError(this.server, connection, e);
    }

    public static String getRecordSerializerName(OClientConnection connection) {
        return connection.getData().getSerializationImpl();
    }

    @Override
    public int getVersion() {
        return 37;
    }

    public OChannelBinary getChannel() {
        return this.channel;
    }

    public static void writeIdentifiable(OChannelBinary channel, OClientConnection connection, OIdentifiable o) throws IOException {
        if (o == null) {
            channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            channel.writeShort((short)-3);
            channel.writeRID((ORID)o);
        } else {
            ONetworkProtocolBinary.writeRecord(channel, connection, o.getRecord());
        }
    }

    @Override
    public String getType() {
        return "binary";
    }

    protected void sendErrorOrDropConnection(OClientConnection connection, int iClientTxId, Throwable t) throws IOException {
        if (this.okSent || this.requestType == 5) {
            this.handleConnectionError(connection, t);
            this.sendShutdown();
        } else {
            this.okSent = true;
            this.sendError(connection, iClientTxId, t);
        }
    }

    public static byte[] getRecordBytes(OClientConnection connection, ORecord iRecord) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        String name = connection.getData().getSerializationImpl();
        if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(name))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
            stream = ser.toStream(iRecord, false);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    private static void writeRecord(OChannelBinary channel, OClientConnection connection, ORecord iRecord) throws IOException {
        channel.writeShort((short)0);
        channel.writeByte(ORecordInternal.getRecordType((ORecord)iRecord));
        channel.writeRID(iRecord.getIdentity());
        channel.writeVersion(iRecord.getVersion());
        try {
            byte[] stream = ONetworkProtocolBinary.getRecordBytes(connection, iRecord);
            int realLength = ONetworkProtocolBinary.trimCsvSerializedContent(connection, stream);
            channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            throw OException.wrapException((OException)new OSerializationException(message), (Throwable)e);
        }
    }

    protected static int trimCsvSerializedContent(OClientConnection connection, byte[] stream) {
        int realLength = stream.length;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db instanceof ODatabaseDocument && "ORecordDocument2csv".equals(connection.getData().getSerializationImpl())) {
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
        }
        return realLength;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getRemoteAddress() {
        Socket socket = this.getChannel().socket;
        if (socket != null) {
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            return remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        }
        return null;
    }
}

