/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OHttpGraphResponse
extends OHttpResponse {
    public OHttpGraphResponse(OHttpResponse iWrapped) {
        super(iWrapped.getOutputStream(), iWrapped.httpVersion, iWrapped.additionalHeaders, iWrapped.characterSet, iWrapped.serverInfo, iWrapped.sessionId, iWrapped.callbackFunction, iWrapped.keepAlive, iWrapped.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            return;
        }
        if (!mode.equalsIgnoreCase("graph")) {
            super.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, mode);
            return;
        }
        if (accept != null && accept.contains("text/csv")) {
            throw new IllegalArgumentException("Graph mode cannot accept '" + accept + "'");
        }
        try (ODatabaseDocumentInternal graph = ODatabaseRecordThreadLocal.INSTANCE.get();){
            Object v;
            HashSet<Object> vertices = new HashSet<Object>();
            HashSet<OEdge> edges = new HashSet<OEdge>();
            Iterator iIterator = OMultiValue.getMultiValueIterator((Object)iRecords);
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry == null || !(entry instanceof OIdentifiable) || (entry = ((OIdentifiable)entry).getRecord()) == null || !(entry instanceof OIdentifiable) || !(entry instanceof OElement)) continue;
                OElement element = (OElement)entry;
                if (element.isVertex()) {
                    vertices.add(element.asVertex().get());
                    continue;
                }
                if (!element.isEdge()) continue;
                OEdge edge = (OEdge)element.asEdge().get();
                vertices.add(edge.getTo());
                vertices.add(edge.getFrom());
                edges.add(edge);
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "");
            json.beginObject();
            json.beginObject((Object)"graph");
            json.beginCollection("vertices");
            for (OVertex oVertex : vertices) {
                json.beginObject();
                json.writeAttribute("@rid", (Object)oVertex.getIdentity());
                json.writeAttribute("@class", (Object)((OClass)oVertex.getSchemaType().get()).getName());
                for (OEdge e : oVertex.getEdges(ODirection.BOTH)) {
                    edges.add(e);
                }
                for (String field : oVertex.getPropertyNames()) {
                    v = oVertex.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginCollection("edges");
            for (OEdge oEdge : edges) {
                if (!vertices.contains(oEdge.getFrom()) || !vertices.contains(oEdge.getTo())) continue;
                json.beginObject();
                json.writeAttribute("@rid", (Object)oEdge.getIdentity());
                json.writeAttribute("@class", (Object)((OClass)oEdge.getSchemaType().get()).getName());
                json.writeAttribute("out", (Object)oEdge.getFrom().getIdentity());
                json.writeAttribute("in", (Object)oEdge.getTo().getIdentity());
                for (String field : oEdge.getPropertyNames()) {
                    v = oEdge.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            if (iAdditionalProperties != null) {
                for (Map.Entry entry : iAdditionalProperties.entrySet()) {
                    Object v2 = entry.getValue();
                    if (OMultiValue.isMultiValue(v2)) {
                        json.beginCollection(-1, true, (String)entry.getKey());
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(v2), buffer, null);
                        json.endCollection(-1, true);
                    } else {
                        json.writeAttribute((String)entry.getKey(), v2);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            json.endObject();
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
    }
}

