/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OServerCommandPostDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|database/*"};

    public OServerCommandPostDatabase() {
        super("database.create");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String type;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: database/<db>/<type>");
        iRequest.data.commandInfo = "Create database";
        String databaseName = urlParts[1];
        String storageMode = urlParts[2];
        String url = this.getStoragePath(databaseName, storageMode);
        String string = type = urlParts.length > 3 ? urlParts[3] : "document";
        if (url != null) {
            if (this.server.existsDatabase(databaseName)) {
                this.sendJsonError(iResponse, 409, "Conflict", "text/plain", "Database '" + databaseName + "' already exists.", null);
            } else {
                this.server.createDatabase(databaseName, ODatabaseType.valueOf((String)storageMode.toUpperCase()), null);
                try (ODatabaseDocumentInternal database = this.server.openDatabase(databaseName, this.serverUser, this.serverPassword, null, false);){
                    this.sendDatabaseInfo(iRequest, iResponse, database);
                }
            }
        } else {
            throw new OCommandExecutionException("The '" + storageMode + "' storage mode does not exists.");
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    protected String getStoragePath(String databaseName, String iStorageMode) {
        if (iStorageMode.equals("plocal")) {
            return iStorageMode + ":" + this.server.getDatabaseDirectory() + databaseName;
        }
        if (iStorageMode.equals("memory")) {
            return iStorageMode + ":" + databaseName;
        }
        return null;
    }

    protected void sendDatabaseInfo(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocumentInternal db) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer);
        json.beginObject();
        if (db.getMetadata().getSchema().getClasses() != null) {
            json.beginCollection(1, false, "classes");
            HashSet<String> exportedNames = new HashSet<String>();
            for (OClass cls : db.getMetadata().getSchema().getClasses()) {
                if (exportedNames.contains(cls.getName())) continue;
                try {
                    this.exportClass((ODatabaseDocument)db, json, cls);
                    exportedNames.add(cls.getName());
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on exporting class '" + cls + "'", (Throwable)e, new Object[0]);
                }
            }
            json.endCollection(1, true);
        }
        if (db.getClusterNames() != null) {
            json.beginCollection(1, false, "clusters");
            for (String clusterName : db.getClusterNames()) {
                OCluster cluster = db.getStorage().getClusterById(db.getClusterIdByName(clusterName));
                try {
                    json.beginObject(2, true, null);
                    json.writeAttribute(3, false, "id", (Object)cluster.getId());
                    json.writeAttribute(3, false, "name", (Object)clusterName);
                    json.writeAttribute(3, false, "records", (Object)(cluster.getEntries() - cluster.getTombstonesCount()));
                    json.writeAttribute(3, false, "size", (Object)"-");
                    json.writeAttribute(3, false, "filled", (Object)"-");
                    json.writeAttribute(3, false, "maxSize", (Object)"-");
                    json.writeAttribute(3, false, "files", (Object)"-");
                }
                catch (Exception e) {
                    json.writeAttribute(3, false, "records", (Object)"? (Unauthorized)");
                }
                json.endObject(2, false);
            }
            json.endCollection(1, true);
        }
        if (db.getUser() != null) {
            json.writeAttribute(1, false, "currentUser", (Object)db.getUser().getName());
        }
        json.beginCollection(1, false, "users");
        for (ODocument doc : db.getMetadata().getSecurity().getAllUsers()) {
            OUser user = new OUser(doc);
            json.beginObject(2, true, null);
            json.writeAttribute(3, false, "name", (Object)user.getName());
            json.writeAttribute(3, false, "roles", (Object)(user.getRoles() != null ? Arrays.toString(user.getRoles().toArray()) : "null"));
            json.endObject(2, false);
        }
        json.endCollection(1, true);
        json.beginCollection(1, true, "roles");
        for (ODocument doc : db.getMetadata().getSecurity().getAllRoles()) {
            ORole role = new ORole(doc);
            json.beginObject(2, true, null);
            json.writeAttribute(3, false, "name", (Object)role.getName());
            json.writeAttribute(3, false, "mode", (Object)role.getMode().toString());
            json.beginCollection(3, true, "rules");
            for (Map.Entry rule : role.getRules().entrySet()) {
                json.beginObject(4);
                json.writeAttribute(4, true, "name", rule.getKey());
                json.writeAttribute(4, false, "create", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_CREATE));
                json.writeAttribute(4, false, "read", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_READ));
                json.writeAttribute(4, false, "update", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_UPDATE));
                json.writeAttribute(4, false, "delete", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_DELETE));
                json.endObject(4, true);
            }
            json.endCollection(3, false);
            json.endObject(2, true);
        }
        json.endCollection(1, true);
        json.beginObject(1, true, (Object)"config");
        json.beginCollection(2, true, "values");
        json.writeObjects(3, true, null, (Object[][])new Object[][]{{"name", "dateFormat", "value", db.getStorage().getConfiguration().dateFormat}, {"name", "dateTimeFormat", "value", db.getStorage().getConfiguration().dateTimeFormat}, {"name", "localeCountry", "value", db.getStorage().getConfiguration().getLocaleCountry()}, {"name", "localeLanguage", "value", db.getStorage().getConfiguration().getLocaleLanguage()}, {"name", "definitionVersion", "value", db.getStorage().getConfiguration().version}});
        json.endCollection(2, true);
        json.beginCollection(2, true, "properties");
        if (db.getStorage().getConfiguration().getProperties() != null) {
            for (OStorageEntryConfiguration entry : db.getStorage().getConfiguration().getProperties()) {
                if (entry == null) continue;
                json.beginObject(3, true, null);
                json.writeAttribute(4, false, "name", (Object)entry.name);
                json.writeAttribute(4, false, "value", (Object)entry.value);
                json.endObject(3, true);
            }
        }
        json.endCollection(2, true);
        json.endObject(1, true);
        json.endObject();
        json.flush();
        iResponse.send(200, "OK", "application/json", buffer.toString(), null);
    }

    protected void exportClass(ODatabaseDocument db, OJSONWriter json, OClass cls) throws IOException {
        Set indexes;
        json.beginObject(2, true, null);
        json.writeAttribute(3, true, "name", (Object)cls.getName());
        json.writeAttribute(3, true, "superClass", (Object)(cls.getSuperClass() != null ? cls.getSuperClass().getName() : ""));
        json.writeAttribute(3, true, "alias", (Object)cls.getShortName());
        json.writeAttribute(3, true, "clusters", (Object)cls.getClusterIds());
        json.writeAttribute(3, true, "defaultCluster", (Object)cls.getDefaultClusterId());
        json.writeAttribute(3, true, "clusterSelection", (Object)cls.getClusterSelection().getName());
        try {
            json.writeAttribute(3, false, "records", (Object)db.countClass(cls.getName()));
        }
        catch (OSecurityAccessException e) {
            json.writeAttribute(3, false, "records", (Object)"? (Unauthorized)");
        }
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginCollection(3, true, "properties");
            for (OProperty prop : cls.properties()) {
                json.beginObject(4, true, null);
                json.writeAttribute(4, true, "name", (Object)prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute(4, true, "linkedClass", (Object)prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute(4, true, "linkedType", (Object)prop.getLinkedType().toString());
                }
                json.writeAttribute(4, true, "type", (Object)prop.getType().toString());
                json.writeAttribute(4, true, "mandatory", (Object)prop.isMandatory());
                json.writeAttribute(4, true, "readonly", (Object)prop.isReadonly());
                json.writeAttribute(4, true, "notNull", (Object)prop.isNotNull());
                json.writeAttribute(4, true, "min", (Object)prop.getMin());
                json.writeAttribute(4, true, "max", (Object)prop.getMax());
                json.endObject(3, true);
            }
            json.endCollection(1, true);
        }
        if (!(indexes = cls.getIndexes()).isEmpty()) {
            json.beginCollection(3, true, "indexes");
            for (OIndex index : indexes) {
                json.beginObject(4, true, null);
                json.writeAttribute(4, true, "name", (Object)index.getName());
                json.writeAttribute(4, true, "type", (Object)index.getType());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null && !indexDefinition.getFields().isEmpty()) {
                    json.writeAttribute(4, true, "fields", (Object)indexDefinition.getFields());
                }
                json.endObject(3, true);
            }
            json.endCollection(1, true);
        }
        json.endObject(1, false);
    }
}

