/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OTransactionOptimisticServer
extends OTransactionOptimistic {
    private final Map<ORID, ORecordOperation> tempEntries = new LinkedHashMap<ORID, ORecordOperation>();
    private final Map<ORecordId, ORecord> createdRecords = new HashMap<ORecordId, ORecord>();
    private final Map<ORecordId, ORecord> updatedRecords = new HashMap<ORecordId, ORecord>();
    private final int clientTxId;
    private List<ORecordOperationRequest> operations;
    private final List<IndexChange> indexChanges;

    public OTransactionOptimisticServer(ODatabaseDocumentInternal database, int txId, boolean usingLong, List<ORecordOperationRequest> operations, List<IndexChange> indexChanges) {
        super(database);
        this.clientTxId = txId;
        this.setUsingLog(usingLong);
        this.operations = operations;
        this.indexChanges = indexChanges;
    }

    public void begin() {
        super.begin();
        try {
            for (ORecordOperationRequest oRecordOperationRequest : this.operations) {
                ORecordOperation entry;
                byte recordStatus = oRecordOperationRequest.getType();
                ORecordId rid = (ORecordId)oRecordOperationRequest.getId();
                switch (recordStatus) {
                    case 3: {
                        entry = new ORecordOperation((OIdentifiable)oRecordOperationRequest.getRecord(), 3);
                        ORecordInternal.setIdentity((ORecord)oRecordOperationRequest.getRecord(), (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)oRecordOperationRequest.getRecord(), (int)0);
                        oRecordOperationRequest.getRecord().setDirty();
                        this.createdRecords.put(rid.copy(), entry.getRecord());
                        break;
                    }
                    case 1: {
                        int version = oRecordOperationRequest.getVersion();
                        entry = new ORecordOperation((OIdentifiable)oRecordOperationRequest.getRecord(), 1);
                        ORecordInternal.setIdentity((ORecord)oRecordOperationRequest.getRecord(), (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)oRecordOperationRequest.getRecord(), (int)version);
                        oRecordOperationRequest.getRecord().setDirty();
                        ORecordInternal.setContentChanged((ORecord)entry.getRecord(), (boolean)oRecordOperationRequest.isContentChanged());
                        break;
                    }
                    case 2: {
                        ORecord rec = rid.getRecord();
                        entry = new ORecordOperation((OIdentifiable)rec, 2);
                        int deleteVersion = oRecordOperationRequest.getVersion();
                        if (rec == null) {
                            throw new ORecordNotFoundException(rid.getIdentity());
                        }
                        ORecordInternal.setVersion((ORecord)rec, (int)deleteVersion);
                        entry.setRecord((OIdentifiable)rec);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.tempEntries.put(entry.getRecord().getIdentity(), entry);
            }
            this.operations = null;
            for (Map.Entry entry : this.tempEntries.entrySet()) {
                if (((ORecordOperation)entry.getValue()).type == 1) {
                    ORecord record = ((ORecordOperation)entry.getValue()).record.getRecord();
                    boolean contentChanged = ORecordInternal.isContentChanged((ORecord)record);
                    ORecord loadedRecord = record.getIdentity().copy().getRecord();
                    if (loadedRecord == null) {
                        throw new ORecordNotFoundException(record.getIdentity());
                    }
                    if (ORecordInternal.getRecordType((ORecord)loadedRecord) == 100 && ORecordInternal.getRecordType((ORecord)loadedRecord) == ORecordInternal.getRecordType((ORecord)record)) {
                        ((ODocument)loadedRecord).merge((ODocument)record, false, false);
                        loadedRecord.setDirty();
                        ORecordInternal.setContentChanged((ORecord)loadedRecord, (boolean)contentChanged);
                        ORecordInternal.setVersion((ORecord)loadedRecord, (int)record.getVersion());
                        ((ORecordOperation)entry.getValue()).record = loadedRecord;
                        this.updatedRecords.put((ORecordId)entry.getKey(), ((ORecordOperation)entry.getValue()).getRecord());
                    }
                }
                this.addRecord(((ORecordOperation)entry.getValue()).getRecord(), ((ORecordOperation)entry.getValue()).type, null);
            }
            this.tempEntries.clear();
            for (IndexChange indexChange : this.indexChanges) {
                TreeMap changesPerKey = new TreeMap(ODefaultComparator.INSTANCE);
                for (Map.Entry keyChange : indexChange.getKeyChanges().changesPerKey.entrySet()) {
                    Object key = keyChange.getKey();
                    if (key instanceof OIdentifiable && ((OIdentifiable)key).getIdentity().isNew()) {
                        key = ((OIdentifiable)key).getRecord();
                    }
                    OTransactionIndexChangesPerKey singleChange = new OTransactionIndexChangesPerKey(key);
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : ((OTransactionIndexChangesPerKey)keyChange.getValue()).entries) {
                        OIdentifiable rec = entry.value;
                        if (rec != null && rec.getIdentity().isNew()) {
                            rec = rec.getRecord();
                        }
                        singleChange.entries.add(new OTransactionIndexChangesPerKey.OTransactionIndexEntry(rec, entry.operation));
                    }
                    changesPerKey.put(key, singleChange);
                }
                indexChange.getKeyChanges().changesPerKey = changesPerKey;
                this.indexEntries.put(indexChange.getName(), indexChange.getKeyChanges());
            }
            for (ORecord oRecord : this.createdRecords.values()) {
                this.unmarshallRecord(oRecord);
                if (!(oRecord instanceof ODocument)) continue;
                ODocumentInternal.autoConvertValueToClass((ODatabaseDocumentInternal)this.getDatabase(), (ODocument)((ODocument)oRecord));
            }
            for (ORecord oRecord : this.updatedRecords.values()) {
                this.unmarshallRecord(oRecord);
            }
        }
        catch (Exception e) {
            this.rollback();
            throw OException.wrapException((OException)new OSerializationException("Cannot read transaction record from the network. Transaction aborted"), (Throwable)e);
        }
    }

    public ORecord getRecord(ORID rid) {
        ORecord record = super.getRecord(rid);
        if (record == OTransactionRealAbstract.DELETED_RECORD) {
            return record;
        }
        if (record == null && rid.isNew()) {
            record = this.createdRecords.get(rid);
        }
        return record;
    }

    public Map<ORecordId, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
        }
    }
}

