/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OBinaryPushResponse;
import com.orientechnologies.orient.client.remote.message.OPushDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OPushFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OPushIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OPushSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OPushSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OPushStorageConfigurationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OPushManager
implements OMetadataUpdateListener {
    protected final Set<WeakReference<ONetworkProtocolBinary>> distributedConfigPush = new HashSet<WeakReference<ONetworkProtocolBinary>>();
    protected final Map<String, Set<WeakReference<ONetworkProtocolBinary>>> storageConfigurations = new HashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();
    protected final Map<String, Set<WeakReference<ONetworkProtocolBinary>>> schema = new HashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();
    protected final Map<String, Set<WeakReference<ONetworkProtocolBinary>>> indexManager = new HashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();
    protected final Map<String, Set<WeakReference<ONetworkProtocolBinary>>> functions = new HashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();
    protected final Map<String, Set<WeakReference<ONetworkProtocolBinary>>> sequences = new HashMap<String, Set<WeakReference<ONetworkProtocolBinary>>>();
    private Set<String> registerDatabase = new HashSet<String>();

    public synchronized void pushDistributedConfig(String database, List<String> hosts) {
        Iterator<WeakReference<ONetworkProtocolBinary>> iter = this.distributedConfigPush.iterator();
        while (iter.hasNext()) {
            WeakReference<ONetworkProtocolBinary> ref = iter.next();
            ONetworkProtocolBinary protocolBinary = (ONetworkProtocolBinary)((Object)ref.get());
            if (protocolBinary != null) {
                OPushDistributedConfigurationRequest request = new OPushDistributedConfigurationRequest(hosts);
                try {
                    OBinaryPushResponse response = protocolBinary.push((OBinaryPushRequest)request);
                }
                catch (IOException e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
    }

    public synchronized void subscribeDistributeConfig(ONetworkProtocolBinary channel) {
        this.distributedConfigPush.add(new WeakReference<ONetworkProtocolBinary>(channel));
    }

    public synchronized void cleanPushSockets() {
        Iterator<WeakReference<ONetworkProtocolBinary>> iter = this.distributedConfigPush.iterator();
        while (iter.hasNext()) {
            if (iter.next().get() != null) continue;
            iter.remove();
        }
        this.cleanListeners(this.storageConfigurations);
        this.cleanListeners(this.schema);
        this.cleanListeners(this.indexManager);
        this.cleanListeners(this.functions);
        this.cleanListeners(this.sequences);
    }

    private void cleanListeners(Map<String, Set<WeakReference<ONetworkProtocolBinary>>> toClean) {
        for (Set<WeakReference<ONetworkProtocolBinary>> value : toClean.values()) {
            Iterator<WeakReference<ONetworkProtocolBinary>> iter = value.iterator();
            while (iter.hasNext()) {
                if (iter.next().get() != null) continue;
                iter.remove();
            }
        }
    }

    public void shutdown() {
    }

    private void genericSubscribe(Map<String, Set<WeakReference<ONetworkProtocolBinary>>> context, ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        Set<WeakReference<ONetworkProtocolBinary>> pushSockets;
        if (!this.registerDatabase.contains(database.getName())) {
            database.getSharedContext().registerListener((Object)this);
            this.registerDatabase.add(database.getName());
        }
        if ((pushSockets = context.get(database.getName())) == null) {
            pushSockets = new HashSet<WeakReference<ONetworkProtocolBinary>>();
            context.put(database.getName(), pushSockets);
        }
        pushSockets.add(new WeakReference<ONetworkProtocolBinary>(protocol));
    }

    public synchronized void subscribeStorageConfiguration(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.storageConfigurations, database, protocol);
    }

    public synchronized void subscribeSchema(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.schema, database, protocol);
    }

    public synchronized void subscribeIndexManager(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.indexManager, database, protocol);
    }

    public synchronized void subscribeFunctions(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.functions, database, protocol);
    }

    public synchronized void subscribeSequences(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.sequences, database, protocol);
    }

    public void onSchemaUpdate(String database, OSchemaShared schema) {
        OPushSchemaRequest request = new OPushSchemaRequest(schema.toNetworkStream());
        this.genericNotify(this.schema, database, (OBinaryPushRequest<?>)request);
    }

    public void onIndexManagerUpdate(String database, OIndexManager indexManager) {
        OPushIndexManagerRequest request = new OPushIndexManagerRequest(((OIndexManagerShared)indexManager).toNetworkStream());
        this.genericNotify(this.indexManager, database, (OBinaryPushRequest<?>)request);
    }

    public void onFunctionLibraryUpdate(String database) {
        OPushFunctionsRequest request = new OPushFunctionsRequest();
        this.genericNotify(this.functions, database, (OBinaryPushRequest<?>)request);
    }

    public void onSequenceLibraryUpdate(String database) {
        OPushSequencesRequest request = new OPushSequencesRequest();
        this.genericNotify(this.functions, database, (OBinaryPushRequest<?>)request);
    }

    public void onStorageConfigurationUpdate(String database, OStorageConfiguration update) {
        OPushStorageConfigurationRequest request = new OPushStorageConfigurationRequest(update);
        this.genericNotify(this.storageConfigurations, database, (OBinaryPushRequest<?>)request);
    }

    private void genericNotify(Map<String, Set<WeakReference<ONetworkProtocolBinary>>> context, String database, OBinaryPushRequest<?> request) {
        Orient.instance().submit(() -> {
            HashSet clients = null;
            OPushManager oPushManager = this;
            synchronized (oPushManager) {
                Set cl = (Set)context.get(database);
                if (cl != null) {
                    clients = new HashSet(cl);
                }
            }
            if (clients != null) {
                for (WeakReference ref : clients) {
                    ONetworkProtocolBinary protocolBinary = (ONetworkProtocolBinary)((Object)((Object)ref.get()));
                    if (protocolBinary != null) {
                        try {
                            OBinaryPushResponse response = protocolBinary.push(request);
                            continue;
                        }
                        catch (IOException e) {
                            OPushManager oPushManager2 = this;
                            synchronized (oPushManager2) {
                                ((Set)context.get(database)).remove(ref);
                                continue;
                            }
                        }
                    }
                    OPushManager oPushManager3 = this;
                    synchronized (oPushManager3) {
                        ((Set)context.get(database)).remove(ref);
                    }
                }
            }
        });
    }
}

