/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHookConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class OConfigurableHooksManager
implements ODatabaseLifecycleListener {
    private List<OServerHookConfiguration> configuredHooks;

    public OConfigurableHooksManager(OServerConfiguration iCfg) {
        this.configuredHooks = iCfg.hooks;
        if (this.configuredHooks != null && !this.configuredHooks.isEmpty()) {
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
    }

    public void addHook(OServerHookConfiguration configuration) {
        if (this.configuredHooks == null) {
            this.configuredHooks = new ArrayList<OServerHookConfiguration>();
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
        this.configuredHooks.add(configuration);
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    public void onCreate(ODatabaseInternal iDatabase) {
        this.onOpen(iDatabase);
    }

    public void onOpen(ODatabaseInternal iDatabase) {
        if (!iDatabase.getStorage().isRemote()) {
            ODatabaseInternal db = iDatabase;
            for (OServerHookConfiguration hook : this.configuredHooks) {
                try {
                    ORecordHook.HOOK_POSITION pos = ORecordHook.HOOK_POSITION.valueOf((String)hook.position);
                    Class<?> klass = Class.forName(hook.clazz);
                    Constructor<?> constructor = null;
                    try {
                        constructor = klass.getConstructor(ODatabaseDocument.class);
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                    ORecordHook h = constructor != null ? (ORecordHook)constructor.newInstance(iDatabase) : (ORecordHook)klass.newInstance();
                    if (hook.parameters != null && hook.parameters.length > 0) {
                        try {
                            Method m = h.getClass().getDeclaredMethod("config", OServerParameterConfiguration[].class);
                            m.invoke((Object)h, new Object[]{hook.parameters});
                        }
                        catch (Exception e) {
                            OLogManager.instance().warn((Object)this, "[configure] Failed to configure hook '%s'. Parameters specified but hook don support parameters. Should have a method config with parameters OServerParameterConfiguration[] ", new Object[]{hook.clazz});
                        }
                    }
                    db.registerHook(h, pos);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "[configure] Failed to configure hook '%s' due to the an error : ", (Throwable)e, new Object[]{hook.clazz, e.getMessage()});
                }
            }
        }
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    public void onDrop(ODatabaseInternal iDatabase) {
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    public String getName() {
        return "HookRegisters";
    }
}

