/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.command.OScriptInterceptor;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class OServerSideScriptInterpreter
extends OServerPluginAbstract {
    protected boolean enabled = false;
    protected Set<String> allowedLanguages = new HashSet<String>();
    protected OScriptInterceptor interceptor;

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (!Boolean.parseBoolean(param.value)) continue;
                this.enabled = true;
                continue;
            }
            if (param.name.equalsIgnoreCase("allowedLanguages")) {
                this.allowedLanguages = new HashSet<String>(Arrays.asList(param.value.toLowerCase(Locale.ENGLISH).split(",")));
                continue;
            }
            if (!param.name.equalsIgnoreCase("allowedPackages")) continue;
            Orient.instance().getScriptManager().addAllowedPackages(new HashSet<String>(Arrays.asList(param.value.split(","))));
        }
    }

    public String getName() {
        return "script-interpreter";
    }

    @Override
    public void startup() {
        OCommandManager.instance().unregisterExecutor(OCommandScript.class);
        if (!this.enabled) {
            return;
        }
        OCommandManager.instance().registerExecutor(OCommandScript.class, OCommandExecutorScript.class, (OCallable)new OCallable<Void, OCommandRequest>(){

            public Void call(OCommandRequest iArgument) {
                String language = ((OCommandScript)iArgument).getLanguage().toLowerCase(Locale.ENGLISH);
                if (!OServerSideScriptInterpreter.this.allowedLanguages.contains(language)) {
                    throw new OSecurityException("Language '" + language + "' is not allowed to be executed");
                }
                return null;
            }
        });
        this.interceptor = (db, language, script, params) -> {
            if (!this.allowedLanguages.contains(language)) {
                throw new OSecurityException("Language '" + language + "' is not allowed to be executed");
            }
        };
        OCommandManager.instance().getScriptExecutors().entrySet().forEach(e -> ((OScriptExecutor)e.getValue()).registerInterceptor(this.interceptor));
        OLogManager.instance().warn((Object)this, "Authenticated clients can execute any kind of code into the server by using the following allowed languages: " + this.allowedLanguages, new Object[0]);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        if (this.interceptor != null) {
            OCommandManager.instance().getScriptExecutors().entrySet().forEach(e -> ((OScriptExecutor)e.getValue()).unregisterInterceptor(this.interceptor));
        }
        OCommandManager.instance().unregisterExecutor(OCommandScript.class);
    }
}

