/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.put;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPutIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"PUT|index/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: index/<database>/<index-name>/<key>[/<value>]");
        iRequest.data.commandInfo = "Index put";
        try (ODatabaseDocumentInternal db = null;){
            ORecordId record;
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex index = db.getMetadata().getIndexManager().getIndex(urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            if (urlParts.length > 4) {
                record = new ORecordId(urlParts[4]);
            } else {
                if (iRequest.content == null || iRequest.content.length() == 0) {
                    throw new IllegalArgumentException("Index's entry value is null");
                }
                record = new ODocument().fromJSON(iRequest.content);
            }
            OIndexDefinition indexDefinition = index.getDefinition();
            Object key = indexDefinition != null ? indexDefinition.createValue(new Object[]{urlParts[3]}) : urlParts[3];
            if (key == null) {
                throw new IllegalArgumentException("Invalid key value : " + urlParts[3]);
            }
            boolean existent = record.getIdentity().isPersistent();
            if (existent && record instanceof ORecord) {
                ((ORecord)record).save();
            }
            index.put(key, (OIdentifiable)record);
            if (existent) {
                iResponse.send(200, "OK", "text/plain", null, null);
            } else {
                iResponse.send(201, "Created", "text/plain", null, null);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

