/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OBinaryPushResponse;
import com.orientechnologies.orient.client.remote.message.OPushDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OPushFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OPushIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OPushSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OPushSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OPushStorageConfigurationRequest;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.server.OPushEventType;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OPushManager
implements OMetadataUpdateListener {
    protected final Set<WeakReference<ONetworkProtocolBinary>> distributedConfigPush = new HashSet<WeakReference<ONetworkProtocolBinary>>();
    protected final OPushEventType storageConfigurations = new OPushEventType();
    protected final OPushEventType schema = new OPushEventType();
    protected final OPushEventType indexManager = new OPushEventType();
    protected final OPushEventType functions = new OPushEventType();
    protected final OPushEventType sequences = new OPushEventType();
    private Set<String> registerDatabase = new HashSet<String>();
    private final ExecutorService executor = new ThreadPoolExecutor(0, 5, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new PushThreadFactory());

    public synchronized void pushDistributedConfig(String database, List<String> hosts) {
        Iterator<WeakReference<ONetworkProtocolBinary>> iter = this.distributedConfigPush.iterator();
        while (iter.hasNext()) {
            WeakReference<ONetworkProtocolBinary> ref = iter.next();
            ONetworkProtocolBinary protocolBinary = (ONetworkProtocolBinary)((Object)ref.get());
            if (protocolBinary != null) {
                OPushDistributedConfigurationRequest request = new OPushDistributedConfigurationRequest(hosts);
                try {
                    OBinaryPushResponse oBinaryPushResponse = protocolBinary.push((OBinaryPushRequest)request);
                }
                catch (IOException e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
    }

    public synchronized void subscribeDistributeConfig(ONetworkProtocolBinary channel) {
        this.distributedConfigPush.add(new WeakReference<ONetworkProtocolBinary>(channel));
    }

    public synchronized void cleanPushSockets() {
        Iterator<WeakReference<ONetworkProtocolBinary>> iter = this.distributedConfigPush.iterator();
        while (iter.hasNext()) {
            if (iter.next().get() != null) continue;
            iter.remove();
        }
        this.storageConfigurations.cleanListeners();
        this.schema.cleanListeners();
        this.indexManager.cleanListeners();
        this.functions.cleanListeners();
        this.sequences.cleanListeners();
    }

    private void cleanListeners(Map<String, Set<WeakReference<ONetworkProtocolBinary>>> toClean) {
        for (Set<WeakReference<ONetworkProtocolBinary>> value : toClean.values()) {
            Iterator<WeakReference<ONetworkProtocolBinary>> iter = value.iterator();
            while (iter.hasNext()) {
                if (iter.next().get() != null) continue;
                iter.remove();
            }
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private void genericSubscribe(OPushEventType context, ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        if (!this.registerDatabase.contains(database.getName())) {
            database.getSharedContext().registerListener((Object)this);
            this.registerDatabase.add(database.getName());
        }
        context.subscribe(database.getName(), protocol);
    }

    public synchronized void subscribeStorageConfiguration(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.storageConfigurations, database, protocol);
    }

    public synchronized void subscribeSchema(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.schema, database, protocol);
    }

    public synchronized void subscribeIndexManager(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.indexManager, database, protocol);
    }

    public synchronized void subscribeFunctions(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.functions, database, protocol);
    }

    public synchronized void subscribeSequences(ODatabaseDocumentInternal database, ONetworkProtocolBinary protocol) {
        this.genericSubscribe(this.sequences, database, protocol);
    }

    public void onSchemaUpdate(String database, OSchemaShared schema) {
        OPushSchemaRequest request = new OPushSchemaRequest(schema.toNetworkStream());
        this.schema.send(database, (OBinaryPushRequest<?>)request, this);
    }

    public void onIndexManagerUpdate(String database, OIndexManager indexManager) {
        OPushIndexManagerRequest request = new OPushIndexManagerRequest(((OIndexManagerShared)indexManager).toNetworkStream());
        this.indexManager.send(database, (OBinaryPushRequest<?>)request, this);
    }

    public void onFunctionLibraryUpdate(String database) {
        OPushFunctionsRequest request = new OPushFunctionsRequest();
        this.functions.send(database, (OBinaryPushRequest<?>)request, this);
    }

    public void onSequenceLibraryUpdate(String database) {
        OPushSequencesRequest request = new OPushSequencesRequest();
        this.sequences.send(database, (OBinaryPushRequest<?>)request, this);
    }

    public void onStorageConfigurationUpdate(String database, OStorageConfiguration update) {
        OPushStorageConfigurationRequest request = new OPushStorageConfigurationRequest(update);
        this.storageConfigurations.send(database, (OBinaryPushRequest<?>)request, this);
    }

    public void genericNotify(Map<String, Set<WeakReference<ONetworkProtocolBinary>>> context, String database, OPushEventType pack) {
        try {
            this.executor.submit(() -> {
                HashSet clients = null;
                OPushManager oPushManager = this;
                synchronized (oPushManager) {
                    Set cl = (Set)context.get(database);
                    if (cl != null) {
                        clients = new HashSet(cl);
                    }
                }
                if (clients != null) {
                    for (WeakReference ref : clients) {
                        ONetworkProtocolBinary protocolBinary = (ONetworkProtocolBinary)((Object)((Object)ref.get()));
                        if (protocolBinary != null) {
                            OPushManager oPushManager2;
                            try {
                                OBinaryPushRequest<?> request = pack.getRequest(database);
                                if (request == null) continue;
                                oPushManager2 = protocolBinary.push(request);
                                continue;
                            }
                            catch (IOException e) {
                                oPushManager2 = this;
                                synchronized (oPushManager2) {
                                    ((Set)context.get(database)).remove(ref);
                                    continue;
                                }
                            }
                        }
                        OPushManager oPushManager3 = this;
                        synchronized (oPushManager3) {
                            ((Set)context.get(database)).remove(ref);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            OLogManager.instance().info((Object)this, "Cannot send push request to client for database '%s'", new Object[]{database});
        }
    }

    private static class PushThreadFactory
    implements ThreadFactory {
        private PushThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setName("Push Requests");
            return th;
        }
    }
}

