/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.UUID;

public class OSystemDatabase {
    public static final String SYSTEM_DB_NAME = "OSystem";
    public static final String SERVER_INFO_CLASS = "ServerInfo";
    public static final String SERVER_ID_PROPERTY = "serverId";
    private final OrientDBInternal context;
    private String serverId;

    public OSystemDatabase(OrientDBInternal context) {
        this.context = context;
        this.init();
    }

    public String getSystemDatabaseName() {
        return SYSTEM_DB_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster(String className, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try (ODatabaseDocumentInternal sysdb = this.openSystemDatabase();){
            if (!sysdb.existsCluster(clusterName)) {
                OSchema schema = sysdb.getMetadata().getSchema();
                OClass cls = schema.getClass(className);
                if (cls != null) {
                    cls.addCluster(clusterName);
                } else {
                    OLogManager.instance().error((Object)this, "createCluster() Class name %s does not exist", null, new Object[]{className});
                }
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODatabaseDocumentInternal openSystemDatabase() {
        return this.context.openNoAuthorization(this.getSystemDatabaseName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(OCallable<Object, OResultSet> callback, String sql, Object ... args) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            OResultSet result;
            ODatabaseDocumentInternal db;
            block10: {
                Object object;
                db = this.openSystemDatabase();
                try {
                    result = db.command(sql, args);
                    if (callback == null) break block10;
                    object = callback.call((Object)result);
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
                return object;
            }
            OResultSet oResultSet = result;
            db.close();
            return oResultSet;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODocument save(ODocument document) {
        return this.save(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument save(ODocument document, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal db;
            block10: {
                ODocument oDocument;
                db = this.openSystemDatabase();
                try {
                    if (clusterName == null) break block10;
                    oDocument = (ODocument)db.save((Object)document, clusterName);
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
                return oDocument;
            }
            ODocument oDocument = (ODocument)db.save((Object)document);
            db.close();
            return oDocument;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        ODatabaseDocumentInternal oldDbInThread = tl != null ? tl.getIfDefined() : null;
        try {
            if (!this.exists()) {
                OLogManager.instance().info((Object)this, "Creating the system database '%s' for current server", new Object[]{SYSTEM_DB_NAME});
                OrientDBConfig config = OrientDBConfig.builder().addConfig(OGlobalConfiguration.CREATE_DEFAULT_USERS, (Object)false).addConfig(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)1).build();
                this.context.create(SYSTEM_DB_NAME, null, null, ODatabaseType.PLOCAL, config);
            }
            this.checkServerId();
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.instance().set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkServerId() {
        try (ODatabaseDocumentInternal db = this.openSystemDatabase();){
            OClass clazz = db.getClass(SERVER_INFO_CLASS);
            if (clazz == null) {
                clazz = db.createClass(SERVER_INFO_CLASS, new String[0]);
            }
            OElement info = clazz.count() == 0L ? db.newElement(SERVER_INFO_CLASS) : (OElement)db.browseClass(clazz.getName()).next();
            this.serverId = (String)info.getProperty(SERVER_ID_PROPERTY);
            if (this.serverId == null) {
                this.serverId = UUID.randomUUID().toString();
                info.setProperty(SERVER_ID_PROPERTY, (Object)this.serverId);
                info.save();
            }
        }
    }

    public void executeInDBScope(OCallable<Void, ODatabaseSession> callback) {
        this.executeWithDB(callback);
    }

    /*
     * Loose catch block
     */
    public <T> T executeWithDB(OCallable<T, ODatabaseSession> callback) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            Object object;
            try (ODatabaseDocumentInternal db = this.openSystemDatabase();){
                object = callback.call((Object)db);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public boolean exists() {
        return this.context.exists(this.getSystemDatabaseName(), null, null);
    }

    public String getServerId() {
        return this.serverId;
    }
}

