/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class OServerCommandPostInstallDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|installDatabase"};

    public OServerCommandPostInstallDatabase() {
        super("database.create");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        Path folder;
        this.checkSyntax(iRequest.url, 1, "Syntax error: installDatabase");
        iRequest.data.commandInfo = "Import database";
        String url = iRequest.content;
        String name = this.getDbName(url);
        if (name != null) {
            folder = Paths.get(this.server.getDatabaseDirectory(), name);
            if (Files.exists(folder, new LinkOption[0]) && OLocalPaginatedStorage.exists((Path)folder)) {
                throw new ODatabaseException("Database named '" + name + "' already exists: ");
            }
        } else {
            throw new IllegalArgumentException("Could not find database name");
        }
        Files.createDirectories(folder, new FileAttribute[0]);
        URL uri = new URL(url);
        URLConnection conn = uri.openConnection();
        conn.setRequestProperty("User-Agent", "OrientDB-Studio");
        conn.setDefaultUseCaches(false);
        OZIPCompressionUtil.uncompressDirectory((InputStream)conn.getInputStream(), (String)folder.toString(), (OCommandOutputListener)new OCommandOutputListener(){

            public void onMessage(String iText) {
            }
        });
        iResponse.send(200, "OK", "text/plain", null, null);
        return false;
    }

    protected String getDbName(String url) {
        int idx;
        String name = null;
        if (url != null && (idx = url.lastIndexOf("/")) != -1) {
            name = url.substring(idx + 1).replace(".zip", "");
        }
        return name;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

