/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;

public class OServerCommandPostServer
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|server/*"};

    public OServerCommandPostServer() {
        super("server.settings");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 3, "Syntax error: server/<setting-name>/<setting-value>");
        iRequest.getData().commandInfo = "Change server settings";
        if (urlParts[1] == null || urlParts.length == 0) {
            throw new IllegalArgumentException("setting-name is null or empty");
        }
        String settingName = urlParts[1];
        String settingValue = urlParts[2];
        if (settingName.startsWith("configuration.")) {
            this.changeConfiguration(iResponse, settingName.substring("configuration.".length()), settingValue);
        } else if (settingName.startsWith("log.")) {
            this.changeLogLevel(iResponse, settingName.substring("log.".length()), settingValue);
        } else {
            iResponse.send(400, "Bad request", "text/plain", "setting-name '" + settingName + "' is not supported", null);
        }
        return false;
    }

    private void changeConfiguration(OHttpResponse iResponse, String settingName, String settingValue) throws IOException {
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)settingName);
        if (cfg != null) {
            Object oldValue = cfg.getValue();
            cfg.setValue((Object)settingValue);
            iResponse.send(200, "OK", "text/plain", "Server global configuration '" + settingName + "' update successfully. Old value was '" + oldValue + "', new value is '" + settingValue + "'", null);
        } else {
            iResponse.send(400, "Bad request", "text/plain", "Server global configuration '" + settingName + "' is invalid", null);
        }
    }

    private void changeLogLevel(OHttpResponse iResponse, String settingName, String settingValue) throws IOException {
        if (settingName.equals("console")) {
            OLogManager.instance().setConsoleLevel(settingValue);
        } else if (settingName.equals("file")) {
            OLogManager.instance().setFileLevel(settingValue);
        } else {
            iResponse.send(400, "Bad request", "text/plain", "log name '" + settingName + "' is not supported. Use 'console' or 'log'", null);
        }
        iResponse.send(200, "OK", "text/plain", "Server log configuration '" + settingName + "' update successfully", null);
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

