/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSession;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;
import java.util.Map;

public abstract class OServerCommandAuthenticatedServerAbstract
extends OServerCommandAbstract {
    private static final String SESSIONID_UNAUTHORIZED = "-";
    private static final String SESSIONID_LOGOUT = "!";
    private final String resource;
    protected String serverUser;
    protected String serverPassword;

    protected OServerCommandAuthenticatedServerAbstract(String iRequiredResource) {
        this.resource = iRequiredResource;
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        super.beforeExecute(iRequest, iResponse);
        return this.authenticate(iRequest, iResponse, true);
    }

    protected boolean authenticate(OHttpRequest iRequest, OHttpResponse iResponse, boolean iAskForAuthentication, String resource) throws IOException {
        if (this.checkGuestAccess()) {
            iResponse.setSessionId(null);
            return true;
        }
        if (iAskForAuthentication && (iRequest.getAuthorization() == null || SESSIONID_LOGOUT.equals(iRequest.getSessionId()))) {
            this.sendAuthorizationRequest(iRequest, iResponse);
            return false;
        }
        if (iRequest.getAuthorization() != null) {
            String[] authParts = iRequest.getAuthorization().split(":");
            if (authParts.length != 2) {
                this.sendAuthorizationRequest(iRequest, iResponse);
                return false;
            }
            this.serverUser = authParts[0];
            this.serverPassword = authParts[1];
            if (authParts.length == 2 && this.server.authenticate(this.serverUser, this.serverPassword, resource)) {
                return true;
            }
        }
        this.sendNotAuthorizedResponse(iRequest, iResponse);
        return false;
    }

    protected boolean authenticate(OHttpRequest iRequest, OHttpResponse iResponse, boolean iAskForAuthentication) throws IOException {
        return this.authenticate(iRequest, iResponse, iAskForAuthentication, this.resource);
    }

    protected boolean checkGuestAccess() {
        return this.server.isAllowed("guest", this.resource);
    }

    protected void sendNotAuthorizedResponse(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        this.sendAuthorizationRequest(iRequest, iResponse);
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        iRequest.setSessionId(SESSIONID_UNAUTHORIZED);
        String header = null;
        String xRequestedWithHeader = iRequest.getHeader("X-Requested-With");
        if (xRequestedWithHeader == null || !xRequestedWithHeader.equals("XMLHttpRequest")) {
            header = this.server.getSecurity().getAuthenticationHeader(null);
            Map headers = this.server.getSecurity().getAuthenticationHeaders(null);
            headers.entrySet().forEach(s -> iResponse.addHeader((String)s.getKey(), (String)s.getValue()));
        }
        if (this.isJsonResponse(iResponse)) {
            this.sendJsonError(iResponse, 401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        } else {
            iResponse.send(401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        }
    }

    public String getUser(OHttpRequest iRequest) {
        String[] authParts;
        OHttpSession session = this.server.getHttpSessionManager().getSession(iRequest.getSessionId());
        if (session != null) {
            return session.getUserName();
        }
        if (iRequest.getAuthorization() != null && (authParts = iRequest.getAuthorization().split(":")).length == 2) {
            return authParts[0];
        }
        return null;
    }

    public String getResource() {
        return this.resource;
    }
}

