/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public class OrientTokenHandler
extends OServerPluginAbstract
implements OTokenHandler,
OServerPlugin {
    public static final String SIGN_KEY_PAR = "oAuth2Key";
    public static final String SESSION_LENGTH_PAR = "sessionLength";
    public static final String ENCRYPTION_ALGORITHM_PAR = "encryptionAlgorithm";

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        String key = null;
        Long baseSession = null;
        String algorithm = null;
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (param.name.equalsIgnoreCase(SIGN_KEY_PAR)) {
                key = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase(SESSION_LENGTH_PAR)) {
                baseSession = Long.parseLong(param.value);
                continue;
            }
            if (!param.name.equalsIgnoreCase(ENCRYPTION_ALGORITHM_PAR)) continue;
            algorithm = param.value;
            try {
                Mac.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new IllegalArgumentException("Cannot find encryption algorithm '" + algorithm + "'", nsa);
            }
        }
        if (key != null) {
            OGlobalConfiguration.NETWORK_TOKEN_SECRETKEY.setValue(key);
        }
        if (baseSession != null) {
            OGlobalConfiguration.NETWORK_TOKEN_EXPIRE_TIMEOUT.setValue(baseSession);
        }
        if (algorithm != null) {
            OGlobalConfiguration.NETWORK_TOKEN_ENCRYPTION_ALGORITHM.setValue(algorithm);
        }
    }

    @Override
    public OToken parseWebToken(byte[] tokenBytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean validateToken(OToken token, String command, String database) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean validateBinaryToken(OToken token) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSignedWebToken(ODatabaseDocument db, OSecurityUser user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSignedBinaryToken(ODatabaseDocumentInternal db, OSecurityUser user, ONetworkProtocolData data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ONetworkProtocolData getProtocolDataFromToken(OClientConnection oClientConnection, OToken token) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OToken parseBinaryToken(byte[] binaryToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OToken parseNotVerifyBinaryToken(byte[] tokenBytes) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "OTokenHandler";
    }

    @Override
    public byte[] renewIfNeeded(OToken token) {
        throw new UnsupportedOperationException();
    }

    public long getSessionInMills() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

