/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OTransactionOptimisticServer
extends OTransactionOptimistic {
    protected final Map<ORID, ORecordOperation> tempEntries = new LinkedHashMap<ORID, ORecordOperation>();
    protected final Map<ORecordId, ORecord> createdRecords = new HashMap<ORecordId, ORecord>();
    protected final Map<ORecordId, ORecord> updatedRecords = new HashMap<ORecordId, ORecord>();
    protected final Set<ORID> deletedRecord = new HashSet<ORID>();
    protected final int clientTxId;
    protected final List<IndexChange> indexChanges;
    protected Map<ORID, ORecordOperation> oldTxEntries;
    protected List<ORecordOperationRequest> operations;

    public OTransactionOptimisticServer(ODatabaseDocumentInternal database, int txId, boolean usingLong, List<ORecordOperationRequest> operations, List<IndexChange> indexChanges) {
        super(database);
        if (database.getTransaction().isActive()) {
            this.newObjectCounter = ((OTransactionRealAbstract)database.getTransaction()).getNewObjectCounter();
        }
        this.clientTxId = txId;
        this.setUsingLog(usingLong);
        this.operations = operations;
        this.indexChanges = indexChanges;
        if (database.getTransaction().isActive()) {
            this.oldTxEntries = new HashMap<ORID, ORecordOperation>();
            for (ORecordOperation op : ((OTransactionOptimistic)database.getTransaction()).getRecordOperations()) {
                this.oldTxEntries.put(op.getRID(), op);
            }
        }
    }

    public void begin() {
        super.begin();
        try {
            ArrayList<ORecordOperation> toMergeUpdates = new ArrayList<ORecordOperation>();
            for (ORecordOperationRequest oRecordOperationRequest : this.operations) {
                ORecordOperation entry;
                byte recordStatus = oRecordOperationRequest.getType();
                ORecordId rid = (ORecordId)oRecordOperationRequest.getId();
                switch (recordStatus) {
                    case 3: {
                        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(oRecordOperationRequest.getRecordType(), rid.getClusterId(), this.getDatabase());
                        ORecordSerializerNetworkV37.INSTANCE.fromStream(oRecordOperationRequest.getRecord(), record);
                        entry = new ORecordOperation((OIdentifiable)record, 3);
                        ORecordInternal.setIdentity((ORecord)record, (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)record, (int)0);
                        record.setDirty();
                        this.createdRecords.put(rid.copy(), entry.getRecord());
                        break;
                    }
                    case 1: {
                        byte type = oRecordOperationRequest.getRecordType();
                        if (type == 10) {
                            int version = oRecordOperationRequest.getVersion();
                            ORecord updated = (ORecord)this.database.load((ORID)rid);
                            if (updated == null) {
                                updated = new ODocument();
                            }
                            ((ODocument)updated).deserializeFields(new String[0]);
                            ODocumentInternal.clearTransactionTrackData((ODocument)((ODocument)updated));
                            ODocumentSerializerDelta delta = ODocumentSerializerDelta.instance();
                            delta.deserializeDelta(oRecordOperationRequest.getRecord(), (ODocument)updated);
                            entry = new ORecordOperation((OIdentifiable)updated, 1);
                            ORecordInternal.setIdentity((ORecord)updated, (ORecordId)rid);
                            ORecordInternal.setVersion((ORecord)updated, (int)version);
                            updated.setDirty();
                            ORecordInternal.setContentChanged((ORecord)entry.getRecord(), (boolean)oRecordOperationRequest.isContentChanged());
                            this.updatedRecords.put(rid, updated);
                            break;
                        }
                        int version = oRecordOperationRequest.getVersion();
                        ORecord updated = Orient.instance().getRecordFactoryManager().newInstance(oRecordOperationRequest.getRecordType(), rid.getClusterId(), this.getDatabase());
                        ORecordSerializerNetworkV37.INSTANCE.fromStream(oRecordOperationRequest.getRecord(), updated);
                        entry = new ORecordOperation((OIdentifiable)updated, 1);
                        ORecordInternal.setIdentity((ORecord)updated, (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)updated, (int)version);
                        updated.setDirty();
                        ORecordInternal.setContentChanged((ORecord)entry.getRecord(), (boolean)oRecordOperationRequest.isContentChanged());
                        toMergeUpdates.add(entry);
                        break;
                    }
                    case 2: {
                        ORecord rec = rid.getRecord();
                        entry = new ORecordOperation((OIdentifiable)rec, 2);
                        int deleteVersion = oRecordOperationRequest.getVersion();
                        if (rec == null) {
                            throw new ORecordNotFoundException(rid.getIdentity());
                        }
                        ORecordInternal.setVersion((ORecord)rec, (int)deleteVersion);
                        entry.setRecord((OIdentifiable)rec);
                        this.deletedRecord.add(rec.getIdentity());
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.tempEntries.put(entry.getRecord().getIdentity(), entry);
            }
            this.operations = null;
            for (ORecordOperation oRecordOperation : toMergeUpdates) {
                ORecord record = oRecordOperation.record.getRecord();
                boolean contentChanged = ORecordInternal.isContentChanged((ORecord)record);
                ORecord loadedRecord = record.getIdentity().copy().getRecord();
                if (loadedRecord == null) {
                    throw new ORecordNotFoundException(record.getIdentity());
                }
                if (ORecordInternal.getRecordType((ORecord)loadedRecord) != 100 || ORecordInternal.getRecordType((ORecord)loadedRecord) != ORecordInternal.getRecordType((ORecord)record)) continue;
                ((ODocument)loadedRecord).merge((ODocument)record, false, false);
                loadedRecord.setDirty();
                ORecordInternal.setContentChanged((ORecord)loadedRecord, (boolean)contentChanged);
                ORecordInternal.setVersion((ORecord)loadedRecord, (int)record.getVersion());
                oRecordOperation.record = loadedRecord;
                this.updatedRecords.put((ORecordId)oRecordOperation.getRID(), oRecordOperation.getRecord());
            }
            for (Map.Entry entry : this.tempEntries.entrySet()) {
                this.database.getLocalCache().updateRecord(((ORecordOperation)entry.getValue()).getRecord());
                this.addRecord(((ORecordOperation)entry.getValue()).getRecord(), ((ORecordOperation)entry.getValue()).type, null, this.oldTxEntries);
            }
            this.tempEntries.clear();
            for (IndexChange indexChange : this.indexChanges) {
                TreeMap changesPerKey = new TreeMap(ODefaultComparator.INSTANCE);
                for (Map.Entry keyChange : indexChange.getKeyChanges().changesPerKey.entrySet()) {
                    Object key = keyChange.getKey();
                    if (key instanceof OIdentifiable && !((OIdentifiable)key).getIdentity().isPersistent()) {
                        key = ((OIdentifiable)key).getRecord();
                    }
                    if (key instanceof OCompositeKey) {
                        key = this.checkCompositeKeyId((OCompositeKey)key);
                    }
                    OTransactionIndexChangesPerKey singleChange = new OTransactionIndexChangesPerKey(key);
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : ((OTransactionIndexChangesPerKey)keyChange.getValue()).getEntriesAsList()) {
                        OIdentifiable rec = entry.getValue();
                        if (rec != null && !rec.getIdentity().isPersistent()) {
                            rec = rec.getRecord();
                        }
                        singleChange.add(rec, entry.getOperation());
                    }
                    changesPerKey.put(key, singleChange);
                }
                indexChange.getKeyChanges().changesPerKey = changesPerKey;
                if (indexChange.getKeyChanges().nullKeyChanges != null) {
                    OTransactionIndexChangesPerKey singleChange = new OTransactionIndexChangesPerKey(null);
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : indexChange.getKeyChanges().nullKeyChanges.getEntriesAsList()) {
                        OIdentifiable rec = entry.getValue();
                        if (rec != null && !rec.getIdentity().isPersistent()) {
                            rec = rec.getRecord();
                        }
                        singleChange.add(rec, entry.getOperation());
                    }
                    indexChange.getKeyChanges().nullKeyChanges = singleChange;
                }
                this.indexEntries.put(indexChange.getName(), indexChange.getKeyChanges());
            }
            this.newObjectCounter = (this.createdRecords.size() + 2) * -1;
            for (ORecord oRecord : this.createdRecords.values()) {
                this.unmarshallRecord(oRecord);
                if (!(oRecord instanceof ODocument)) continue;
                ODocumentInternal.autoConvertValueToClass((ODatabaseDocumentInternal)this.getDatabase(), (ODocument)((ODocument)oRecord));
            }
            for (ORecord oRecord : this.updatedRecords.values()) {
                this.unmarshallRecord(oRecord);
            }
            this.oldTxEntries = null;
        }
        catch (Exception e) {
            this.rollback();
            throw OException.wrapException((OException)((Object)new OSerializationException("Cannot read transaction record from the network. Transaction aborted")), (Throwable)e);
        }
    }

    public int getClientTransactionId() {
        return this.clientTxId;
    }

    protected OCompositeKey checkCompositeKeyId(OCompositeKey key) {
        OCompositeKey newKey = new OCompositeKey();
        for (Object o : key.getKeys()) {
            if (o instanceof OIdentifiable && !((OIdentifiable)o).getIdentity().isPersistent()) {
                o = ((OIdentifiable)o).getRecord();
            }
            if (o instanceof OCompositeKey) {
                o = this.checkCompositeKeyId((OCompositeKey)o);
            }
            newKey.addKey(o);
        }
        return newKey;
    }

    public ORecord getRecord(ORID rid) {
        ORecord record = super.getRecord(rid);
        if (record == OBasicTransaction.DELETED_RECORD) {
            return record;
        }
        if (record == null && rid.isNew()) {
            record = this.createdRecords.get(rid);
        }
        return record;
    }

    public Map<ORecordId, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    public Set<ORID> getDeletedRecord() {
        return this.deletedRecord;
    }

    protected void unmarshallRecord(ORecord iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
        }
    }

    private boolean checkCallHooks(Map<ORID, ORecordOperation> oldTx, ORID id, byte type) {
        if (oldTx != null) {
            ORecordOperation entry = oldTx.get(id);
            return entry == null || entry.getType() != type;
        }
        return true;
    }

    public ORecordOperation addRecord(ORecord iRecord, byte iStatus, String iClusterName) {
        ORecordOperation operation = super.addRecord(iRecord, iStatus, iClusterName);
        if (iStatus == 1) {
            this.updatedRecords.put((ORecordId)iRecord.getIdentity(), iRecord);
        } else if (iStatus == 3) {
            this.createdRecords.put((ORecordId)iRecord.getIdentity().copy(), iRecord);
        } else if (iStatus == 2) {
            this.deletedRecord.add(iRecord.getIdentity());
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(ORecord iRecord, byte iStatus, String iClusterName, Map<ORID, ORecordOperation> oldTx) {
        this.changed = true;
        this.checkTransaction();
        if (iStatus != 0) {
            this.changedDocuments.remove(iRecord);
        }
        boolean callHooks = this.checkCallHooks(oldTx, iRecord.getIdentity(), (byte)iStatus);
        try {
            if (callHooks) {
                switch (iStatus) {
                    case 3: {
                        OIdentifiable res = this.database.beforeCreateOperations((OIdentifiable)iRecord, iClusterName);
                        if (res == null) break;
                        iRecord = (ORecord)res;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        OIdentifiable res = this.database.beforeUpdateOperations((OIdentifiable)iRecord, iClusterName);
                        if (res == null) break;
                        iRecord = (ORecord)res;
                        break;
                    }
                    case 2: {
                        this.database.beforeDeleteOperations((OIdentifiable)iRecord, iClusterName);
                    }
                }
            }
            try {
                ORecordOperation txEntry;
                ORecordId rid = (ORecordId)iRecord.getIdentity();
                if (!rid.isPersistent() && !rid.isTemporary()) {
                    ORecordId oldRid = rid.copy();
                    if (rid.getClusterPosition() == -1L) {
                        ORecordInternal.onBeforeIdentityChanged((ORecord)iRecord);
                        rid.setClusterPosition((long)this.newObjectCounter--);
                        this.updatedRids.put(oldRid, rid);
                        ORecordInternal.onAfterIdentityChanged((ORecord)iRecord);
                    }
                }
                if ((txEntry = this.getRecordEntry((ORID)rid)) == null) {
                    int status = iStatus;
                    if (status == 1 && iRecord.getIdentity().isTemporary()) {
                        status = 3;
                    }
                    txEntry = new ORecordOperation((OIdentifiable)iRecord, (byte)status);
                    this.allEntries.put(rid.copy(), txEntry);
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            switch (iStatus) {
                                case 2: {
                                    this.allEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
                if (callHooks) {
                    switch (iStatus) {
                        case 3: {
                            this.database.afterCreateOperations((OIdentifiable)iRecord);
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.database.afterUpdateOperations((OIdentifiable)iRecord);
                            break;
                        }
                        case 2: {
                            this.database.afterDeleteOperations((OIdentifiable)iRecord);
                        }
                    }
                } else {
                    switch (iStatus) {
                        case 3: {
                            if (!(iRecord instanceof ODocument)) break;
                            OClassIndexManager.checkIndexesAfterCreate((ODocument)((ODocument)iRecord), (ODatabaseDocumentInternal)this.getDatabase());
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (!(iRecord instanceof ODocument)) break;
                            OClassIndexManager.checkIndexesAfterUpdate((ODocument)((ODocument)iRecord), (ODatabaseDocumentInternal)this.getDatabase());
                            break;
                        }
                        case 2: {
                            if (!(iRecord instanceof ODocument)) break;
                            OClassIndexManager.checkIndexesAfterDelete((ODocument)((ODocument)iRecord), (ODatabaseDocumentInternal)this.getDatabase());
                        }
                    }
                }
                if (iRecord instanceof ODocument && ((ODocument)iRecord).isTrackingChanges()) {
                    ODocumentInternal.clearTrackData((ODocument)((ODocument)iRecord));
                }
            }
            catch (Exception e) {
                if (callHooks) {
                    switch (iStatus) {
                        case 3: {
                            this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, (OIdentifiable)iRecord);
                            break;
                        }
                        case 1: {
                            this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, (OIdentifiable)iRecord);
                            break;
                        }
                        case 2: {
                            this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)iRecord);
                        }
                    }
                }
                throw OException.wrapException((OException)((Object)new ODatabaseException("Error on saving record " + iRecord.getIdentity())), (Throwable)e);
            }
        }
        finally {
            if (callHooks) {
                switch (iStatus) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, (OIdentifiable)iRecord);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, (OIdentifiable)iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, (OIdentifiable)iRecord);
                    }
                }
            }
        }
    }

    public void assignClusters() {
        for (ORecordOperation entry : this.allEntries.values()) {
            ORecordId rid = (ORecordId)entry.getRID();
            ORecord record = entry.getRecord();
            if (rid.isPersistent() || rid.isTemporary()) continue;
            ORecordId oldRid = rid.copy();
            ORecordInternal.onBeforeIdentityChanged((ORecord)record);
            this.database.assignAndCheckCluster(record, null);
            this.updatedRids.put(rid.copy(), oldRid);
            ORecordInternal.onAfterIdentityChanged((ORecord)record);
        }
    }

    public void addIndexEntry(OIndex delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue) {
        super.addIndexEntry(delegate, iIndexName, iOperation, key, iValue);
        this.changed = true;
    }

    public void addIndexEntry(OIndex delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue, boolean clientTrackOnly) {
        super.addIndexEntry(delegate, iIndexName, iOperation, key, iValue, clientTrackOnly);
        this.changed = true;
    }
}

