/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.memorymanager;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.memorymanager.MemoryManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public final class MXBeanMemoryManager
implements NotificationListener,
MemoryManager {
    private final int memoryThreshold;
    private final int sleepInterval;
    private final ConcurrentLinkedQueue<String> poolsWithOverhead = new ConcurrentLinkedQueue();
    private volatile HashMap<String, MemoryPoolMXBean> memoryBeans;

    public MXBeanMemoryManager(int memoryThreshold, int sleepInterval) {
        this.memoryThreshold = memoryThreshold;
        this.sleepInterval = sleepInterval;
        assert (sleepInterval >= 0);
        assert (memoryThreshold >= 0 && memoryThreshold < 100);
    }

    @Override
    public void start() {
        HashMap<String, MemoryPoolMXBean> beansByName = new HashMap<String, MemoryPoolMXBean>();
        if (this.memoryThreshold <= 0) {
            return;
        }
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(this, null, null);
        List<MemoryPoolMXBean> mxBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mxBean : mxBeans) {
            long maxMemory;
            if (!mxBean.isUsageThresholdSupported() || mxBean.getType() != MemoryType.HEAP || (maxMemory = mxBean.getUsage().getMax()) <= 0L) continue;
            long threshold = maxMemory * (long)this.memoryThreshold / 100L;
            mxBean.setUsageThreshold(threshold);
            beansByName.put(mxBean.getName(), mxBean);
            OLogManager.instance().infoNoDb((Object)this, "Memory usage threshold for memory pool '%s' is set to %d bytes", new Object[]{mxBean.getName(), threshold});
        }
        this.memoryBeans = beansByName;
    }

    @Override
    public void shutdown() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        try {
            emitter.removeNotificationListener(this);
        }
        catch (ListenerNotFoundException e) {
            throw new IllegalStateException("Memory manager was not added as a listener", e);
        }
    }

    @Override
    public void checkAndWaitMemoryThreshold() {
        if (this.poolsWithOverhead.isEmpty()) {
            return;
        }
        while (!this.poolsWithOverhead.isEmpty()) {
            String poolName = this.poolsWithOverhead.peek();
            MemoryPoolMXBean bean = this.memoryBeans.get(poolName);
            while (bean.isUsageThresholdExceeded()) {
                LockSupport.parkNanos((long)this.sleepInterval * 1000000L);
            }
            this.poolsWithOverhead.poll();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String notificationType = notification.getType();
        if (notificationType.equals("java.management.memory.threshold.exceeded")) {
            CompositeData cd = (CompositeData)notification.getUserData();
            MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
            this.poolsWithOverhead.add(info.getPoolName());
        }
    }
}

